/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.ColorSpaceHintKey;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.Any2LumRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class FilterAsAlphaRed
extends AbstractRed {
    public FilterAsAlphaRed(CachableRed cachableRed) {
        super(new Any2LumRed(cachableRed), cachableRed.getBounds(), (ColorModel)new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0), (SampleModel)new PixelInterleavedSampleModel(0, cachableRed.getSampleModel().getWidth(), cachableRed.getSampleModel().getHeight(), 1, cachableRed.getSampleModel().getWidth(), new int[]{0}), cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), null);
        this.props.put("org.apache.batik.gvt.filter.Colorspace", ColorSpaceHintKey.VALUE_COLORSPACE_ALPHA);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        SampleModel sampleModel = cachableRed.getSampleModel();
        if (sampleModel.getNumBands() == 1) {
            return cachableRed.copyData(writableRaster);
        }
        Raster raster = cachableRed.getData(writableRaster.getBounds());
        PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)raster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        PixelInterleavedSampleModel pixelInterleavedSampleModel2 = (PixelInterleavedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte2 = (DataBufferByte)writableRaster.getDataBuffer();
        byte[] byArray2 = dataBufferByte2.getData();
        int n = raster.getMinX() - raster.getSampleModelTranslateX();
        int n2 = raster.getMinY() - raster.getSampleModelTranslateY();
        int n3 = writableRaster.getMinX() - writableRaster.getSampleModelTranslateX();
        int n4 = n3 + writableRaster.getWidth() - 1;
        int n5 = writableRaster.getMinY() - writableRaster.getSampleModelTranslateY();
        int n6 = pixelInterleavedSampleModel.getPixelStride();
        int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
        int n7 = nArray[0];
        int n8 = nArray[1];
        if (cachableRed.getColorModel().isAlphaPremultiplied()) {
            int n9 = 0;
            while (n9 < raster.getHeight()) {
                int n10 = dataBufferByte.getOffset() + pixelInterleavedSampleModel.getOffset(n, n2);
                int n11 = dataBufferByte2.getOffset() + pixelInterleavedSampleModel2.getOffset(n3, n5);
                int n12 = dataBufferByte2.getOffset() + pixelInterleavedSampleModel2.getOffset(n4 + 1, n5);
                n10 += n7;
                while (n11 < n12) {
                    byArray2[n11++] = byArray[n10];
                    n10 += n6;
                }
                ++n2;
                ++n5;
                ++n9;
            }
        } else {
            n8 -= n7;
            int n13 = 0;
            while (n13 < raster.getHeight()) {
                int n14 = dataBufferByte.getOffset() + pixelInterleavedSampleModel.getOffset(n, n2);
                int n15 = dataBufferByte2.getOffset() + pixelInterleavedSampleModel2.getOffset(n3, n5);
                int n16 = dataBufferByte2.getOffset() + pixelInterleavedSampleModel2.getOffset(n4 + 1, n5);
                n14 += n7;
                while (n15 < n16) {
                    int n17 = byArray[n14] & 0xFF;
                    int n18 = byArray[n14 + n8] & 0xFF;
                    byArray2[n15++] = (byte)(n17 * n18 + 128 >> 8);
                    n14 += n6;
                }
                ++n2;
                ++n5;
                ++n13;
            }
        }
        return writableRaster;
    }
}

