/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup.figures;

import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.gmf.gmfgraph.Alignment;
import org.eclipse.gmf.gmfgraph.BorderLayout;
import org.eclipse.gmf.gmfgraph.BorderLayoutData;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.LabeledContainer;
import org.eclipse.gmf.gmfgraph.Layout;
import org.eclipse.gmf.gmfgraph.LayoutData;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.gmf.tests.setup.DiaDefSetup;
import org.eclipse.gmf.tests.setup.figures.AbstractFigureGeneratorSetup;
import org.eclipse.gmf.tests.setup.figures.FigureGeneratorUtil;

public class LabelSupportSetup
extends AbstractFigureGeneratorSetup {
    private FigureDescriptor myCustom;
    private FigureDescriptor mySimple;
    private FigureDescriptor myLabeledContainer;
    private FigureDescriptor myRoot;

    protected void addFigures(FigureGallery gallery) {
        gallery.getDescriptors().add((Object)this.getCustom());
        gallery.getDescriptors().add((Object)this.getSimple());
        gallery.getDescriptors().add((Object)this.getLabeledContainer());
        gallery.getDescriptors().add((Object)this.getRoot());
    }

    public FigureDescriptor getRoot() {
        if (this.myRoot == null) {
            Rectangle rootFigure = GMFGraphFactory.eINSTANCE.createRectangle();
            this.myRoot = DiaDefSetup.newDescriptor("Root", (Figure)rootFigure);
            BorderLayout layout = GMFGraphFactory.eINSTANCE.createBorderLayout();
            this.myRoot.getActualFigure().setLayout((Layout)layout);
            RoundedRectangle padding = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
            padding.setName("Padding");
            BorderLayoutData paddingData = GMFGraphFactory.eINSTANCE.createBorderLayoutData();
            paddingData.setAlignment(Alignment.FILL_LITERAL);
            padding.setLayoutData((LayoutData)paddingData);
            Rectangle intermediateLabelContainer = GMFGraphFactory.eINSTANCE.createRectangle();
            intermediateLabelContainer.setName("intermediateLabelContainer");
            BorderLayoutData labelData = GMFGraphFactory.eINSTANCE.createBorderLayoutData();
            labelData.setAlignment(Alignment.BEGINNING_LITERAL);
            labelData.setVertical(true);
            intermediateLabelContainer.setLayoutData((LayoutData)labelData);
            rootFigure.getChildren().add((Object)intermediateLabelContainer);
            rootFigure.getChildren().add((Object)padding);
            this.addLabel(this.myRoot, (RealFigure)intermediateLabelContainer);
        }
        return this.myRoot;
    }

    public FigureDescriptor getLabeledContainer() {
        if (this.myLabeledContainer == null) {
            LabeledContainer fig = GMFGraphFactory.eINSTANCE.createLabeledContainer();
            this.myLabeledContainer = DiaDefSetup.newDescriptor("LabeledContainerAlreadyHasLabel_DoesItNeedOneMore", (Figure)fig);
            this.addLabel(this.myLabeledContainer, (RealFigure)fig);
        }
        return this.myLabeledContainer;
    }

    public FigureDescriptor getSimple() {
        if (this.mySimple == null) {
            Rectangle simpleFig = GMFGraphFactory.eINSTANCE.createRectangle();
            this.mySimple = DiaDefSetup.newDescriptor("SimpleParent", (Figure)simpleFig);
            this.addLabel(this.mySimple, (RealFigure)simpleFig);
        }
        return this.mySimple;
    }

    public FigureDescriptor getCustom() {
        if (this.myCustom == null) {
            CustomFigure fig = GMFGraphFactory.eINSTANCE.createCustomFigure();
            fig.setQualifiedClassName(RectangleFigure.class.getName());
            this.myCustom = DiaDefSetup.newDescriptor("CustomParent", (Figure)fig);
            this.addLabel(this.myCustom, (RealFigure)fig);
        }
        return this.myCustom;
    }

    private void addLabel(FigureDescriptor fd, RealFigure parent) {
        parent.setPreferredSize(FigureGeneratorUtil.createDimension(60, 60));
        Label label = GMFGraphFactory.eINSTANCE.createLabel();
        parent.getChildren().add((Object)label);
        DiaDefSetup.newAccess(fd, (RealFigure)label).setAccessor("Typename");
    }
}

