/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.parts;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.gef.ui.rulers.RulerComposite;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.action.ActionManager;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.common.ui.util.IPartSelector;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TreeContainerEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TreeDiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TreeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.actions.InsertAction;
import org.eclipse.gmf.runtime.diagram.ui.internal.actions.PromptingDeleteAction;
import org.eclipse.gmf.runtime.diagram.ui.internal.actions.PromptingDeleteFromModelAction;
import org.eclipse.gmf.runtime.diagram.ui.internal.actions.ToggleRouterAction;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.DiagramRootTreeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.l10n.DiagramUIPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.PageInfoHelper;
import org.eclipse.gmf.runtime.diagram.ui.internal.parts.DiagramGraphicalViewerKeyHandler;
import org.eclipse.gmf.runtime.diagram.ui.internal.parts.DirectEditKeyHandler;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.DiagramRuler;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.DiagramRulerProvider;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditorInput;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.providers.DiagramContextMenuProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.draw2d.ui.internal.parts.ScrollableThumbnailEx;
import org.eclipse.gmf.runtime.draw2d.ui.internal.parts.ThumbnailEx;
import org.eclipse.gmf.runtime.emf.commands.core.command.EditingDomainUndoContext;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.GuideStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public abstract class DiagramEditor
extends GraphicalEditor
implements IDiagramWorkbenchPart,
ITabbedPropertySheetPageContributor,
IShowInSource {
    public static String DIAGRAM_CONTEXT_ID = "org.eclipse.gmf.runtime.diagram.ui.diagramContext";
    protected static final int ID_OUTLINE = 0;
    protected static final int ID_OVERVIEW = 1;
    protected PreferenceStore workspaceViewerPreferenceStore = null;
    private IEditingDomainProvider domainProvider = new IEditingDomainProvider(){

        public EditingDomain getEditingDomain() {
            return DiagramEditor.this.getEditingDomain();
        }
    };
    private KeyHandler keyHandler;
    private IWorkbenchPartSite partSite;
    private RulerComposite rulerComposite;
    private IUndoContext undoContext;
    private IOperationHistoryListener historyListener;
    private IOperationHistoryListener disableUpdateHistoryListener;

    protected int getDefaultOutlineViewMode() {
        return 1;
    }

    protected MenuManager getOutlineContextMenuProvider(EditPartViewer viewer) {
        return null;
    }

    protected RulerComposite getRulerComposite() {
        return this.rulerComposite;
    }

    protected void setRulerComposite(RulerComposite rulerComp) {
        this.rulerComposite = rulerComp;
    }

    public DiagramEditor() {
        this.createDiagramEditDomain();
        this.historyListener = this.createHistoryListener();
        this.disableUpdateHistoryListener = this.createDisableUpdateHistoryListener();
    }

    private IOperationHistoryListener createDisableUpdateHistoryListener() {
        return new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                DiagramGraphicalViewer viewer;
                if (event.getEventType() == 1 || event.getEventType() == 3 || event.getEventType() == 2) {
                    DiagramGraphicalViewer viewer2 = (DiagramGraphicalViewer)DiagramEditor.this.getDiagramGraphicalViewer();
                    if (viewer2 != null && Display.getCurrent() == null) {
                        viewer2.enableUpdates(false);
                    }
                } else if ((event.getEventType() == 7 || event.getEventType() == 4 || event.getEventType() == 10 || event.getEventType() == 9) && (viewer = (DiagramGraphicalViewer)DiagramEditor.this.getDiagramGraphicalViewer()) != null) {
                    viewer.enableUpdates(true);
                }
            }
        };
    }

    protected IOperationHistoryListener createHistoryListener() {
        return new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                IUndoableOperation operation;
                if (event.getEventType() == 4 && DiagramEditor.this.shouldAddUndoContext(operation = event.getOperation())) {
                    operation.addContext(DiagramEditor.this.getUndoContext());
                }
            }
        };
    }

    protected boolean shouldAddUndoContext(IUndoableOperation operation) {
        TransactionalEditingDomain domain = this.getEditingDomain();
        if (domain != null) {
            Set affectedResources = ResourceUndoContext.getAffectedResources((IUndoableOperation)operation);
            for (Resource nextResource : affectedResources) {
                TransactionalEditingDomain resourceSetEditingDomain;
                ResourceSet resourceSet = nextResource.getResourceSet();
                if (resourceSet == null || !domain.equals(resourceSetEditingDomain = TransactionalEditingDomain.Factory.INSTANCE.getEditingDomain(resourceSet))) continue;
                return true;
            }
        }
        return false;
    }

    public IDiagramEditDomain getDiagramEditDomain() {
        return (IDiagramEditDomain)this.getEditDomain();
    }

    public IDiagramGraphicalViewer getDiagramGraphicalViewer() {
        return (IDiagramGraphicalViewer)this.getGraphicalViewer();
    }

    public Diagram getDiagram() {
        if (this.getEditorInput() != null) {
            return ((IDiagramEditorInput)this.getEditorInput()).getDiagram();
        }
        return null;
    }

    public DiagramEditPart getDiagramEditPart() {
        return (DiagramEditPart)this.getDiagramGraphicalViewer().getContents();
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            TreeViewer viewer = new TreeViewer();
            viewer.setRootEditPart((RootEditPart)new DiagramRootTreeEditPart());
            return new DiagramOutlinePage((EditPartViewer)viewer);
        }
        if (ActionManager.class == type) {
            return this.getActionManager();
        }
        if (IDiagramEditDomain.class == type) {
            return this.getDiagramEditDomain();
        }
        if (type == ZoomManager.class) {
            return this.getZoomManager();
        }
        if (type == IUndoContext.class) {
            return this.getUndoContext();
        }
        if (type == IOperationHistory.class) {
            return this.getOperationHistory();
        }
        if (type == IEditingDomainProvider.class) {
            return this.domainProvider;
        }
        return super.getAdapter(type);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        try {
            EditorService.getInstance().registerEditor((IEditorPart)this);
        }
        catch (Exception e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"init", (Throwable)e);
            if (e.getMessage() != null) {
                throw new PartInitException(e.getMessage(), (Throwable)e);
            }
            throw new PartInitException("DiagramEditor failed to initialize", (Throwable)e);
        }
    }

    public void dispose() {
        DiagramRulerProvider horzProvider;
        this.persistViewerSettings();
        EditorService.getInstance().unregisterEditor((IEditorPart)this);
        this.stopListening();
        DiagramRulerProvider vertProvider = (DiagramRulerProvider)((Object)this.getDiagramGraphicalViewer().getProperty("vertical ruler"));
        if (vertProvider != null) {
            vertProvider.uninit();
        }
        if ((horzProvider = (DiagramRulerProvider)((Object)this.getDiagramGraphicalViewer().getProperty("horizontal ruler"))) != null) {
            horzProvider.uninit();
        }
        this.getEditDomain().getCommandStack().dispose();
        if (this.historyListener != null) {
            this.getOperationHistory().removeOperationHistoryListener(this.historyListener);
            this.getOperationHistory().dispose(this.getUndoContext(), true, true, true);
        }
        if (this.disableUpdateHistoryListener != null) {
            this.getOperationHistory().removeOperationHistoryListener(this.disableUpdateHistoryListener);
        }
        super.dispose();
    }

    protected KeyHandler getKeyHandler() {
        if (this.keyHandler == null) {
            this.keyHandler = new KeyHandler();
            ActionRegistry registry = this.getActionRegistry();
            Object action = new PromptingDeleteAction(this);
            action.setText(DiagramUIMessages.DiagramEditor_Delete_from_Diagram);
            registry.registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            action = new InsertAction(this);
            action.setText("");
            registry.registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            PromptingDeleteFromModelAction deleteModelAction = new PromptingDeleteFromModelAction(this);
            deleteModelAction.init();
            registry.registerAction((IAction)deleteModelAction);
            action = new DirectEditAction((IWorkbenchPart)this);
            registry.registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            action = new ZoomInAction(this.getZoomManager());
            action.setText("");
            registry.registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            action = new ZoomOutAction(this.getZoomManager());
            action.setText("");
            registry.registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            action = new ToggleRouterAction(this.getSite().getPage());
            ((ToggleRouterAction)((Object)action)).setPartSelector(new IPartSelector(){

                public boolean selects(IWorkbenchPart part) {
                    return part == DiagramEditor.this;
                }
            });
            action.setText("");
            registry.registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            this.keyHandler.put(KeyStroke.getPressed((int)0x1000009, (int)0), this.getActionRegistry().getAction((Object)"insertSemantic"));
            this.keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.keyHandler.put(KeyStroke.getPressed((char)'\b', (int)8, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.keyHandler.put(KeyStroke.getPressed((char)'\u0004', (int)100, (int)262144), this.getActionRegistry().getAction((Object)"deleteFromModelAction"));
            this.keyHandler.put(KeyStroke.getPressed((char)'=', (int)61, (int)262144), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
            this.keyHandler.put(KeyStroke.getPressed((char)'-', (int)45, (int)262144), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_out"));
            this.keyHandler.put(KeyStroke.getPressed((char)'\f', (int)108, (int)262144), this.getActionRegistry().getAction((Object)"toggleRouter"));
            this.keyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.keyHandler;
    }

    protected void createGraphicalViewer(Composite parent) {
        this.setRulerComposite(new RulerComposite(parent, 0));
        ScrollingGraphicalViewer sGViewer = this.createScrollingGraphicalViewer();
        sGViewer.createControl((Composite)this.getRulerComposite());
        this.setGraphicalViewer((GraphicalViewer)sGViewer);
        this.hookGraphicalViewer();
        this.configureGraphicalViewer();
        this.initializeGraphicalViewer();
        this.getRulerComposite().setGraphicalViewer((ScrollingGraphicalViewer)this.getGraphicalViewer());
    }

    protected ScrollingGraphicalViewer createScrollingGraphicalViewer() {
        return new DiagramGraphicalViewer();
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        IDiagramGraphicalViewer viewer = this.getDiagramGraphicalViewer();
        RootEditPart rootEP = EditPartService.getInstance().createRootEditPart(this.getDiagram());
        if (rootEP instanceof IDiagramPreferenceSupport) {
            ((IDiagramPreferenceSupport)rootEP).setPreferencesHint(this.getPreferencesHint());
        }
        if (this.getDiagramGraphicalViewer() instanceof DiagramGraphicalViewer) {
            ((DiagramGraphicalViewer)this.getDiagramGraphicalViewer()).hookWorkspacePreferenceStore((IPreferenceStore)this.getWorkspaceViewerPreferenceStore());
        }
        viewer.setRootEditPart(rootEP);
        viewer.setEditPartFactory(EditPartService.getInstance());
        DiagramContextMenuProvider provider = new DiagramContextMenuProvider(this, (EditPartViewer)viewer);
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("org.eclipse.gmf.runtime.diagram.ui.DiagramEditorContextMenu", (MenuManager)provider, (ISelectionProvider)viewer);
        KeyHandler viewerKeyHandler = new DiagramGraphicalViewerKeyHandler(viewer).setParent(this.getKeyHandler());
        viewer.setKeyHandler(new DirectEditKeyHandler(viewer).setParent(viewerKeyHandler));
        ((FigureCanvas)viewer.getControl()).setScrollBarVisibility(FigureCanvas.ALWAYS);
    }

    protected void initializeGraphicalViewer() {
        this.initializeGraphicalViewerContents();
    }

    protected void initializeGraphicalViewerContents() {
        this.getDiagramGraphicalViewer().setContents(this.getDiagram());
        this.initializeContents((EditPart)this.getDiagramEditPart());
    }

    protected void createDiagramEditDomain() {
        DiagramEditDomain editDomain = new DiagramEditDomain((IEditorPart)this);
        editDomain.setActionManager(this.createActionManager());
        this.setEditDomain(editDomain);
    }

    protected void configureDiagramEditDomain() {
        DefaultEditDomain editDomain = this.getEditDomain();
        if (editDomain != null) {
            CommandStack stack = editDomain.getCommandStack();
            if (stack != null) {
                stack.dispose();
            }
            DiagramCommandStack diagramStack = new DiagramCommandStack(this.getDiagramEditDomain());
            diagramStack.setOperationHistory(this.getOperationHistory());
            diagramStack.setUndoContext(this.getUndoContext());
            editDomain.setCommandStack((CommandStack)diagramStack);
        }
    }

    protected ActionManager createActionManager() {
        return new ActionManager(this.createOperationHistory());
    }

    protected IOperationHistory createOperationHistory() {
        return OperationHistoryFactory.getOperationHistory();
    }

    protected void setInput(IEditorInput input) {
        this.stopListening();
        super.setInput(input);
        if (input != null) {
            Assert.isNotNull((Object)this.getDiagram(), (String)"Couldn't load/create diagram view");
        }
        this.configureDiagramEditDomain();
        this.startListening();
    }

    protected void createActions() {
    }

    protected void closeEditor(boolean save) {
        try {
            this.getSite().getPage().closeEditor((IEditorPart)this, save);
        }
        catch (SWTException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"closeEditor", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)4, (String)e.getMessage(), (Throwable)e);
        }
    }

    protected void startListening() {
        TransactionalEditingDomain domain = this.getEditingDomain();
        if (domain != null) {
            DiagramEventBroker eventBroker;
            if (this.historyListener != null) {
                this.getOperationHistory().addOperationHistoryListener(this.historyListener);
            }
            if (this.disableUpdateHistoryListener != null) {
                this.getOperationHistory().addOperationHistoryListener(this.disableUpdateHistoryListener);
            }
            if ((eventBroker = DiagramEventBroker.getInstance((TransactionalEditingDomain)domain)) == null) {
                DiagramEventBroker.startListening((TransactionalEditingDomain)domain);
            }
        }
    }

    protected void stopListening() {
        if (this.historyListener != null) {
            if (this.undoContext != null) {
                this.getOperationHistory().dispose(this.getUndoContext(), true, true, true);
            }
            this.getOperationHistory().removeOperationHistoryListener(this.historyListener);
        }
        if (this.disableUpdateHistoryListener != null) {
            this.getOperationHistory().removeOperationHistoryListener(this.disableUpdateHistoryListener);
        }
    }

    protected void clearGraphicalViewerContents() {
        DiagramRulerProvider horzProvider;
        DiagramRulerProvider vertProvider;
        if (this.getDiagramGraphicalViewer().getContents() != null) {
            this.getDiagramGraphicalViewer().getContents().deactivate();
            this.getDiagramGraphicalViewer().getContents().removeNotify();
        }
        if ((vertProvider = (DiagramRulerProvider)((Object)this.getDiagramGraphicalViewer().getProperty("vertical ruler"))) != null) {
            vertProvider.uninit();
        }
        if ((horzProvider = (DiagramRulerProvider)((Object)this.getDiagramGraphicalViewer().getProperty("horizontal ruler"))) != null) {
            horzProvider.uninit();
        }
        this.getDiagramGraphicalViewer().setContents(null);
    }

    protected ActionManager getActionManager() {
        return this.getDiagramEditDomain().getActionManager();
    }

    protected ZoomManager getZoomManager() {
        return ((DiagramRootEditPart)this.getRootEditPart()).getZoomManager();
    }

    private RootEditPart getRootEditPart() {
        return this.getGraphicalViewer().getRootEditPart();
    }

    protected IOperationHistory getOperationHistory() {
        return this.getActionManager().getOperationHistory();
    }

    public TransactionalEditingDomain getEditingDomain() {
        if (this.getDiagram() != null) {
            return TransactionUtil.getEditingDomain((EObject)this.getDiagram());
        }
        return null;
    }

    protected IUndoContext getUndoContext() {
        if (this.undoContext == null) {
            TransactionalEditingDomain domain = this.getEditingDomain();
            this.undoContext = domain != null ? new EditingDomainUndoContext((EditingDomain)domain) : new ObjectUndoContext((Object)this);
        }
        return this.undoContext;
    }

    protected void setUndoContext(IUndoContext context) {
        this.undoContext = context;
    }

    protected Control getGraphicalControl() {
        return this.getRulerComposite();
    }

    public IWorkbenchPartSite getSite() {
        return this.partSite;
    }

    protected void setSite(IWorkbenchPartSite site) {
        this.partSite = site;
    }

    public String getContributorId() {
        return "org.eclipse.gmf.runtime.diagram.ui.properties";
    }

    public static void addDefaultPreferences(PreferenceStore store, PreferencesHint preferencesHint) {
        store.setValue("zoom", 1.0);
        store.setValue("viewpagebreaks", false);
        IPreferenceStore globalPreferenceStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        boolean viewGrid = globalPreferenceStore.getBoolean("GridRuler.showGrid");
        boolean snapToGrid = globalPreferenceStore.getBoolean("GridRuler.snapToGrid");
        boolean snapToGeometry = globalPreferenceStore.getBoolean("GridRuler.snapToGeometry");
        boolean viewRulers = globalPreferenceStore.getBoolean("GridRuler.showRulers");
        store.setValue("rulergrid.viewgrid", viewGrid);
        store.setValue("rulergrid.snaptogrid", snapToGrid);
        store.setValue("rulergrid.snaptogeometry", snapToGeometry);
        store.setValue("rulergrid.viewrulers", viewRulers);
        IPreferenceStore workspacePreferences = (IPreferenceStore)preferencesHint.getPreferenceStore();
        store.setValue("print.useWorkspaceSettings", workspacePreferences.getBoolean("print.useWorkspaceSettings"));
        store.setValue("print.useDiagramSettings", workspacePreferences.getBoolean("print.useWorkspaceSettings"));
        store.setValue("print.useInches", workspacePreferences.getBoolean("print.useInches"));
        store.setValue("print.useMillim", workspacePreferences.getBoolean("print.useMillim"));
        store.setValue("print.usePortrait", workspacePreferences.getBoolean("print.usePortrait"));
        store.setValue("print.useLandscape", workspacePreferences.getBoolean("print.useLandscape"));
        store.setValue("print.page.size", workspacePreferences.getString("print.page.size"));
        store.setValue("print.page.width", workspacePreferences.getDouble("print.page.width"));
        store.setValue("print.page.height", workspacePreferences.getDouble("print.page.height"));
        store.setValue("print.margin.top", workspacePreferences.getDouble("print.margin.top"));
        store.setValue("print.margin.bottom", workspacePreferences.getDouble("print.margin.bottom"));
        store.setValue("print.margin.left", workspacePreferences.getDouble("print.margin.left"));
        store.setValue("print.margin.right", workspacePreferences.getDouble("print.margin.right"));
    }

    public PreferenceStore getWorkspaceViewerPreferenceStore() {
        if (this.workspaceViewerPreferenceStore != null) {
            return this.workspaceViewerPreferenceStore;
        }
        IPath path = DiagramUIPlugin.getInstance().getStateLocation();
        String id = ViewUtil.getIdStr((View)this.getDiagram());
        String fileName = String.valueOf(path.toString()) + "/" + id;
        File file = new File(fileName);
        this.workspaceViewerPreferenceStore = new PreferenceStore(fileName);
        if (file.exists()) {
            try {
                this.workspaceViewerPreferenceStore.load();
            }
            catch (Exception exception) {
                this.addDefaultPreferences();
            }
        } else {
            this.addDefaultPreferences();
        }
        return this.workspaceViewerPreferenceStore;
    }

    protected void addDefaultPreferences() {
        DiagramEditor.addDefaultPreferences(this.workspaceViewerPreferenceStore, this.getPreferencesHint());
    }

    public void persistViewerSettings() {
        Viewport viewport = this.getDiagramEditPart().getViewport();
        if (viewport != null) {
            int x = viewport.getHorizontalRangeModel().getValue();
            int y = viewport.getVerticalRangeModel().getValue();
            this.getWorkspaceViewerPreferenceStore().setValue("viewport.x", x);
            this.getWorkspaceViewerPreferenceStore().setValue("viewport.y", y);
        }
        this.getWorkspaceViewerPreferenceStore().setValue("zoom", this.getZoomManager().getZoom());
        try {
            if (this.getWorkspaceViewerPreferenceStore().needsSaving()) {
                this.getWorkspaceViewerPreferenceStore().save();
            }
        }
        catch (IOException ioe) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, PageInfoHelper.class, (String)"persistViewerSettings", (Throwable)ioe);
        }
    }

    private void initializeContents(EditPart editpart) {
        this.getZoomManager().setZoom(this.getWorkspaceViewerPreferenceStore().getDouble("zoom"));
        if (this.getWorkspaceViewerPreferenceStore().getBoolean("viewpagebreaks")) {
            this.getDiagramEditPart().getFigure().invalidate();
            this.getDiagramEditPart().getFigure().validate();
        }
        this.getDiagramEditPart().refreshPageBreaks();
        ((DiagramEditPart)editpart).getViewport().validate();
        if (editpart instanceof DiagramEditPart) {
            int x = this.getWorkspaceViewerPreferenceStore().getInt("viewport.x");
            int y = this.getWorkspaceViewerPreferenceStore().getInt("viewport.y");
            ((DiagramEditPart)editpart).getViewport().getHorizontalRangeModel().setValue(x);
            ((DiagramEditPart)editpart).getViewport().getVerticalRangeModel().setValue(y);
        }
        int rulerUnits = this.getWorkspaceViewerPreferenceStore().getInt("rulergrid.rulerunit");
        GuideStyle guideStyle = (GuideStyle)this.getDiagram().getStyle(NotationPackage.eINSTANCE.getGuideStyle());
        if (guideStyle != null) {
            RootEditPart rep = this.getGraphicalViewer().getRootEditPart();
            DiagramRootEditPart root = (DiagramRootEditPart)rep;
            DiagramRuler verticalRuler = ((DiagramRootEditPart)this.getRootEditPart()).getVerticalRuler();
            verticalRuler.setGuideStyle(guideStyle);
            verticalRuler.setUnit(rulerUnits);
            DiagramRulerProvider vertProvider = new DiagramRulerProvider(this.getEditingDomain(), verticalRuler, root.getMapMode());
            vertProvider.init();
            this.getDiagramGraphicalViewer().setProperty("vertical ruler", (Object)vertProvider);
            DiagramRuler horizontalRuler = ((DiagramRootEditPart)this.getRootEditPart()).getHorizontalRuler();
            horizontalRuler.setGuideStyle(guideStyle);
            horizontalRuler.setUnit(rulerUnits);
            DiagramRulerProvider horzProvider = new DiagramRulerProvider(this.getEditingDomain(), horizontalRuler, root.getMapMode());
            horzProvider.init();
            this.getDiagramGraphicalViewer().setProperty("horizontal ruler", (Object)horzProvider);
            this.getDiagramGraphicalViewer().setProperty("ruler$visibility", this.getWorkspaceViewerPreferenceStore().getBoolean("rulergrid.viewrulers"));
        }
        this.getDiagramGraphicalViewer().setProperty("SnapToGeometry.isEnabled", this.getWorkspaceViewerPreferenceStore().getBoolean("rulergrid.snaptogeometry"));
        this.getDiagramGraphicalViewer().setProperty("SnapToGrid.isEnabled", this.getWorkspaceViewerPreferenceStore().getBoolean("rulergrid.snaptogrid"));
        this.getDiagramGraphicalViewer().setProperty("SnapToGrid.isVisible", this.getWorkspaceViewerPreferenceStore().getBoolean("rulergrid.viewgrid"));
        Point origin = new Point();
        this.getDiagramGraphicalViewer().setProperty("SnapToGrid.GridOrigin", origin);
        double dSpacing = ((DiagramRootEditPart)this.getDiagramEditPart().getRoot()).getGridSpacing();
        ((DiagramRootEditPart)this.getDiagramEditPart().getRoot()).setGridSpacing(dSpacing);
        this.getGraphicalViewer().setProperty(MouseWheelHandler.KeyGenerator.getKey((int)262144), (Object)MouseWheelZoomHandler.SINGLETON);
    }

    protected List getElements(final ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            try {
                return (List)TransactionUtil.getEditingDomain((Object)((IAdaptable)((IStructuredSelection)selection).toList().get(0)).getAdapter(View.class)).runExclusive((Runnable)new RunnableWithResult.Impl(){

                    public void run() {
                        ArrayList<Object> retval = new ArrayList<Object>();
                        if (selection instanceof IStructuredSelection) {
                            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                            for (Object next : structuredSelection) {
                                View view = (View)((IAdaptable)next).getAdapter(View.class);
                                if (view == null) continue;
                                EObject eObject = ViewUtil.resolveSemanticElement((View)view);
                                if (eObject != null) {
                                    retval.add(eObject);
                                    continue;
                                }
                                retval.add(view);
                            }
                        }
                        this.setResult(retval);
                    }
                });
            }
            catch (InterruptedException e) {
                Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"createEditPart", (Throwable)e);
                return Collections.EMPTY_LIST;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public ShowInContext getShowInContext() {
        ISelection selection = this.getGraphicalViewer().getSelection();
        return new ShowInContext(null, selection);
    }

    protected PreferencesHint getPreferencesHint() {
        return new PreferencesHint(this.getEditorSite().getId());
    }

    public boolean isWritable() {
        return this.getDiagramEditPart() != null && this.getDiagramEditPart().isEditModeEnabled();
    }

    protected EditPartFactory getOutlineViewEditPartFactory() {
        return new EditPartFactory(){

            public EditPart createEditPart(EditPart context, Object model) {
                if (model instanceof Diagram) {
                    return new TreeDiagramEditPart(model);
                }
                if (model instanceof View && ViewType.GROUP.equals(((View)model).getType())) {
                    return new TreeContainerEditPart(model);
                }
                return new TreeEditPart(model);
            }
        };
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext(this.getContextID());
        }
    }

    protected String getContextID() {
        return DIAGRAM_CONTEXT_ID;
    }

    class DiagramOutlinePage
    extends ContentOutlinePage
    implements IAdaptable {
        private PageBook pageBook;
        private Control outline;
        private Canvas overview;
        private IAction showOutlineAction;
        private IAction showOverviewAction;
        private boolean overviewInitialized;
        private ThumbnailEx thumbnail;
        private DisposeListener disposeListener;

        public DiagramOutlinePage(EditPartViewer viewer) {
            super(viewer);
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            ActionRegistry registry = DiagramEditor.this.getActionRegistry();
            IActionBars bars = pageSite.getActionBars();
            String id = ActionFactory.UNDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.REDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.DELETE.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            bars.updateActionBars();
            bars.getToolBarManager().markDirty();
        }

        protected void configureOutlineViewer() {
            this.getViewer().setEditDomain((EditDomain)DiagramEditor.this.getEditDomain());
            this.getViewer().setEditPartFactory(DiagramEditor.this.getOutlineViewEditPartFactory());
            MenuManager outlineContextMenuProvider = DiagramEditor.this.getOutlineContextMenuProvider(this.getViewer());
            if (outlineContextMenuProvider != null) {
                this.getViewer().setContextMenu(outlineContextMenuProvider);
            }
            this.getViewer().setKeyHandler(DiagramEditor.this.getKeyHandler());
            IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
            this.showOutlineAction = new Action(){

                public void run() {
                    DiagramOutlinePage.this.showPage(0);
                }
            };
            this.showOutlineAction.setImageDescriptor(DiagramUIPluginImages.DESC_OUTLINE);
            this.showOutlineAction.setToolTipText(DiagramUIMessages.OutlineView_OutlineTipText);
            tbm.add(this.showOutlineAction);
            this.showOverviewAction = new Action(){

                public void run() {
                    DiagramOutlinePage.this.showPage(1);
                }
            };
            this.showOverviewAction.setImageDescriptor(DiagramUIPluginImages.DESC_OVERVIEW);
            this.showOverviewAction.setToolTipText(DiagramUIMessages.OutlineView_OverviewTipText);
            tbm.add(this.showOverviewAction);
            this.showPage(DiagramEditor.this.getDefaultOutlineViewMode());
        }

        public void createControl(Composite parent) {
            this.pageBook = new PageBook(parent, 0);
            this.outline = this.getViewer().createControl((Composite)this.pageBook);
            this.overview = new Canvas((Composite)this.pageBook, 0);
            this.pageBook.showPage(this.outline);
            this.configureOutlineViewer();
            this.hookOutlineViewer();
            this.initializeOutlineViewer();
        }

        public void dispose() {
            this.unhookOutlineViewer();
            if (this.thumbnail != null) {
                this.thumbnail.deactivate();
            }
            this.overviewInitialized = false;
            super.dispose();
        }

        public Object getAdapter(Class type) {
            return null;
        }

        public Control getControl() {
            return this.pageBook;
        }

        protected void hookOutlineViewer() {
            DiagramEditor.this.getSelectionSynchronizer().addViewer(this.getViewer());
        }

        protected void initializeOutlineViewer() {
            try {
                TransactionUtil.getEditingDomain((EObject)DiagramEditor.this.getDiagram()).runExclusive(new Runnable(){

                    public void run() {
                        DiagramOutlinePage.this.getViewer().setContents((Object)DiagramEditor.this.getDiagram());
                    }
                });
            }
            catch (InterruptedException e) {
                Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"initializeOutlineViewer", (Throwable)e);
                Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"initializeOutlineViewer", (Throwable)e);
            }
        }

        protected void initializeOverview() {
            LightweightSystem lws = new LightweightSystem(this.overview);
            RootEditPart rep = DiagramEditor.this.getGraphicalViewer().getRootEditPart();
            DiagramRootEditPart root = (DiagramRootEditPart)rep;
            this.thumbnail = new ScrollableThumbnailEx((Viewport)root.getFigure());
            this.thumbnail.setSource(root.getLayer("Scalable Layers"));
            lws.setContents((IFigure)this.thumbnail);
            this.disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (DiagramOutlinePage.this.thumbnail != null) {
                        DiagramOutlinePage.this.thumbnail.deactivate();
                        DiagramOutlinePage.this.thumbnail = null;
                    }
                }
            };
            this.getEditor().addDisposeListener(this.disposeListener);
            this.overviewInitialized = true;
        }

        protected void showPage(int id) {
            if (id == 0) {
                this.showOutlineAction.setChecked(true);
                this.showOverviewAction.setChecked(false);
                this.pageBook.showPage(this.outline);
                if (this.thumbnail != null) {
                    this.thumbnail.setVisible(false);
                }
            } else if (id == 1) {
                if (!this.overviewInitialized) {
                    this.initializeOverview();
                }
                this.showOutlineAction.setChecked(false);
                this.showOverviewAction.setChecked(true);
                this.pageBook.showPage((Control)this.overview);
                this.thumbnail.setVisible(true);
            }
        }

        protected void unhookOutlineViewer() {
            DiagramEditor.this.getSelectionSynchronizer().removeViewer(this.getViewer());
            if (this.disposeListener != null && this.getEditor() != null && !this.getEditor().isDisposed()) {
                this.getEditor().removeDisposeListener(this.disposeListener);
            }
        }

        protected Control getEditor() {
            return DiagramEditor.this.getGraphicalViewer().getControl();
        }
    }
}

