/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.genmodel;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.core.JavaConventions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DummyGenModel {
    protected final EPackage myModel;
    protected final Collection<EPackage> myAdditionalPackages;
    private String myPluginID;

    public DummyGenModel(EPackage primaryPackage, Collection<EPackage> additionalPackages) {
        assert (primaryPackage != null);
        this.myModel = primaryPackage;
        this.myAdditionalPackages = additionalPackages;
    }

    public GenModel create() {
        GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
        if (this.myAdditionalPackages == null) {
            genModel.initialize((Collection)Collections.singleton(this.myModel));
        } else {
            LinkedHashSet<EPackage> allPacks = new LinkedHashSet<EPackage>();
            allPacks.add(this.myModel);
            allPacks.addAll(this.myAdditionalPackages);
            genModel.initialize(allPacks);
        }
        String pluginID = this.getPluginID();
        genModel.setModelName(this.getModelName());
        genModel.setModelPluginID(pluginID);
        genModel.setModelDirectory("/" + pluginID + "/src/");
        String basePackage = this.asValidPackageName(pluginID);
        for (GenPackage genPackage : genModel.getGenPackages()) {
            if (basePackage != null) {
                if (basePackage.endsWith(String.valueOf('.') + genPackage.getEcorePackage().getName())) {
                    genPackage.setBasePackage(basePackage.substring(0, basePackage.lastIndexOf(46)));
                } else {
                    genPackage.setBasePackage(basePackage);
                }
            }
            genPackage.setPrefix(this.constructGenPackagePrefix(genPackage));
        }
        return genModel;
    }

    protected String constructGenPackagePrefix(GenPackage genPackage) {
        return CodeGenUtil.capName((String)genPackage.getEcorePackage().getName());
    }

    protected String getModelName() {
        return CodeGenUtil.capName((String)this.myModel.getName());
    }

    public void setPluginID(String pluginID) {
        this.myPluginID = pluginID;
    }

    private String getPluginID() {
        if (this.myPluginID == null) {
            return "org.sample." + this.getModelName().toLowerCase();
        }
        return this.myPluginID;
    }

    private String asValidPackageName(String pluginID) {
        String rv = pluginID.toLowerCase();
        if (JavaConventions.validatePackageName((String)rv, (String)"1.4", (String)"1.4").getSeverity() != 4) {
            return rv;
        }
        StringBuilder sb = new StringBuilder(rv.length());
        StringTokenizer st = new StringTokenizer(rv, ".");
        while (st.hasMoreTokens()) {
            if (!DummyGenModel.appendOnlyJavaChars(sb, st.nextToken())) continue;
            sb.append('.');
        }
        if (sb.length() == 0) {
            return null;
        }
        sb.setLength(sb.length() - 1);
        if (!Character.isJavaIdentifierStart(sb.charAt(0))) {
            sb.insert(0, 'a');
        }
        assert (JavaConventions.validatePackageName((String)sb.toString(), (String)"1.4", (String)"1.4").isOK());
        return sb.toString();
    }

    private static boolean appendOnlyJavaChars(StringBuilder sb, String rv) {
        boolean added = false;
        int i = 0;
        while (i < rv.length()) {
            if (Character.isJavaIdentifierPart(rv.charAt(i))) {
                sb.append(rv.charAt(i));
                added = true;
            }
            ++i;
        }
        return added;
    }
}

