/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.ModelElement;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;

public class ConditionElemMapEditor {
    private final NestedCondition source;
    private final NestedCondition target;
    private final boolean sameRule;

    public ConditionElemMapEditor(NestedCondition source, NestedCondition target) {
        this.source = source;
        this.target = target;
        this.sameRule = source.getHost().getRule() == target.getHost().getRule();
    }

    private static void ensureCompleteness(NestedCondition cond) {
        ModelElement image;
        Graph graph = cond.getConclusion();
        if (graph == null) {
            return;
        }
        for (Node node : cond.getHost().getRule().getLhs().getNodes()) {
            if (cond.getMappings().getImage(node, graph) != null) continue;
            image = (Node)EcoreUtil.copy((EObject)node);
            image.getAttributes().clear();
            graph.getNodes().add((Object)image);
            cond.getMappings().add(node, (Node)image);
        }
        for (Edge edge : cond.getHost().getRule().getLhs().getEdges()) {
            if (cond.getMappings().getImage(edge, graph) != null) continue;
            image = (Edge)EcoreUtil.copy((EObject)edge);
            image.setSource(cond.getMappings().getImage(edge.getSource(), graph));
            image.setTarget(cond.getMappings().getImage(edge.getTarget(), graph));
            graph.getEdges().add((Object)image);
        }
    }

    private Node getOppositeCondNode(Node node) {
        if (node.getGraph().eContainer() == this.source) {
            return this.target.getMappings().getImage(this.getOppositeLhsNode(this.source.getMappings().getOrigin(node)), this.target.getConclusion());
        }
        return this.source.getMappings().getImage(this.getOppositeLhsNode(this.target.getMappings().getOrigin(node)), this.source.getConclusion());
    }

    private Node getOppositeLhsNode(Node lhsNode) {
        if (this.sameRule) {
            return lhsNode;
        }
        if (lhsNode.getGraph() == this.source.getHost().getRule().getLhs()) {
            return this.target.getHost().getRule().getMultiMappings().getImage(lhsNode, this.target.getHost().getRule().getLhs());
        }
        return this.target.getHost().getRule().getMultiMappings().getOrigin(lhsNode);
    }

    public void moveConditionNode(Node node) {
        if (((NestedCondition)node.getGraph().eContainer()).getMappings().getOrigin(node) != null) {
            return;
        }
        ConditionElemMapEditor.ensureCompleteness(this.source);
        ConditionElemMapEditor.ensureCompleteness(this.target);
        Graph oppGraph = node.getGraph() == this.source.getConclusion() ? this.target.getConclusion() : this.source.getConclusion();
        for (Edge incoming : node.getIncoming()) {
            incoming.setSource(this.getOppositeCondNode(incoming.getSource()));
            incoming.setGraph(oppGraph);
        }
        for (Edge outgoing : node.getOutgoing()) {
            outgoing.setTarget(this.getOppositeCondNode(outgoing.getTarget()));
            outgoing.setGraph(oppGraph);
        }
        node.setGraph(oppGraph);
    }

    public void moveConditionEdge(Edge edge) {
        if (((NestedCondition)edge.getGraph().eContainer()).getMappings().getOrigin(edge) != null) {
            return;
        }
        ConditionElemMapEditor.ensureCompleteness(this.source);
        ConditionElemMapEditor.ensureCompleteness(this.target);
        Graph oppGraph = edge.getGraph() == this.source.getConclusion() ? this.target.getConclusion() : this.source.getConclusion();
        edge.setSource(this.getOppositeCondNode(edge.getSource()));
        edge.setTarget(this.getOppositeCondNode(edge.getTarget()));
        edge.setGraph(oppGraph);
    }

    public void moveConditionAttribute(Attribute attribute) {
        if (((NestedCondition)attribute.getGraph().eContainer()).getMappings().getOrigin(attribute) != null) {
            return;
        }
        ConditionElemMapEditor.ensureCompleteness(this.source);
        ConditionElemMapEditor.ensureCompleteness(this.target);
        attribute.setNode(this.getOppositeCondNode(attribute.getNode()));
    }

    public void moveConditionElement(Object element) {
        if (element instanceof Node) {
            this.moveConditionNode((Node)element);
        } else if (element instanceof Edge) {
            this.moveConditionEdge((Edge)element);
        } else if (element instanceof Attribute) {
            this.moveConditionAttribute((Attribute)element);
        }
    }
}

