/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.bankmap;

import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class BankMapExample {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/bankmap";

    public static void run(String path) {
        HenshinResourceSet resourceSet = new HenshinResourceSet(path);
        Resource resource = resourceSet.getResource("mapping_bank.xmi");
        EObject bank = (EObject)resource.getContents().get(0);
        assert (bank.eClass().getName().equals("Bank"));
        EReference accounts = (EReference)bank.eClass().getEStructuralFeature("accounts");
        EMap map = (EMap)bank.eGet((EStructuralFeature)accounts);
        EObject account = (EObject)map.get((Object)new Integer(10));
        EClass accountClass = account.eClass();
        EAttribute credits = (EAttribute)accountClass.getEStructuralFeature("credit");
        EGraphImpl graph = new EGraphImpl(resource);
        Module module = resourceSet.getModule("bankmap.henshin", false);
        EngineImpl engine = new EngineImpl(new String[0]);
        engine.getOptions().put("SORT_VARIABLES", false);
        UnitApplicationImpl app = new UnitApplicationImpl((Engine)engine);
        app.setEGraph((EGraph)graph);
        System.out.println("Starting Banking Example with Map Support");
        System.out.println("Single transfer on small model");
        app.setUnit(module.getUnit("transferMoney"));
        app.setParameterValue("fromID", (Object)10);
        app.setParameterValue("toID", (Object)50);
        app.setParameterValue("money", (Object)20.0);
        if (!app.execute(null)) {
            throw new RuntimeException("Error transferring money");
        }
        int i = 100;
        while (i < 1100) {
            EObject newAccount = accountClass.getEPackage().getEFactoryInstance().create(accountClass);
            newAccount.eSet((EStructuralFeature)credits, (Object)42.0);
            map.put((Object)new Integer(i), (Object)newAccount);
            ++i;
        }
        graph = new EGraphImpl(resource);
        System.out.println("100 money transfers on model with 1000 accounts");
        long start = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 100) {
            app = new UnitApplicationImpl((Engine)engine);
            app.setEGraph((EGraph)graph);
            app.setUnit(module.getUnit("transferMoney"));
            int from = (int)(1000.0 * Math.random() + 100.0);
            int to = (int)(1000.0 * Math.random() + 100.0);
            app.setParameterValue("fromID", (Object)from);
            app.setParameterValue("toID", (Object)to);
            app.setParameterValue("money", (Object)20.0);
            if (app.execute(null) == (from == to)) {
                throw new RuntimeException("Error transferring money from " + from + " to " + to);
            }
            ++i2;
        }
        long end = System.currentTimeMillis();
        System.out.println("run time with map support: " + (end - start) + "ms");
        map.clear();
        graph = new EGraphImpl(resource);
        app = new UnitApplicationImpl((Engine)engine);
        app.setUnit(module.getUnit("transferMoney"));
        app.setParameterValue("fromID", (Object)10);
        app.setParameterValue("toID", (Object)50);
        app.setParameterValue("money", (Object)20.0);
        app.setEGraph((EGraph)graph);
        if (app.execute(null)) {
            throw new RuntimeException("this should not apply as there are no bank2accountentries to match");
        }
    }

    public static void main(String[] args) {
        BankMapExample.run(PATH);
    }
}

