/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.properties.sections;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.api.adapters.SemanticAdapter;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionListener;
import org.eclipse.emf.eef.runtime.api.parts.IFormPropertiesEditionPart;
import org.eclipse.emf.eef.runtime.api.parts.IPropertiesEditionPart;
import org.eclipse.emf.eef.runtime.api.providers.IPropertiesEditionProvider;
import org.eclipse.emf.eef.runtime.impl.providers.RegistryPropertiesEditionProvider;
import org.eclipse.emf.eef.runtime.impl.services.PropertiesContextService;
import org.eclipse.emf.eef.runtime.ui.utils.EEFRuntimeUIMessages;
import org.eclipse.emf.eef.runtime.ui.utils.EditingUtils;
import org.eclipse.emf.eef.runtime.ui.viewers.PropertiesEditionContentProvider;
import org.eclipse.emf.eef.runtime.ui.viewers.PropertiesEditionMessageManager;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class PropertiesEditionSection
extends AbstractPropertySection
implements IFilter,
IPropertiesEditionListener {
    private TabbedPropertySheetPage propertySheetPage;
    protected Composite parent;
    private Composite container;
    private EditingDomain editingDomain;
    protected EObject eObject;
    protected List eObjectList;
    private Form scrolledForm;
    private PropertiesEditionMessageManager messageManager;
    private ViewerFilter[] filters = new ViewerFilter[1];
    private RegistryPropertiesEditionProvider provider;
    protected IPropertiesEditionComponent propertiesEditionComponent;
    private IPropertiesEditionProvider propertiesEditionProvider = new RegistryPropertiesEditionProvider();
    private PropertiesEditionContentProvider contentProvider;

    public RegistryPropertiesEditionProvider getProvider() {
        if (this.provider == null) {
            this.provider = new RegistryPropertiesEditionProvider();
        }
        return this.provider;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.propertySheetPage = aTabbedPropertySheetPage;
        this.parent = parent;
        this.scrolledForm = this.getWidgetFactory().createForm(parent);
        this.scrolledForm.getBody().setLayout((Layout)new GridLayout());
        this.scrolledForm.getBody().setLayoutData((Object)new GridData(1808));
        this.container = this.getWidgetFactory().createComposite(this.scrolledForm.getBody());
        GridLayout containerLayout = new GridLayout();
        this.container.setLayout((Layout)containerLayout);
        this.container.setLayoutData((Object)new GridData(1808));
        this.getWidgetFactory().decorateFormHeading(this.scrolledForm);
        this.messageManager = new PropertiesEditionMessageManager(){

            protected void updateStatus(String message) {
                if (message != null) {
                    PropertiesEditionSection.this.scrolledForm.setMessage(message, 3);
                } else {
                    PropertiesEditionSection.this.scrolledForm.setMessage("");
                }
            }
        };
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EObject newEObject;
        super.setInput(part, selection);
        this.initializeEditingDomain(part);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        if (this.resolveSemanticObject(((IStructuredSelection)selection).getFirstElement()) != null && (newEObject = this.resolveSemanticObject(((IStructuredSelection)selection).getFirstElement())) != this.eObject) {
            this.eObject = newEObject;
            if (this.eObject != null) {
                this.disposeComponent();
                String descriptor = this.getDescriptor();
                this.refreshComponent(descriptor);
            }
        }
        this.eObjectList = ((IStructuredSelection)selection).toList();
    }

    private void refreshComponent(String descriptor) {
        this.propertiesEditionComponent = this.getProvider().getPropertiesEditionComponent(this.eObject, "Live");
        if (this.propertiesEditionComponent != null) {
            PropertiesContextService.getInstance().push(this.eObject, this.propertiesEditionComponent);
            this.propertiesEditionComponent.setLiveEditingDomain(this.editingDomain);
            this.propertiesEditionComponent.addListener(this);
            IPropertiesEditionPart propertiesEditionPart = this.propertiesEditionComponent.getPropertiesEditionPart(1, descriptor);
            if (propertiesEditionPart instanceof IFormPropertiesEditionPart) {
                int i = 0;
                while (i < this.container.getChildren().length) {
                    Composite child = (Composite)this.container.getChildren()[i];
                    child.dispose();
                    ++i;
                }
                Composite editComposite = ((IFormPropertiesEditionPart)((Object)propertiesEditionPart)).createFigure(this.container, (FormToolkit)this.getWidgetFactory());
                if (editComposite != null) {
                    editComposite.setLayoutData((Object)new GridData(1808));
                    this.container.layout();
                    this.initSemanticContents(descriptor);
                }
            }
        }
    }

    protected void initSemanticContents(String descriptor) {
        this.propertiesEditionComponent.initPart(this.propertiesEditionComponent.translatePart(descriptor), 1, this.eObject);
    }

    private void disposeComponent() {
        if (this.propertiesEditionComponent != null) {
            this.propertiesEditionComponent.dispose();
            PropertiesContextService.getInstance().pop();
        }
    }

    private void initializeEditingDomain(IWorkbenchPart part) {
        this.editingDomain = EditingUtils.getResourceSetFromEditor(part);
    }

    public void dispose() {
        super.dispose();
        this.disposeComponent();
    }

    protected String getDescriptor() {
        Map descriptor = this.getPageDescriptor(this.propertySheetPage);
        for (Object key : descriptor.keySet()) {
            Method getId;
            Object result;
            Object tab = descriptor.get(key);
            Method getSectionAtIndex = this.getMethod(tab, "getSectionAtIndex", Integer.TYPE);
            if (getSectionAtIndex == null || (result = this.callMethod(tab, getSectionAtIndex, new Integer(0))) != this || (getId = this.getMethod(key, "getId", new Class[0])) == null) continue;
            String id = (String)this.callMethod(key, getId, new Object[0]);
            return id;
        }
        return "";
    }

    private Map getPageDescriptor(TabbedPropertySheetPage propertySheetPage) {
        Field descriptorToTabField = null;
        boolean oldAccessible = false;
        try {
            Class<?> cls = propertySheetPage.getClass();
            while (!cls.equals(TabbedPropertySheetPage.class)) {
                cls = cls.getSuperclass();
            }
            descriptorToTabField = cls.getDeclaredField("descriptorToTab");
            oldAccessible = descriptorToTabField.isAccessible();
            descriptorToTabField.setAccessible(true);
            Map map = (Map)descriptorToTabField.get(propertySheetPage);
            return map;
        }
        catch (SecurityException e) {
            EEFRuntimePlugin.getDefault().logError(EEFRuntimeUIMessages.PropertiesEditionSection_descriptorToTab_not_found, e);
        }
        catch (NoSuchFieldException e) {
            EEFRuntimePlugin.getDefault().logError(EEFRuntimeUIMessages.PropertiesEditionSection_descriptorToTab_not_found, e);
        }
        catch (IllegalArgumentException e) {
            EEFRuntimePlugin.getDefault().logError(EEFRuntimeUIMessages.PropertiesEditionSection_descriptorToTab_not_found, e);
        }
        catch (IllegalAccessException e) {
            EEFRuntimePlugin.getDefault().logError(EEFRuntimeUIMessages.PropertiesEditionSection_descriptorToTab_not_found, e);
        }
        finally {
            if (descriptorToTabField != null) {
                descriptorToTabField.setAccessible(oldAccessible);
            }
        }
        return null;
    }

    protected EObject resolveSemanticObject(Object object) {
        if (object instanceof EObject) {
            return (EObject)object;
        }
        if (object instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)object;
            if (adaptable.getAdapter(SemanticAdapter.class) != null) {
                SemanticAdapter semanticAdapter = (SemanticAdapter)adaptable.getAdapter(SemanticAdapter.class);
                return semanticAdapter.getEObject();
            }
            if (adaptable.getAdapter(EObject.class) != null) {
                return (EObject)adaptable.getAdapter(EObject.class);
            }
        }
        return null;
    }

    private Method getMethod(Object source, String name, Class ... argsType) {
        try {
            return source.getClass().getDeclaredMethod(name, argsType);
        }
        catch (Exception e) {
            EEFRuntimePlugin.getDefault().logError(String.valueOf(EEFRuntimeUIMessages.PropertiesEditionSection_method_not_found) + name, e);
            return null;
        }
    }

    private Object callMethod(Object source, Method method, Object ... args) {
        try {
            return method.invoke(source, args);
        }
        catch (Exception e) {
            EEFRuntimePlugin.getDefault().logError(String.valueOf(EEFRuntimeUIMessages.PropertiesEditionSection_error_occured_on) + method.getName() + EEFRuntimeUIMessages.PropertiesEditionSection_call, e);
            return null;
        }
    }

    public boolean select(Object toTest) {
        EObject eObj = this.resolveSemanticObject(toTest);
        if (eObj != null) {
            return this.getProvider().provides(eObj);
        }
        return false;
    }

    public void firePropertiesChanged(IPropertiesEditionEvent event) {
        this.handleChange(event);
    }

    private void handleChange(IPropertiesEditionEvent event) {
        this.messageManager.processMessage(event);
    }
}

