/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.impl.validation;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ModelValidationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EEFValidator
extends EObjectValidator {
    private final IBatchValidator batchValidator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);

    public EEFValidator() {
        this.batchValidator.setIncludeLiveConstraints(true);
        this.batchValidator.setReportSuccesses(false);
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        super.validate(eClass, eObject, diagnostics, context);
        IStatus status = Status.OK_STATUS;
        if (diagnostics != null && !this.hasProcessed(eObject, context)) {
            status = this.batchValidator.validate(eObject, (IProgressMonitor)new NullProgressMonitor());
            this.processed(eObject, context, status);
            this.appendDiagnostics(status, diagnostics);
        }
        return status.isOK();
    }

    private void processed(EObject eObject, Map<Object, Object> context, IStatus status) {
        if (context != null) {
            context.put(eObject, status);
        }
    }

    private boolean hasProcessed(EObject eObject, Map<Object, Object> context) {
        EObject toTest = eObject;
        boolean result = false;
        if (context != null) {
            while (toTest != null) {
                if (context.containsKey(toTest)) {
                    result = true;
                    toTest = null;
                    continue;
                }
                toTest = toTest.eContainer();
            }
        }
        return result;
    }

    private void appendDiagnostics(IStatus status, DiagnosticChain diagnostics) {
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.appendDiagnostics(children[i], diagnostics);
                ++i;
            }
        } else if (status instanceof IConstraintStatus) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), ((IConstraintStatus)status).getResultLocus().toArray()));
        }
    }
}

