/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.impl.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFListEditUtil {
    private List<EObject> copy;
    private List<EObject> elementsToAdd;
    private List<EObject> elementsToRemove;
    private Map<EObject, MoveElement> elementsToMove;
    private Map<EObject, EObject> elementsToRefresh;
    private Map<EObject, EObject> copyToModelMap;
    private EReference feature;
    private EReference containingFeature;

    public EMFListEditUtil(EObject eObject, EReference feature) {
        this.feature = feature;
        this.init(eObject);
    }

    public EMFListEditUtil(EObject eObject, EReference containingFeature, EReference feature) {
        this.feature = feature;
        this.containingFeature = containingFeature;
        this.init(eObject);
    }

    public void reinit(EObject eObject) {
        if (this.containingFeature == null) {
            if (this.feature.isMany()) {
                this.copy.clear();
                for (EObject next : this.clone(eObject.eGet((EStructuralFeature)this.feature))) {
                    this.copy.add(next);
                }
            } else {
                this.copy.clear();
                this.copy.addAll(this.clone(eObject.eGet((EStructuralFeature)this.feature)));
            }
        } else if (this.containingFeature != null && this.containingFeature.isMany()) {
            this.copy.clear();
            for (EObject next : this.clone(eObject.eGet((EStructuralFeature)this.containingFeature))) {
                this.copy.add(next);
            }
        } else {
            this.copy.clear();
        }
        this.elementsToAdd.clear();
        this.elementsToRemove.clear();
        this.elementsToRefresh.clear();
        this.elementsToMove.clear();
    }

    private void init(EObject eObject) {
        this.copy = this.containingFeature == null ? (this.feature.isMany() ? this.clone(eObject.eGet((EStructuralFeature)this.feature)) : this.clone(eObject.eGet((EStructuralFeature)this.feature))) : (this.containingFeature != null && this.containingFeature.isMany() ? this.clone(eObject.eGet((EStructuralFeature)this.containingFeature)) : new ArrayList<EObject>());
        this.elementsToAdd = new ArrayList<EObject>();
        this.elementsToRemove = new ArrayList<EObject>();
        this.elementsToRefresh = new HashMap<EObject, EObject>();
        this.elementsToMove = new HashMap<EObject, MoveElement>();
    }

    public List getVirtualList() {
        return this.copy;
    }

    public void addElement(EObject selectedElement) {
        if (this.elementsToRemove.contains(selectedElement)) {
            this.elementsToRemove.remove(selectedElement);
        } else {
            this.elementsToAdd.add(selectedElement);
        }
        this.copy.add(selectedElement);
    }

    public void moveElement(EObject selectedElement, int oldIndex, int newIndex) {
        EObject foundedCorrespondingEObject = this.foundCorrespondingEObject(selectedElement);
        if (foundedCorrespondingEObject != null) {
            MoveElement moveElement;
            if (this.elementsToMove.containsKey(foundedCorrespondingEObject)) {
                moveElement = this.elementsToMove.get(foundedCorrespondingEObject);
                moveElement.index = newIndex;
            } else {
                moveElement = new MoveElement();
                moveElement.element = foundedCorrespondingEObject;
                moveElement.index = newIndex;
                this.elementsToMove.put(foundedCorrespondingEObject, moveElement);
            }
            EObject oldElement = this.copy.get(newIndex);
            if (oldElement != null) {
                this.copy.set(newIndex, selectedElement);
                this.copy.set(oldIndex, oldElement);
            }
        }
    }

    public void removeElement(EObject selectedElement) {
        if (this.elementsToAdd.contains(selectedElement)) {
            this.elementsToAdd.remove(selectedElement);
        } else {
            EObject foundedCorrespondingEObject = this.foundCorrespondingEObject(selectedElement);
            if (foundedCorrespondingEObject != null) {
                if (this.elementsToRefresh.keySet().contains(selectedElement)) {
                    this.elementsToRefresh.remove(selectedElement);
                }
                this.elementsToRemove.add(foundedCorrespondingEObject);
            }
        }
        this.copy.remove(selectedElement);
    }

    public void putElementToRefresh(EObject e1, EObject e2) {
        if (this.elementsToAdd.contains(e1)) {
            this.elementsToAdd.remove(e1);
            this.elementsToAdd.add(e2);
        } else {
            this.elementsToRefresh.put(e1, e2);
        }
    }

    public List<EObject> getElementsToAdd() {
        return this.elementsToAdd;
    }

    public List<EObject> getElementsToRemove() {
        return this.elementsToRemove;
    }

    public List<MoveElement> getElementsToMove() {
        return new ArrayList<MoveElement>(this.elementsToMove.values());
    }

    private List<EObject> clone(Object object) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (object instanceof EList) {
            EList theList = (EList)object;
            this.copyToModelMap = new HashMap<EObject, EObject>(theList.size());
            for (EObject next : theList) {
                EObject copy = null;
                if (this.containingFeature != null) {
                    EObject obj = (EObject)next.eGet((EStructuralFeature)this.feature);
                    if (obj != null) {
                        copy = EcoreUtil.copy((EObject)obj);
                    }
                } else {
                    copy = EcoreUtil.copy((EObject)next);
                }
                if (copy == null) continue;
                result.add(copy);
                this.copyToModelMap.put(copy, next);
            }
        } else {
            this.copyToModelMap = new HashMap<EObject, EObject>(1);
            if (object instanceof EObject) {
                this.copyToModelMap = new HashMap<EObject, EObject>(1);
                EObject copy = null;
                copy = EcoreUtil.copy((EObject)((EObject)object));
                this.copyToModelMap.put(copy, (EObject)object);
                result.add(copy);
            }
        }
        return result;
    }

    public EObject foundCorrespondingEObject(EObject searchedObject) {
        if (this.copyToModelMap.containsKey(searchedObject)) {
            return this.copyToModelMap.get(searchedObject);
        }
        for (EObject next : this.elementsToAdd) {
            if (!EcoreUtil.equals((EObject)searchedObject, (EObject)next) || !searchedObject.equals(next)) continue;
            return next;
        }
        return null;
    }

    public Map<EObject, EObject> getElementsToRefresh() {
        return this.elementsToRefresh;
    }

    public void clearCopy() {
        this.copy.clear();
        this.copyToModelMap.clear();
    }

    public boolean contains(EObject toTest) {
        if (this.containingFeature == null) {
            boolean containedInCopy = this.copyToModelMap.values().contains(toTest);
            boolean isToBeRemoved = this.elementsToRemove.contains(this.foundCorrespondingEObject(toTest));
            boolean isToBeAdded = this.elementsToAdd.contains(this.foundCorrespondingEObject(toTest));
            return containedInCopy ? !isToBeRemoved : isToBeAdded;
        }
        for (EObject value : this.copyToModelMap.values()) {
            if ((!value.eGet((EStructuralFeature)this.feature).equals(toTest) || this.elementsToRemove.contains(this.foundCorrespondingEObject(toTest))) && !this.elementsToAdd.contains(toTest)) continue;
            return true;
        }
        return false;
    }

    public class MoveElement {
        int index;
        EObject element;

        public int getIndex() {
            return this.index;
        }

        public EObject getElement() {
            return this.element;
        }
    }
}

