/*
 * Decompiled with CFR 0.152.
 */
package temporal.mod;

import java.util.Date;
import java.util.GregorianCalendar;
import temporal.mod.TemporalDateProvider;

public class TemporalDateProviderImpl
implements TemporalDateProvider {
    private Date now = null;
    private int granularity = 12;

    protected TemporalDateProviderImpl() {
    }

    public int getGranularity() {
        return this.granularity;
    }

    public void setGranularity(int granularity) {
        this.granularity = granularity;
    }

    public void setNow(Date now) {
        this.now = now;
    }

    public Date now() {
        if (this.now == null) {
            return new Date();
        }
        return this.now;
    }

    public static TemporalDateProvider init() {
        return new TemporalDateProviderImpl();
    }

    public Date trimDate(Date date, int granularity) {
        switch (granularity) {
            case 14: {
                return date;
            }
            case 13: {
                return new Date(date.getTime());
            }
            case 12: {
                return new Date(date.getYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), 0);
            }
            case 11: {
                return new Date(date.getYear(), date.getMonth(), date.getDate(), date.getHours(), 0, 0);
            }
            case 6: {
                return new Date(date.getYear(), date.getMonth(), date.getDate(), 0, 0, 0);
            }
            case 2: {
                return new Date(date.getYear(), date.getMonth(), 0, 0, 0, 0);
            }
            case 1: {
                return new Date(date.getYear(), 0, 0, 0, 0, 0);
            }
        }
        throw new RuntimeException("unsuppored granularity");
    }

    public boolean areEqual(Date dateA, Date dateB, int granularity) {
        switch (granularity) {
            case 14: {
                return dateA.getTime() == dateB.getTime();
            }
            case 13: {
                return dateA.getSeconds() == dateB.getSeconds();
            }
            case 12: {
                return dateA.getMinutes() == dateB.getMinutes();
            }
            case 11: {
                return dateA.getHours() == dateB.getHours();
            }
            case 6: {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(dateA);
                int dayA = cal.get(5);
                GregorianCalendar calB = new GregorianCalendar();
                calB.setTime(dateB);
                int dayB = calB.get(5);
                return dayA == dayB;
            }
            case 2: {
                return dateA.getMonth() == dateB.getMonth();
            }
            case 1: {
                return dateA.getYear() == dateB.getYear();
            }
        }
        throw new RuntimeException("unsuppored granularity");
    }
}

