/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.content.part;

import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.swt.widgets.Item;

public final class ModelContentMergeTabItem {
    private final Item actualItem;
    private String curveColorID;
    private int curveSize;
    private int curveY;
    private final DiffElement difference;
    private Item visibleItem;
    private int verticalOffset;

    public ModelContentMergeTabItem(DiffElement diff, Item actual, Item visible, String drawingColor) {
        this(diff, actual, visible, drawingColor, -1, -1);
    }

    public ModelContentMergeTabItem(DiffElement diff, Item actual, Item visible, String drawingColor, int curveExpectedY, int curveExpectedSize) {
        this.difference = diff;
        this.actualItem = actual;
        this.visibleItem = visible;
        this.curveColorID = drawingColor == null ? "changed.color" : drawingColor;
        this.curveY = curveExpectedY;
        this.curveSize = curveExpectedSize;
    }

    public ModelContentMergeTabItem(DiffElement diff, Item actual, String drawingColor) {
        this(diff, actual, actual, drawingColor, -1, -1);
    }

    public Item getActualItem() {
        return this.actualItem;
    }

    public String getCurveColor() {
        return this.curveColorID;
    }

    public int getCurveSize() {
        return this.curveSize;
    }

    public int getCurveY() {
        return this.curveY;
    }

    public DiffElement getDiff() {
        return this.difference;
    }

    public int getVerticalOffset() {
        return this.verticalOffset;
    }

    public Item getVisibleItem() {
        return this.visibleItem;
    }

    public void setCurveSize(int newCurveSize) {
        this.curveSize = newCurveSize;
    }

    public void setCurveY(int newCurveY) {
        this.curveY = newCurveY;
    }

    public void setVerticalOffset(int offset) {
        this.verticalOffset = offset;
    }

    public void setVisibleItem(Item newVisibleItem) {
        this.visibleItem = newVisibleItem;
    }

    public String toString() {
        String result = "actual item=";
        result = String.valueOf(result) + this.actualItem;
        result = String.valueOf(result) + "\tvisible item=";
        result = String.valueOf(result) + this.visibleItem;
        result = String.valueOf(result) + "\t(curveColor=";
        result = String.valueOf(result) + this.curveColorID;
        result = String.valueOf(result) + ", curveSize=";
        result = String.valueOf(result) + this.curveSize;
        result = String.valueOf(result) + ", curveY=";
        result = String.valueOf(result) + this.curveY;
        result = String.valueOf(result) + ')';
        return result;
    }
}

