/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import java.util.List;
import org.eclipse.emf.cdo.CDOSession;
import org.eclipse.emf.cdo.internal.ui.actions.SessionAction;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.util.CDOPackageRegistry;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegisterPackagesAction
extends SessionAction {
    private List<EPackage> ePackages;
    private int errors;

    public RegisterPackagesAction(IWorkbenchPage page, String text, String toolTipText, ImageDescriptor image, CDOSession session) {
        super(page, text, toolTipText, image, session);
    }

    protected void preRun() throws Exception {
        this.ePackages = this.getEPackages(this.getPage(), this.getSession());
        if (this.ePackages == null) {
            this.cancel();
        }
    }

    protected void doRun() throws Exception {
        this.errors = 0;
        CDOPackageRegistry packageRegistry = this.getSession().getPackageRegistry();
        for (EPackage ePackage : this.ePackages) {
            EcoreUtil.freeze((EPackage)ePackage);
            Resource resource = ePackage.eResource();
            URI uri = resource == null ? null : resource.getURI();
            try {
                packageRegistry.putEPackage(ePackage);
            }
            catch (RuntimeException ex) {
                ++this.errors;
                if (uri == null) {
                    OM.LOG.error((Throwable)ex);
                    continue;
                }
                OM.LOG.error("Failed to register package " + uri, (Throwable)ex);
            }
        }
        this.postRegistration(this.ePackages);
        if (this.errors != 0) {
            final String label = String.valueOf(String.valueOf(this.errors)) + (this.errors == 1 ? " package has" : " packages have");
            final Shell shell = this.getShell();
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)shell, (String)RegisterPackagesAction.this.getText(), (String)(String.valueOf(label) + " not been registered due to errors.\nSee the log for details."));
                }
            });
        }
    }

    protected void postRegistration(List<EPackage> ePackages) {
    }

    protected abstract List<EPackage> getEPackages(IWorkbenchPage var1, CDOSession var2);
}

