/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOModelElement;
import org.eclipse.emf.cdo.server.db.IDBStoreReader;
import org.eclipse.emf.cdo.server.db.IDBStoreWriter;
import org.eclipse.emf.cdo.server.db.IObjectTypeCache;
import org.eclipse.emf.cdo.server.internal.db.ClassServerInfo;
import org.eclipse.emf.cdo.server.internal.db.MappingStrategy;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public class ObjectTypeCache
extends Lifecycle
implements IObjectTypeCache {
    private MappingStrategy mappingStrategy;
    private IDBTable table;
    private IDBField idField;
    private IDBField typeField;
    private transient Object initializeLock = new Object();

    public MappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    public void setMappingStrategy(MappingStrategy mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
    }

    public CDOClassRef getObjectType(IDBStoreReader storeReader, CDOID id) {
        Statement statement = storeReader.getStatement();
        this.initialize(statement);
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.typeField);
        builder.append(" FROM ");
        builder.append(this.table);
        builder.append(" WHERE ");
        builder.append(this.idField);
        builder.append("=");
        builder.append(CDOIDUtil.getLong((CDOID)id));
        String sql = builder.toString();
        DBUtil.trace((String)sql);
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery(sql);
            if (!resultSet.next()) {
                throw new DBException("ClassID for CDOID " + id + " not found");
            }
            int classID = resultSet.getInt(1);
            CDOClassRef cDOClassRef = this.mappingStrategy.getClassRef(storeReader, classID);
            return cDOClassRef;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        finally {
            DBUtil.close((ResultSet)resultSet);
        }
    }

    public void putObjectType(IDBStoreWriter storeWriter, CDOID id, CDOClass type) {
        Statement statement = storeWriter.getStatement();
        this.initialize(statement);
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.table);
        builder.append(" VALUES (");
        builder.append(CDOIDUtil.getLong((CDOID)id));
        builder.append(", ");
        builder.append(ClassServerInfo.getDBID((CDOModelElement)type));
        builder.append(")");
        String sql = builder.toString();
        DBUtil.trace((String)sql);
        try {
            statement.execute(sql);
            if (statement.getUpdateCount() != 1) {
                throw new DBException("Object type not inserted: " + id + " -> " + type);
            }
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(Statement statement) {
        Object object = this.initializeLock;
        synchronized (object) {
            if (this.table == null) {
                IDBSchema schema = this.mappingStrategy.getStore().getDBSchema();
                this.table = schema.addTable("cdo_objects");
                this.idField = this.table.addField("cdo_id", DBType.BIGINT);
                this.typeField = this.table.addField("cdo_class", DBType.INTEGER);
                this.table.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{this.idField});
                IDBAdapter dbAdapter = this.mappingStrategy.getStore().getDBAdapter();
                dbAdapter.createTable(this.table, statement);
            }
        }
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.mappingStrategy, "mappingStrategy");
    }

    protected void doDeactivate() throws Exception {
        this.table = null;
        this.idField = null;
        this.typeField = null;
        super.doDeactivate();
    }
}

