/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.emf.cdo.common.util.BlockingCloseableIterator;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Closeable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOQueryQueue<E>
implements Queue<E>,
Closeable {
    private static final long serialVersionUID = 1L;
    private final QueueEntry<E> QUEUE_CLOSED = new QueueEntry();
    private PriorityBlockingQueue<QueueEntry<E>> queue = new PriorityBlockingQueue(10);
    private boolean closed;
    private Object closeLock = new Object();

    public void setException(Throwable exception) {
        this.queue.add(new QueueEntry(exception));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                this.queue.add(this.QUEUE_CLOSED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }

    @Override
    public boolean add(E e) {
        return this.queue.add(new QueueEntry<E>(e));
    }

    @Override
    public boolean addAll(Collection c) {
        return this.queue.addAll(c);
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    public Comparator comparator() {
        return this.queue.comparator();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.queue.containsAll(c);
    }

    public int drainTo(Collection c, int maxElements) {
        return this.queue.drainTo(c, maxElements);
    }

    public int drainTo(Collection c) {
        return this.queue.drainTo(c);
    }

    @Override
    public E element() {
        return this.checkObject((QueueEntry)this.queue.element());
    }

    @Override
    public boolean equals(Object obj) {
        return this.queue.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.queue.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public BlockingCloseableIterator<E> iterator() {
        return new BlockingCloseableIteratorImpl();
    }

    public boolean offer(E e, long timeout, TimeUnit unit) {
        return this.queue.offer(new QueueEntry<E>(e), timeout, unit);
    }

    @Override
    public boolean offer(E e) {
        return this.queue.offer(new QueueEntry<E>(e));
    }

    @Override
    public E peek() {
        return this.checkObject(this.queue.peek());
    }

    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.checkObject(this.queue.poll(timeout, unit));
    }

    public void put(E e) {
        this.queue.put(new QueueEntry<E>(e));
    }

    public int remainingCapacity() {
        return this.queue.remainingCapacity();
    }

    @Override
    public E remove() {
        return this.checkObject((QueueEntry)this.queue.remove());
    }

    @Override
    public boolean remove(Object o) {
        return this.queue.remove(o);
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.queue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.queue.retainAll(c);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    public E take() throws InterruptedException {
        QueueEntry<E> entry = null;
        entry = this.queue.take();
        return this.checkObject(entry);
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.queue.toArray(a);
    }

    public String toString() {
        return this.queue.toString();
    }

    @Override
    public E poll() {
        QueueEntry<E> entry = this.queue.poll();
        return this.checkObject(entry);
    }

    private E checkObject(QueueEntry<E> entry) {
        if (entry == null || entry == this.QUEUE_CLOSED) {
            return null;
        }
        return entry.getObjectWithException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BlockingCloseableIteratorImpl
    implements BlockingCloseableIterator<E> {
        private boolean closed;
        private E nextElement;

        @Override
        public E peek() {
            if (this.nextElement == null) {
                return CDOQueryQueue.this.peek();
            }
            return this.nextElement;
        }

        public boolean hasNext() {
            this.privateNext(false);
            return this.nextElement != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void privateNext(boolean failOnNull) {
            if (this.nextElement == null) {
                try {
                    Object object = CDOQueryQueue.this.closeLock;
                    synchronized (object) {
                        if (CDOQueryQueue.this.isEmpty() && CDOQueryQueue.this.isClosed()) {
                            if (failOnNull) {
                                throw new NoSuchElementException();
                            }
                            return;
                        }
                    }
                    this.nextElement = CDOQueryQueue.this.take();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public E next() {
            try {
                this.privateNext(true);
                Object e = this.nextElement;
                return e;
            }
            finally {
                this.nextElement = null;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueueEntry<E>
    implements Comparable<QueueEntry<E>> {
        private static final AtomicLong nextSeq = new AtomicLong(0L);
        private long seqNumber;
        private Object internalObject;

        public QueueEntry() {
            this.seqNumber = Long.MAX_VALUE;
        }

        public QueueEntry(E object) {
            this.internalObject = object;
            this.seqNumber = nextSeq.getAndIncrement();
        }

        public QueueEntry(Throwable object) {
            this.internalObject = object;
            this.seqNumber = nextSeq.getAndIncrement();
        }

        public E getObjectWithException() {
            Throwable exception = this.getException();
            if (exception != null) {
                throw WrappedException.wrap((Exception)((Exception)exception));
            }
            return (E)this.internalObject;
        }

        public Throwable getException() {
            if (this.internalObject instanceof Throwable) {
                return (Throwable)this.internalObject;
            }
            return null;
        }

        @Override
        public int compareTo(QueueEntry<E> o) {
            if (this.getException() != null) {
                return -1;
            }
            if (o.getException() != null) {
                return 1;
            }
            if (this == o) {
                return 0;
            }
            if (this.seqNumber == o.seqNumber) {
                return 0;
            }
            return this.seqNumber < o.seqNumber ? -1 : 1;
        }
    }
}

