/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.fullcomparison;

import com.google.common.collect.Lists;
import java.util.Iterator;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.match.eobject.EditionDistance;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.compare.tests.suite.AllTests;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public class DistanceAxiomsTests {
    private ProximityEObjectMatcher.DistanceFunction meter;
    private Comparison comparison;
    @DataPoints
    public static EObject[] allEcore = DistanceAxiomsTests.createFingerPrintsFromModel((EObject)EcorePackage.eINSTANCE);

    @Before
    public void setUp() throws Exception {
        AllTests.fillEMFRegistries();
        this.comparison = CompareFactory.eINSTANCE.createComparison();
        this.meter = new EditionDistance();
    }

    @Theory
    public void symetry(EObject a, EObject b) {
        Assume.assumeTrue((a.eClass() == b.eClass() ? 1 : 0) != 0);
        double aTob = this.meter.distance(this.comparison, a, b);
        double bToa = this.meter.distance(this.comparison, b, a);
        Assert.assertEquals((double)aTob, (double)bToa, (double)0.01);
    }

    private static EObject[] createFingerPrintsFromModel(EObject einstance) {
        return Lists.newArrayList((Iterator)einstance.eAllContents()).toArray(new EObject[0]);
    }

    @Theory
    public void separation(EObject a) {
        Assert.assertEquals((double)0.0, (double)this.meter.distance(this.comparison, a, a), (double)0.01);
    }

    @Theory
    public void triangularInequality(EObject x, EObject y, EObject z) {
        Assume.assumeTrue((x.eClass() == y.eClass() && x.eClass() == z.eClass() ? 1 : 0) != 0);
        double xToz = this.meter.distance(this.comparison, x, z);
        double xToy = this.meter.distance(this.comparison, x, y);
        double yToz = this.meter.distance(this.comparison, y, z);
        Assert.assertTrue((String)("Triangular inequality (x-z <= x-y + y-z ) failed (" + xToz + "<=" + xToy + " + " + yToz + ")for \nx:" + x.toString() + "\n|y:" + y.toString() + "\n|z:" + z.toString()), (xToz <= xToy + yToz ? 1 : 0) != 0);
    }
}

