/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.MergeBlockedByConflictException;

public class ComputeDiffsToMerge {
    private final boolean rightToLeft;
    private Set<Diff> result = new LinkedHashSet<Diff>();
    private Set<Diff> globalResult;
    private Set<Diff> computing = new HashSet<Diff>();
    private Predicate<? super Conflict> conflictChecker;
    private IDiffRelationshipComputer relationshipComputer;

    public ComputeDiffsToMerge(boolean rightToLeft, IMerger.Registry2 registry) {
        this(rightToLeft, new DiffRelationshipComputer(registry, IMergeCriterion.NONE));
    }

    public ComputeDiffsToMerge(boolean rightToLeft, IMerger.Registry2 registry, IMergeCriterion criterion) {
        this(rightToLeft, new DiffRelationshipComputer(registry, criterion));
    }

    public ComputeDiffsToMerge(boolean rightToLeft, IDiffRelationshipComputer relationshipComputer) {
        this.rightToLeft = rightToLeft;
        this.relationshipComputer = relationshipComputer;
    }

    public ComputeDiffsToMerge failOnRealConflictUnless(Predicate<? super Conflict> predicate) {
        this.conflictChecker = predicate;
        return this;
    }

    public Set<Diff> getAllDiffsToMerge(Iterable<? extends Diff> diffs) {
        try {
            this.globalResult = Sets.newLinkedHashSet();
            HashSet globalIgnoredDiffs = Sets.newHashSet();
            LinkedHashSet diffPath = Sets.newLinkedHashSet();
            for (Diff diff : diffs) {
                if (globalIgnoredDiffs.contains(diff) || this.globalResult.contains(diff)) continue;
                try {
                    this.result.clear();
                    this.computing.clear();
                    diffPath.clear();
                    this.addDiffs(Collections.singleton(diff), diffPath);
                    this.globalResult.addAll(this.result);
                }
                catch (MergeBlockedByConflictException ex) {
                    globalIgnoredDiffs.addAll(ex.getConflictingDiffs());
                }
            }
            Set<Diff> set = this.globalResult;
            return set;
        }
        finally {
            this.globalResult = null;
        }
    }

    public Set<Diff> getAllDiffsToMerge(Diff diff) {
        this.result.clear();
        this.computing.clear();
        this.addDiff(diff);
        return this.result;
    }

    protected void addDiff(Diff diff) {
        this.addDiffs(Collections.singleton(diff), Sets.newLinkedHashSet());
    }

    protected void addDiffs(Collection<Diff> diffs, Set<Diff> diffPath) {
        if (diffs.isEmpty()) {
            return;
        }
        LinkedHashSet<Diff> consequences = new LinkedHashSet<Diff>();
        for (Diff diff : diffs) {
            this.addDiff(diff, consequences, diffPath);
        }
        this.addDiffs(consequences, diffPath);
    }

    protected void addDiff(Diff diff, Set<Diff> consequences, Set<Diff> diffPath) {
        if (!(this.result.contains(diff) || this.globalResult != null && this.globalResult.contains(diff) || !this.computing.add(diff))) {
            Conflict conflict;
            boolean addedToPath = diffPath.add(diff);
            if (this.conflictChecker != null && (conflict = diff.getConflict()) != null && conflict.getKind() == ConflictKind.REAL && !this.conflictChecker.apply((Object)conflict)) {
                throw new MergeBlockedByConflictException(diffPath);
            }
            Set<Diff> dependencies = this.relationshipComputer.getDirectMergeDependencies(diff, this.rightToLeft);
            for (Diff required : dependencies) {
                this.addDiff(required, consequences, diffPath);
            }
            this.result.add(diff);
            this.computing.remove(diff);
            Set<Diff> directResultingMerges = this.relationshipComputer.getDirectResultingMerges(diff, this.rightToLeft);
            consequences.addAll(directResultingMerges);
            if (addedToPath) {
                diffPath.remove(diff);
            }
        }
    }
}

