/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.merge;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.GitTestRunner;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitInput;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitMerge;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.api.Status;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;

@RunWith(value=GitTestRunner.class)
public class EMFResourceMappingMergerPreMergeTest {
    protected static final IPreferenceStore EMF_COMPARE_PREFS = EMFCompareIDEUIPlugin.getDefault().getPreferenceStore();
    protected static boolean PRE_MERGE_CONFLICT_SETTING;

    @BeforeClass
    public static void setupClass() {
        PRE_MERGE_CONFLICT_SETTING = EMF_COMPARE_PREFS.getBoolean("org.eclipse.emf.compare.ide.ui.preference.preMergeOnConflict");
        EMF_COMPARE_PREFS.setValue("org.eclipse.emf.compare.ide.ui.preference.preMergeOnConflict", true);
    }

    @AfterClass
    public static void tearDownClass() {
        EMFCompareIDEUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.emf.compare.ide.ui.preference.preMergeOnConflict", PRE_MERGE_CONFLICT_SETTING);
    }

    @GitInput(value="data/premerge/bug_preMergeWithConflict.zip")
    @GitMerge(local="renameClassA", remote="renameClassA_addOtherModel")
    public void testPreMergeWithConflictL2R(Status status, List<IProject> projects) {
        IProject project = this.assertSingleProject(projects);
        this.assertFilesExist(project, "model.uml", "model.notation", "model.di", "otherModel.uml", "otherModel.notation", "otherModel.di");
        this.assertFilesConflict(status, "PreMergeWithConflict/model.uml");
    }

    @GitInput(value="data/premerge/bug_preMergeWithConflict.zip")
    @GitMerge(local="renameClassA_addOtherModel", remote="renameClassA")
    public void testPreMergeWithConflictR2L(Status status, List<IProject> projects) {
        IProject project = this.assertSingleProject(projects);
        this.assertFilesExist(project, "model.uml", "model.notation", "model.di", "otherModel.uml", "otherModel.notation", "otherModel.di");
        this.assertFilesConflict(status, "PreMergeWithConflict/model.uml");
    }

    protected IProject assertSingleProject(List<IProject> projects) {
        Assert.assertEquals((long)1L, (long)projects.size());
        return projects.get(0);
    }

    protected void assertFilesExist(IProject project, String ... files) {
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            Assert.assertTrue((String)(String.valueOf(file) + " does not exist."), (boolean)project.getFile(file).exists());
            ++n2;
        }
    }

    protected void assertFilesConflict(Status status, String ... files) {
        Set conflicting = status.getConflicting();
        Assert.assertEquals((long)files.length, (long)conflicting.size());
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            Assert.assertTrue((String)(String.valueOf(file) + " is not conflicting."), (boolean)conflicting.contains(file));
            ++n2;
        }
    }
}

