/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.filters;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.CascadingDifferencesFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.BasicDifferenceGroupImpl;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.DiffNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.MatchNode;
import org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups.provider.AbstractTestTreeNodeItemProviderAdapter;
import org.eclipse.emf.compare.tests.edit.data.ResourceScopeProvider;
import org.eclipse.emf.compare.tests.framework.AbstractInputData;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.emf.edit.tree.TreePackage;
import org.junit.Assert;
import org.junit.Test;

public class TestBug435365
extends AbstractTestTreeNodeItemProviderAdapter {
    @Test
    public void testCascadingFilterNotHidingDiffUnderMove() throws IOException {
        Comparison comparison = TestBug435365.getComparison(new Bug435365Scope());
        ECrossReferenceAdapter crossReferenceAdapter = new ECrossReferenceAdapter(){

            protected boolean isIncluded(EReference eReference) {
                return eReference == TreePackage.Literals.TREE_NODE__DATA;
            }
        };
        BasicDifferenceGroupImpl group = new BasicDifferenceGroupImpl(comparison, Predicates.alwaysTrue(), crossReferenceAdapter);
        List roots = group.getChildren();
        TreeNode movingNode = (TreeNode)((TreeNode)((TreeNode)roots.get(0)).getChildren().get(0)).getChildren().get(0);
        Predicate cascadingFilter = new CascadingDifferencesFilter().getPredicateWhenSelected();
        Assert.assertFalse((boolean)cascadingFilter.apply((Object)movingNode));
        EList children = movingNode.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        DiffNode diffNode = (DiffNode)children.get(0);
        Assert.assertFalse((boolean)cascadingFilter.apply((Object)diffNode));
        MatchNode matchNode = (MatchNode)children.get(1);
        Assert.assertFalse((boolean)cascadingFilter.apply((Object)matchNode));
        Assert.assertEquals((long)1L, (long)matchNode.getChildren().size());
        diffNode = (DiffNode)matchNode.getChildren().get(0);
        Assert.assertFalse((boolean)cascadingFilter.apply((Object)diffNode));
    }

    public class Bug435365Scope
    extends AbstractInputData
    implements ResourceScopeProvider {
        public Resource getLeft() throws IOException {
            return this.loadFromClassLoader("data/_435365/afterMove.nodes");
        }

        public Resource getRight() throws IOException {
            return this.loadFromClassLoader("data/_435365/beforeMove.nodes");
        }

        public Resource getOrigin() throws IOException {
            return null;
        }
    }
}

