/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.contentmergeviewer.util;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ide.ui.tests.contentmergeviewer.util.AbstractReverseActionTest;
import org.eclipse.emf.compare.ide.ui.tests.contentmergeviewer.util.data.UtilInputData;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.utils.EMFCompareTestsUtils;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public class UndoActionTest
extends AbstractReverseActionTest {
    private Comparison comparison;
    private DefaultComparisonScope scope;
    private UtilInputData utilInput = new UtilInputData();

    @Test
    public void testUndoMergeL2RNodes1() throws IOException {
        Resource leftResource = this.utilInput.getNodes1Left();
        Resource rightResource = this.utilInput.getNodes1Right();
        Resource unchangedRight = this.utilInput.getNodes1Right();
        this.scope = new DefaultComparisonScope((Notifier)leftResource, (Notifier)rightResource, null);
        this.comparison = EMFCompare.builder().build().compare((IComparisonScope)this.getScope());
        this.mergeDiffsLeftToRight((List<? extends Diff>)this.comparison.getDifferences());
        EMFCompareTestsUtils.assertEqualContents((Comparison)this.comparison, this.getNodes(leftResource), this.getNodes(rightResource));
        this.undo();
        this.scope = new DefaultComparisonScope((Notifier)rightResource, (Notifier)unchangedRight, null);
        this.comparison = EMFCompare.builder().build().compare((IComparisonScope)this.getScope());
        Assert.assertTrue((boolean)this.comparison.getDifferences().isEmpty());
        EMFCompareTestsUtils.assertEqualContents((Comparison)this.comparison, this.getNodes(rightResource), this.getNodes(unchangedRight));
    }

    @Test
    public void testUndoMergeR2LNodes1() throws IOException {
        Resource leftResource = this.utilInput.getNodes1Left();
        Resource rightResource = this.utilInput.getNodes1Right();
        Resource unchangedLeft = this.utilInput.getNodes1Left();
        this.scope = new DefaultComparisonScope((Notifier)leftResource, (Notifier)rightResource, null);
        this.comparison = EMFCompare.builder().build().compare((IComparisonScope)this.getScope());
        this.mergeDiffsRightToLeft((List<? extends Diff>)this.comparison.getDifferences());
        EMFCompareTestsUtils.assertEqualContents((Comparison)this.comparison, this.getNodes(leftResource), this.getNodes(rightResource));
        this.undo();
        this.scope = new DefaultComparisonScope((Notifier)leftResource, (Notifier)unchangedLeft, null);
        this.comparison = EMFCompare.builder().build().compare((IComparisonScope)this.getScope());
        Assert.assertTrue((boolean)this.comparison.getDifferences().isEmpty());
        EMFCompareTestsUtils.assertEqualContents((Comparison)this.comparison, this.getNodes(leftResource), this.getNodes(unchangedLeft));
    }

    @Override
    public DefaultComparisonScope getScope() {
        return this.scope;
    }
}

