/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.EMFCompareContentMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.TreeMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractTreeContentMergeViewer
extends EMFCompareContentMergeViewer {
    private double[] fBasicCenterCurve;

    public AbstractTreeContentMergeViewer(int style, ResourceBundle bundle, EMFCompareConfiguration config) {
        super(style, bundle, config);
    }

    public TreeMergeViewer getAncestorMergeViewer() {
        return (TreeMergeViewer)super.getAncestorMergeViewer();
    }

    public TreeMergeViewer getLeftMergeViewer() {
        return (TreeMergeViewer)super.getLeftMergeViewer();
    }

    public TreeMergeViewer getRightMergeViewer() {
        return (TreeMergeViewer)super.getRightMergeViewer();
    }

    protected byte[] getContents(boolean left) {
        return null;
    }

    protected void hookListeners(TreeMergeViewer treeMergeViewer) {
        treeMergeViewer.getStructuredViewer().getTree().getVerticalBar().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AbstractTreeContentMergeViewer.this.redrawCenterControl();
            }
        });
        treeMergeViewer.getStructuredViewer().getTree().addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                AbstractTreeContentMergeViewer.this.redrawCenterControl();
            }
        });
        treeMergeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractTreeContentMergeViewer.this.redrawCenterControl();
            }
        });
    }

    @Override
    protected void paintCenter(GC g) {
        TreeMergeViewer leftMergeViewer = this.getLeftMergeViewer();
        TreeMergeViewer rightMergeViewer = this.getRightMergeViewer();
        Tree leftTree = leftMergeViewer.getStructuredViewer().getTree();
        Tree rightTree = rightMergeViewer.getStructuredViewer().getTree();
        Rectangle leftClientArea = leftTree.getClientArea();
        Rectangle rightClientArea = rightTree.getClientArea();
        List<TreeItem> leftItems = this.getExpandedTreeItems(leftTree);
        List<TreeItem> rightItems = this.getExpandedTreeItems(rightTree);
        ImmutableSet selection = ImmutableSet.copyOf((Object[])leftTree.getSelection());
        for (TreeItem leftItem : leftItems) {
            TreeItem rightItem;
            boolean selected = Iterables.any((Iterable)selection, (Predicate)Predicates.equalTo((Object)leftItem));
            IMergeViewerItem leftData = (IMergeViewerItem)leftItem.getData();
            Diff leftDiff = leftData.getDiff();
            if (leftDiff == null || MergeViewerUtil.isMarkAsMerged((Diff)leftDiff, (IMergeViewerItem)leftData, (IEMFCompareConfiguration)this.getCompareConfiguration()) || (rightItem = this.findRightTreeItemFromLeftDiff(rightItems, leftDiff, leftData)) == null) continue;
            Color strokeColor = this.getCompareColor().getStrokeColor(leftDiff, this.isThreeWay(), false, selected);
            g.setForeground(strokeColor);
            this.drawCenterLine(g, leftClientArea, rightClientArea, leftItem, rightItem);
        }
    }

    private List<TreeItem> getExpandedTreeItems(Tree tree) {
        return this.getExpandedTreeItems(tree.getItems());
    }

    private List<TreeItem> getExpandedTreeItems(TreeItem[] items) {
        ArrayList ret = Lists.newArrayList();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            ret.add(item);
            if (item.getExpanded()) {
                ret.addAll(this.getExpandedTreeItems(item.getItems()));
            }
            ++n2;
        }
        return ret;
    }

    private void drawCenterLine(GC g, Rectangle leftClientArea, Rectangle rightClientArea, TreeItem leftItem, TreeItem rightItem) {
        Control control = this.getCenterControl();
        Point from = new Point(0, 0);
        Point to = new Point(0, 0);
        Rectangle leftBounds = leftItem.getBounds();
        Rectangle rightBounds = rightItem.getBounds();
        from.y = leftBounds.y + leftBounds.height / 2 - leftClientArea.y;
        if ("gtk".equals(SWT.getPlatform())) {
            --from.y;
        } else if ("win32".equals(SWT.getPlatform())) {
            ++from.y;
        }
        to.x = control.getBounds().width;
        to.y = rightBounds.y + rightBounds.height / 2 - rightClientArea.y;
        if ("gtk".equals(SWT.getPlatform())) {
            --to.y;
        } else if ("win32".equals(SWT.getPlatform())) {
            ++to.y;
        }
        int[] points = this.getCenterCurvePoints(from, to);
        int i = 1;
        while (i < points.length) {
            g.drawLine(from.x + i - 1, points[i - 1], i, points[i]);
            ++i;
        }
    }

    private TreeItem findRightTreeItemFromLeftDiff(List<TreeItem> rightItems, Diff leftDiff, IMergeViewerItem leftData) {
        TreeItem ret = null;
        for (TreeItem rightItem : rightItems) {
            IMergeViewerItem rightData = (IMergeViewerItem)rightItem.getData();
            Diff rightDiff = rightData.getDiff();
            if (leftDiff == rightDiff) {
                return rightItem;
            }
            if (rightData.getAncestor() != leftData.getAncestor() || rightData.getRight() != leftData.getRight() || rightData.getLeft() != leftData.getLeft()) continue;
            ret = rightItem;
        }
        return ret;
    }

    private int[] getCenterCurvePoints(Point from, Point to) {
        int startx = from.x;
        int starty = from.y;
        int endx = to.x;
        int endy = to.y;
        if (this.fBasicCenterCurve == null) {
            this.buildBaseCenterCurve(endx - startx);
        }
        double height = endy - starty;
        height /= 2.0;
        int width = endx - startx;
        int[] points = new int[width];
        int i = 0;
        while (i < width) {
            points[i] = (int)(-height * this.fBasicCenterCurve[i] + height + (double)starty);
            ++i;
        }
        return points;
    }

    private void buildBaseCenterCurve(int w) {
        double width = w;
        this.fBasicCenterCurve = new double[this.getCenterWidth()];
        int i = 0;
        while (i < this.getCenterWidth()) {
            double r = (double)i / width;
            this.fBasicCenterCurve[i] = Math.cos(Math.PI * r);
            ++i;
        }
    }
}

