/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.DiagramMergeViewer;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.IDecoratorManager;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.figures.DecoratorFigure;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListItemEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public abstract class AbstractDecoratorManager
implements IDecoratorManager {
    private EMFCompareConfiguration fCompareConfiguration;
    private DiagramMergeViewer fLeft;
    private DiagramMergeViewer fRight;
    private DiagramMergeViewer fAncestor;
    private ICompareColor fColor;

    protected AbstractDecoratorManager(EMFCompareConfiguration compareConfiguration, DiagramMergeViewer left, DiagramMergeViewer right, DiagramMergeViewer ancestor, ICompareColor color) {
        this.fCompareConfiguration = compareConfiguration;
        this.fLeft = left;
        this.fRight = right;
        this.fAncestor = ancestor;
        this.fColor = color;
    }

    protected EMFCompareConfiguration getCompareConfiguration() {
        return this.fCompareConfiguration;
    }

    protected DiagramMergeViewer getLeftMergeViewer() {
        return this.fLeft;
    }

    protected DiagramMergeViewer getRightMergeViewer() {
        return this.fRight;
    }

    protected DiagramMergeViewer getAncestorMergeViewer() {
        return this.fAncestor;
    }

    protected boolean isThreeWay() {
        return this.getCompareConfiguration().getComparison().isThreeWay();
    }

    public ICompareColor getCompareColor() {
        return this.fColor;
    }

    @Override
    public void hideDecorators(Diff difference) {
        Collection<? extends AbstractDecorator> oldDecorators = this.getDecorators(difference);
        if (oldDecorators != null && !oldDecorators.isEmpty() && this.getCompareConfiguration().getComparison() != null) {
            this.handleDecorators(oldDecorators, false, true);
        }
    }

    @Override
    public void revealDecorators(Diff difference) {
        Collection<? extends AbstractDecorator> decorators = this.getDecorators(difference);
        if ((decorators == null || decorators.isEmpty()) && this.isGoodCandidate(difference)) {
            DiagramDiff diagramDiff = (DiagramDiff)difference;
            List<View> referenveViews = this.getReferenceViews(diagramDiff);
            for (View referenceView : referenveViews) {
                AbstractDecorator decorator;
                IFigure referenceFigure = this.getFigure(referenceView);
                if (referenceFigure == null) continue;
                IMergeViewer.MergeViewerSide targetSide = this.getTargetSide(this.getCompareConfiguration().getComparison().getMatch((EObject)referenceView), referenceView);
                if (decorators == null) {
                    decorators = new ArrayList<AbstractDecorator>();
                }
                if ((decorator = this.createAndRegisterDecorator(difference, referenceView, referenceFigure, targetSide)) == null) continue;
                decorators.add(decorator);
            }
        }
        if (decorators != null && !decorators.isEmpty()) {
            this.revealDecorators(decorators);
        }
    }

    @Override
    public abstract void removeDecorators(Diff var1);

    @Override
    public abstract void removeAll();

    protected void revealDecorators(Collection<? extends AbstractDecorator> decorators) {
        this.handleDecorators(decorators, true, true);
    }

    protected IFigure getFigure(View view) {
        IMergeViewer.MergeViewerSide side = this.getSide(view);
        GraphicalEditPart originEditPart = (GraphicalEditPart)this.getViewer(side).getEditPart((EObject)view);
        if (originEditPart != null) {
            return originEditPart.getFigure();
        }
        return null;
    }

    protected void handleDecorators(Collection<? extends AbstractDecorator> decorators, boolean isAdd, boolean areMain) {
        for (AbstractDecorator abstractDecorator : decorators) {
            this.handleDecorator(abstractDecorator, isAdd, areMain);
        }
    }

    protected void handleDecorator(AbstractDecorator decorator, boolean isAdd, boolean isMain) {
        IFigure layer = decorator.getLayer();
        IFigure figure = decorator.getFigure();
        if (isAdd) {
            this.handleAddDecorator(decorator, layer, figure, isMain);
        } else if (layer.getChildren().contains(figure)) {
            this.handleDeleteDecorator(decorator, layer, figure);
        }
    }

    protected void handleAddDecorator(AbstractDecorator decorator, IFigure parent, IFigure toAdd, boolean isMain) {
        if (decorator.getEditPart() != null) {
            decorator.getEditPart().activate();
        }
        if (!parent.getChildren().contains(toAdd)) {
            parent.add(toAdd);
        }
    }

    protected void handleDeleteDecorator(AbstractDecorator decorator, IFigure parent, IFigure toDelete) {
        if (decorator.getEditPart() != null) {
            decorator.getEditPart().deactivate();
        }
        if (parent.getChildren().contains(toDelete)) {
            parent.remove(toDelete);
        }
    }

    private boolean isGoodCandidate(Diff difference) {
        return this.goodCandidate().apply((Object)difference);
    }

    protected IFigure getLayer(View referenceView, IMergeViewer.MergeViewerSide side) {
        Diagram referenceDiagram = referenceView.getDiagram();
        Diagram targetDiagram = (Diagram)this.getMatchView((EObject)referenceDiagram, this.getEffectiveSide(side));
        DiagramMergeViewer targetViewer = this.getViewer(side);
        EditPart editPart = targetViewer.getEditPart((EObject)targetDiagram);
        if (editPart != null) {
            return LayerManager.Helper.find((EditPart)editPart).getLayer(this.getIDLayer(referenceView));
        }
        return null;
    }

    protected Object getIDLayer(View referenceView) {
        if (referenceView instanceof Edge) {
            return "Connection Layer";
        }
        return "Scalable Layers";
    }

    protected void translateCoordinates(IFigure referenceFigure, IFigure rootReferenceFigure, Rectangle boundsToTranslate) {
        IFigure referenceParentFigure = referenceFigure.getParent();
        if (referenceParentFigure != null && referenceFigure != rootReferenceFigure) {
            if (referenceParentFigure.isCoordinateSystem() && referenceParentFigure != rootReferenceFigure) {
                boundsToTranslate.x += referenceParentFigure.getBounds().x;
                boundsToTranslate.y += referenceParentFigure.getBounds().y;
            }
            this.translateCoordinates(referenceParentFigure, rootReferenceFigure, boundsToTranslate);
        }
    }

    protected boolean isNodeList(View view) {
        DiagramMergeViewer viewer = this.getViewer(this.getSide(view));
        EditPart part = viewer.getEditPart((EObject)view);
        return this.isNodeList(part);
    }

    private boolean isNodeList(EditPart part) {
        return part instanceof ListItemEditPart || this.isInListContainer(part);
    }

    private boolean isInListContainer(EditPart part) {
        EditPart parent = part.getParent();
        while (parent != null) {
            if (parent instanceof ListCompartmentEditPart) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public DiagramMergeViewer getViewer(IMergeViewer.MergeViewerSide side) {
        DiagramMergeViewer result = null;
        switch (side) {
            case LEFT: {
                result = this.getLeftMergeViewer();
                break;
            }
            case RIGHT: {
                result = this.getRightMergeViewer();
                break;
            }
            case ANCESTOR: {
                result = this.getAncestorMergeViewer();
            }
        }
        return result;
    }

    public IMergeViewer.MergeViewerSide getSide(View view) {
        IMergeViewer.MergeViewerSide result = null;
        Match match = this.getCompareConfiguration().getComparison().getMatch((EObject)view);
        if (match.getLeft() == view) {
            result = IMergeViewer.MergeViewerSide.LEFT;
        } else if (match.getRight() == view) {
            result = IMergeViewer.MergeViewerSide.RIGHT;
        } else if (match.getOrigin() == view) {
            result = IMergeViewer.MergeViewerSide.ANCESTOR;
        }
        return this.getEffectiveSide(result);
    }

    protected IMergeViewer.MergeViewerSide getEffectiveSide(IMergeViewer.MergeViewerSide side) {
        if (side != null && this.getCompareConfiguration().isMirrored()) {
            return side.opposite();
        }
        return side;
    }

    public EObject getMatchView(EObject object, IMergeViewer.MergeViewerSide side) {
        Match match = this.getCompareConfiguration().getComparison().getMatch(object);
        return this.getMatchView(match, side);
    }

    private EObject getMatchView(Match match, IMergeViewer.MergeViewerSide side) {
        EObject result = null;
        switch (side) {
            case LEFT: {
                result = match.getLeft();
                break;
            }
            case RIGHT: {
                result = match.getRight();
                break;
            }
            case ANCESTOR: {
                result = match.getOrigin();
            }
        }
        return result;
    }

    protected abstract Predicate<Diff> goodCandidate();

    protected abstract List<View> getReferenceViews(DiagramDiff var1);

    protected abstract IMergeViewer.MergeViewerSide getTargetSide(Match var1, View var2);

    protected abstract AbstractDecorator createAndRegisterDecorator(Diff var1, View var2, IFigure var3, IMergeViewer.MergeViewerSide var4);

    protected abstract Collection<? extends AbstractDecorator> getDecorators(Diff var1);

    protected abstract class AbstractDecorator {
        protected View fOriginView;
        protected IFigure fOriginFigure;
        protected IFigure fFigure;
        protected DecoratorFigure fDecoratorFigure;
        protected IFigure fLayer;
        protected IMergeViewer.MergeViewerSide fSide;
        protected Diff fDifference;
        protected EditPart fEditPart;

        protected AbstractDecorator() {
        }

        public View getOriginView() {
            return this.fOriginView;
        }

        public void setOriginView(View originView) {
            this.fOriginView = originView;
        }

        public IFigure getOriginFigure() {
            return this.fOriginFigure;
        }

        public void setOriginFigure(IFigure originFigure) {
            this.fOriginFigure = originFigure;
        }

        public IFigure getFigure() {
            return this.fFigure;
        }

        public DecoratorFigure getDecoratorFigure() {
            return this.fDecoratorFigure;
        }

        public void setFigure(IFigure figure) {
            this.fFigure = figure;
        }

        public void setDecoratorFigure(DecoratorFigure figure) {
            this.fDecoratorFigure = figure;
            this.setFigure(figure.getMainFigure());
        }

        public IFigure getLayer() {
            return this.fLayer;
        }

        public void setLayer(IFigure layer) {
            this.fLayer = layer;
        }

        public IMergeViewer.MergeViewerSide getSide() {
            return this.fSide;
        }

        public void setSide(IMergeViewer.MergeViewerSide side) {
            this.fSide = side;
        }

        public Diff getDifference() {
            return this.fDifference;
        }

        public void setDifference(Diff difference) {
            this.fDifference = difference;
        }

        public EditPart getEditPart() {
            return this.fEditPart;
        }

        public void setEditPart(EditPart editPart) {
            this.fEditPart = editPart;
        }
    }
}

