/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.EMFCompareContentMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.TreeContentMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.provider.DelegatingTreeMergeViewerItemContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.provider.MergeViewerItemProviderConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.provider.TreeContentMergeViewerItemLabelProvider;
import org.eclipse.emf.compare.match.impl.NotLoadedFragmentMatch;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.AbstractMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.TreeMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.provider.IMergeViewerItemProviderConfiguration;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeContentMergeViewer
extends EMFCompareContentMergeViewer {
    private static final String BUNDLE_NAME = TreeContentMergeViewer.class.getName();
    private final ComposedAdapterFactory fAdapterFactory;
    private AtomicBoolean fSyncExpandedState;
    private double[] fBasicCenterCurve;

    public TreeContentMergeViewer(int style, ResourceBundle bundle, Composite parent, EMFCompareConfiguration config) {
        super(style, bundle, config);
        LinkedHashMap context = Maps.newLinkedHashMap();
        context.put("comparison", config.getComparison());
        this.fAdapterFactory = new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)EMFCompareRCPPlugin.getDefault().createFilteredAdapterFactoryRegistry((Map)context));
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.fSyncExpandedState = new AtomicBoolean();
        this.buildControl(parent);
        this.setContentProvider((IContentProvider)new TreeContentMergeViewerContentProvider(config));
    }

    protected ComposedAdapterFactory getAdapterFactory() {
        return this.fAdapterFactory;
    }

    public TreeContentMergeViewer(Composite parent, EMFCompareConfiguration config) {
        this(0, ResourceBundle.getBundle(BUNDLE_NAME), parent, config);
    }

    @Override
    protected void handleDispose(DisposeEvent event) {
        this.fAdapterFactory.dispose();
        super.handleDispose(event);
    }

    protected TreeMergeViewer getAncestorMergeViewer() {
        return (TreeMergeViewer)super.getAncestorMergeViewer();
    }

    protected TreeMergeViewer getLeftMergeViewer() {
        return (TreeMergeViewer)super.getLeftMergeViewer();
    }

    protected TreeMergeViewer getRightMergeViewer() {
        return (TreeMergeViewer)super.getRightMergeViewer();
    }

    protected byte[] getContents(boolean left) {
        return null;
    }

    protected AbstractMergeViewer createMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side) {
        TreeMergeViewer mergeTreeViewer = new TreeMergeViewer(parent, side, (ICompareColor.Provider)this, (IEMFCompareConfiguration)this.getCompareConfiguration());
        IContentProvider contentProvider = this.createMergeViewerContentProvider(side);
        mergeTreeViewer.setContentProvider(contentProvider);
        TreeContentMergeViewerItemLabelProvider labelProvider = new TreeContentMergeViewerItemLabelProvider(this.getResourceBundle(), (AdapterFactory)this.getAdapterFactory(), side);
        mergeTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.hookListeners(mergeTreeViewer);
        return mergeTreeViewer;
    }

    protected IContentProvider createMergeViewerContentProvider(IMergeViewer.MergeViewerSide side) {
        Comparison comparison = this.getCompareConfiguration().getComparison();
        if (comparison == null) {
            return new NullTreeContentProvider();
        }
        IMergeViewerItemProviderConfiguration configuration = this.createMergeViewerItemProviderConfiguration(side);
        return new DelegatingTreeMergeViewerItemContentProvider(comparison, configuration);
    }

    protected IMergeViewerItemProviderConfiguration createMergeViewerItemProviderConfiguration(IMergeViewer.MergeViewerSide side) {
        return new MergeViewerItemProviderConfiguration((AdapterFactory)this.getAdapterFactory(), this.getDifferenceGroupProvider(), this.getDifferenceFilterPredicate(), this.getCompareConfiguration().getComparison(), side);
    }

    protected void hookListeners(TreeMergeViewer treeMergeViewer) {
        treeMergeViewer.getStructuredViewer().getTree().addListener(18, (Listener)new ExpandCollapseListener(treeMergeViewer, false));
        treeMergeViewer.getStructuredViewer().getTree().addListener(17, (Listener)new ExpandCollapseListener(treeMergeViewer, true));
        treeMergeViewer.getStructuredViewer().getTree().getVerticalBar().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeContentMergeViewer.this.redrawCenterControl();
            }
        });
        treeMergeViewer.getStructuredViewer().getTree().addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                TreeContentMergeViewer.this.redrawCenterControl();
            }
        });
        treeMergeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeContentMergeViewer.this.redrawCenterControl();
            }
        });
    }

    @Override
    protected void paintCenter(GC g) {
        TreeMergeViewer leftMergeViewer = this.getLeftMergeViewer();
        TreeMergeViewer rightMergeViewer = this.getRightMergeViewer();
        Tree leftTree = leftMergeViewer.getStructuredViewer().getTree();
        Tree rightTree = rightMergeViewer.getStructuredViewer().getTree();
        Rectangle leftClientArea = leftTree.getClientArea();
        Rectangle rightClientArea = rightTree.getClientArea();
        List<TreeItem> leftItems = this.getExpandedTreeItems(leftTree);
        List<TreeItem> rightItems = this.getExpandedTreeItems(rightTree);
        ImmutableSet selection = ImmutableSet.copyOf((Object[])leftTree.getSelection());
        for (TreeItem leftItem : leftItems) {
            TreeItem rightItem;
            boolean selected = Iterables.any((Iterable)selection, (Predicate)Predicates.equalTo((Object)leftItem));
            IMergeViewerItem leftData = (IMergeViewerItem)leftItem.getData();
            Diff leftDiff = leftData.getDiff();
            if (leftDiff == null || MergeViewerUtil.isMarkAsMerged((Diff)leftDiff, (IMergeViewerItem)leftData, (IEMFCompareConfiguration)this.getCompareConfiguration()) || (rightItem = this.findRightTreeItemFromLeftDiff(rightItems, leftDiff, leftData)) == null) continue;
            Color strokeColor = this.getCompareColor().getStrokeColor(leftDiff, this.isThreeWay(), false, selected);
            g.setForeground(strokeColor);
            this.drawCenterLine(g, leftClientArea, rightClientArea, leftItem, rightItem);
        }
    }

    private List<TreeItem> getExpandedTreeItems(Tree tree) {
        return this.getExpandedTreeItems(tree.getItems());
    }

    private List<TreeItem> getExpandedTreeItems(TreeItem[] items) {
        ArrayList ret = Lists.newArrayList();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            ret.add(item);
            if (item.getExpanded()) {
                ret.addAll(this.getExpandedTreeItems(item.getItems()));
            }
            ++n2;
        }
        return ret;
    }

    private void drawCenterLine(GC g, Rectangle leftClientArea, Rectangle rightClientArea, TreeItem leftItem, TreeItem rightItem) {
        Control control = this.getCenterControl();
        Point from = new Point(0, 0);
        Point to = new Point(0, 0);
        Rectangle leftBounds = leftItem.getBounds();
        Rectangle rightBounds = rightItem.getBounds();
        from.y = leftBounds.y + leftBounds.height / 2 - leftClientArea.y;
        if ("gtk".equals(SWT.getPlatform())) {
            --from.y;
        } else if ("win32".equals(SWT.getPlatform())) {
            ++from.y;
        }
        to.x = control.getBounds().width;
        to.y = rightBounds.y + rightBounds.height / 2 - rightClientArea.y;
        if ("gtk".equals(SWT.getPlatform())) {
            --to.y;
        } else if ("win32".equals(SWT.getPlatform())) {
            ++to.y;
        }
        int[] points = this.getCenterCurvePoints(from, to);
        int i = 1;
        while (i < points.length) {
            g.drawLine(from.x + i - 1, points[i - 1], i, points[i]);
            ++i;
        }
    }

    private TreeItem findRightTreeItemFromLeftDiff(List<TreeItem> rightItems, Diff leftDiff, IMergeViewerItem leftData) {
        TreeItem ret = null;
        for (TreeItem rightItem : rightItems) {
            IMergeViewerItem rightData = (IMergeViewerItem)rightItem.getData();
            Diff rightDiff = rightData.getDiff();
            if (leftDiff == rightDiff) {
                return rightItem;
            }
            if (rightData.getAncestor() != leftData.getAncestor() || rightData.getRight() != leftData.getRight() || rightData.getLeft() != leftData.getLeft()) continue;
            ret = rightItem;
        }
        return ret;
    }

    private int[] getCenterCurvePoints(Point from, Point to) {
        int startx = from.x;
        int starty = from.y;
        int endx = to.x;
        int endy = to.y;
        if (this.fBasicCenterCurve == null) {
            this.buildBaseCenterCurve(endx - startx);
        }
        double height = endy - starty;
        height /= 2.0;
        int width = endx - startx;
        int[] points = new int[width];
        int i = 0;
        while (i < width) {
            points[i] = (int)(-height * this.fBasicCenterCurve[i] + height + (double)starty);
            ++i;
        }
        return points;
    }

    private void buildBaseCenterCurve(int w) {
        double width = w;
        this.fBasicCenterCurve = new double[this.getCenterWidth()];
        int i = 0;
        while (i < this.getCenterWidth()) {
            double r = (double)i / width;
            this.fBasicCenterCurve[i] = Math.cos(Math.PI * r);
            ++i;
        }
    }

    private Match getContainerMatch(Comparison comparison, EObject value) {
        if (value != null) {
            EObject eContainer = value.eContainer();
            return comparison.getMatch(eContainer);
        }
        return null;
    }

    protected final class ExpandCollapseListener
    implements Listener {
        private final TreeMergeViewer mergeTreeViewer;
        private boolean expanded;

        public ExpandCollapseListener(TreeMergeViewer mergeTreeViewer, boolean expanded) {
            this.mergeTreeViewer = mergeTreeViewer;
            this.expanded = expanded;
        }

        public void handleEvent(Event e) {
            Match match;
            Object data = e.item.getData();
            ArrayList toBeExpanded = Lists.newArrayList();
            toBeExpanded.add(data);
            Object parent = TreeContentMergeViewer.this.getLeftMergeViewer() == this.mergeTreeViewer ? ((IMergeViewerItem)data).getLeft() : (TreeContentMergeViewer.this.getRightMergeViewer() == this.mergeTreeViewer ? ((IMergeViewerItem)data).getRight() : ((IMergeViewerItem)data).getAncestor());
            Comparison comparison = TreeContentMergeViewer.this.getCompareConfiguration().getComparison();
            if (parent instanceof NotLoadedFragmentMatch) {
                MergeViewerItem.Container left = new MergeViewerItem.Container(comparison, null, (Match)parent, IMergeViewer.MergeViewerSide.LEFT, (AdapterFactory)TreeContentMergeViewer.this.getAdapterFactory());
                MergeViewerItem.Container right = new MergeViewerItem.Container(comparison, null, (Match)parent, IMergeViewer.MergeViewerSide.RIGHT, (AdapterFactory)TreeContentMergeViewer.this.getAdapterFactory());
                toBeExpanded.add(left);
                toBeExpanded.add(right);
            } else if (parent instanceof EObject && (match = comparison.getMatch((EObject)parent)) != null) {
                for (Diff referenceChange : Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ReferenceChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE)))) {
                    MergeViewerItem.Container container;
                    Match matchOfValue = comparison.getMatch(((ReferenceChange)referenceChange).getValue());
                    if (matchOfValue == null) continue;
                    Match leftContainerMatch = TreeContentMergeViewer.this.getContainerMatch(comparison, matchOfValue.getLeft());
                    Match rightContainerMatch = TreeContentMergeViewer.this.getContainerMatch(comparison, matchOfValue.getRight());
                    Match originContainerMatch = TreeContentMergeViewer.this.getContainerMatch(comparison, matchOfValue.getOrigin());
                    if (leftContainerMatch != match && rightContainerMatch != match && originContainerMatch != match) continue;
                    if (leftContainerMatch != null && leftContainerMatch != match) {
                        container = new MergeViewerItem.Container(comparison, null, leftContainerMatch, IMergeViewer.MergeViewerSide.LEFT, (AdapterFactory)TreeContentMergeViewer.this.getAdapterFactory());
                        toBeExpanded.add(container);
                    }
                    if (rightContainerMatch != null && rightContainerMatch != match) {
                        container = new MergeViewerItem.Container(comparison, null, rightContainerMatch, IMergeViewer.MergeViewerSide.RIGHT, (AdapterFactory)TreeContentMergeViewer.this.getAdapterFactory());
                        toBeExpanded.add(container);
                    }
                    if (originContainerMatch == null || originContainerMatch == match) continue;
                    container = new MergeViewerItem.Container(comparison, null, originContainerMatch, IMergeViewer.MergeViewerSide.ANCESTOR, (AdapterFactory)TreeContentMergeViewer.this.getAdapterFactory());
                    toBeExpanded.add(container);
                }
            }
            try {
                if (TreeContentMergeViewer.this.fSyncExpandedState.compareAndSet(false, true)) {
                    for (Object object : toBeExpanded) {
                        TreeContentMergeViewer.this.getLeftMergeViewer().setExpandedState(object, this.expanded);
                        TreeContentMergeViewer.this.getRightMergeViewer().setExpandedState(object, this.expanded);
                        TreeContentMergeViewer.this.getAncestorMergeViewer().setExpandedState(object, this.expanded);
                    }
                }
            }
            finally {
                TreeContentMergeViewer.this.getCenterControl().redraw();
                TreeContentMergeViewer.this.fSyncExpandedState.set(false);
            }
        }
    }

    private class NullTreeContentProvider
    implements ITreeContentProvider {
        private NullTreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

