/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.utils;

import com.google.common.collect.Iterables;
import java.io.PrintStream;
import java.util.Arrays;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;

public final class EMFComparePrettyPrinter {
    private static final int COLUMN_LENGTH = 40;

    private EMFComparePrettyPrinter() {
    }

    public static void printComparison(Comparison comparison, PrintStream stream) {
        for (MatchResource res : comparison.getMatchedResources()) {
            stream.println("Matched resources :");
            stream.println("Left = " + res.getLeftURI());
            stream.println("Right = " + res.getRightURI());
            stream.println("origin = " + res.getOriginURI());
        }
        stream.println();
        EMFComparePrettyPrinter.printMatch(comparison, stream);
        stream.println();
        EMFComparePrettyPrinter.printDifferences(comparison, stream);
    }

    public static void printMatch(Comparison comparison, PrintStream stream) {
        stream.println("+----------------------------------------+----------------------------------------+----------------------------------------+");
        stream.println(String.valueOf('|') + EMFComparePrettyPrinter.formatHeader("Left") + '|' + EMFComparePrettyPrinter.formatHeader("Right") + '|' + EMFComparePrettyPrinter.formatHeader("Origin") + '|');
        stream.println("+----------------------------------------+----------------------------------------+----------------------------------------+");
        for (Match match : comparison.getMatches()) {
            EMFComparePrettyPrinter.printMatch(match, stream);
        }
        stream.println("+----------------------------------------+----------------------------------------+----------------------------------------+");
    }

    public static void printDifferences(Comparison comparison, PrintStream stream) {
        Iterable refChanges = Iterables.filter(comparison.getDifferences(), ReferenceChange.class);
        stream.println("REFERENCE CHANGES");
        for (Diff diff : refChanges) {
            EMFComparePrettyPrinter.printDiff(diff, stream);
        }
        stream.println();
        stream.println("ATTRIBUTE CHANGES");
        Iterable attChanges = Iterables.filter(comparison.getDifferences(), AttributeChange.class);
        for (Diff diff : attChanges) {
            EMFComparePrettyPrinter.printDiff(diff, stream);
        }
        stream.println();
        stream.println("CONFLICTS");
        for (Conflict conflict : comparison.getConflicts()) {
            EMFComparePrettyPrinter.printConflict(conflict, stream);
        }
    }

    private static void printConflict(Conflict conflict, PrintStream stream) {
        stream.println((Object)((Object)conflict.getKind()) + " conflict:");
        Iterable refChanges = Iterables.filter(conflict.getDifferences(), ReferenceChange.class);
        for (Diff diff : refChanges) {
            stream.print("\t");
            EMFComparePrettyPrinter.printDiff(diff, stream);
        }
        Iterable attChanges = Iterables.filter(conflict.getDifferences(), AttributeChange.class);
        for (Diff diff : attChanges) {
            stream.print("\t");
            EMFComparePrettyPrinter.printDiff(diff, stream);
        }
    }

    private static void printDiff(Diff diff, PrintStream stream) {
        if (diff instanceof ReferenceChange) {
            ReferenceChange refChange = (ReferenceChange)diff;
            String valueName = refChange.getValue() instanceof ENamedElement ? ((ENamedElement)refChange.getValue()).getName() : refChange.getValue().toString();
            String change = "";
            if (diff.getSource() == DifferenceSource.RIGHT) {
                change = "remotely ";
            }
            change = diff.getKind() == DifferenceKind.ADD ? String.valueOf(change) + "added to" : (diff.getKind() == DifferenceKind.DELETE ? String.valueOf(change) + "deleted from" : (diff.getKind() == DifferenceKind.CHANGE ? String.valueOf(change) + "changed from" : String.valueOf(change) + "moved from"));
            String objectName = refChange.getMatch().getLeft() instanceof ENamedElement ? ((ENamedElement)refChange.getMatch().getLeft()).getName() : (refChange.getMatch().getRight() instanceof ENamedElement ? ((ENamedElement)refChange.getMatch().getRight()).getName() : (refChange.getMatch().getOrigin() instanceof ENamedElement ? ((ENamedElement)refChange.getMatch().getOrigin()).getName() : ""));
            stream.println("value " + valueName + " has been " + change + " reference " + refChange.getReference().getName() + " of object " + objectName);
        } else if (diff instanceof AttributeChange) {
            AttributeChange attChange = (AttributeChange)diff;
            String valueName = "null";
            if (attChange.getValue() != null) {
                valueName = attChange.getValue().toString();
            }
            String change = "";
            if (diff.getSource() == DifferenceSource.RIGHT) {
                change = "remotely ";
            }
            change = diff.getKind() == DifferenceKind.ADD ? String.valueOf(change) + "added to" : (diff.getKind() == DifferenceKind.DELETE ? String.valueOf(change) + "deleted from" : (diff.getKind() == DifferenceKind.CHANGE ? String.valueOf(change) + "changed from" : String.valueOf(change) + "moved from"));
            String objectName = attChange.getMatch().getLeft() instanceof ENamedElement ? ((ENamedElement)attChange.getMatch().getLeft()).getName() : (attChange.getMatch().getRight() instanceof ENamedElement ? ((ENamedElement)attChange.getMatch().getRight()).getName() : (attChange.getMatch().getOrigin() instanceof ENamedElement ? ((ENamedElement)attChange.getMatch().getOrigin()).getName() : ""));
            stream.println("value " + valueName + " has been " + change + " attribute " + attChange.getAttribute().getName() + " of object " + objectName);
        }
    }

    private static void printMatch(Match match, PrintStream stream) {
        String leftName = null;
        String rightName = null;
        String originName = null;
        EObject left = match.getLeft();
        EObject right = match.getRight();
        EObject origin = match.getOrigin();
        if (EMFComparePrettyPrinter.isNullOrNamedElement(left) && EMFComparePrettyPrinter.isNullOrNamedElement(right) && EMFComparePrettyPrinter.isNullOrNamedElement(origin)) {
            Match currentMatch;
            int level;
            if (left != null && ((ENamedElement)left).getName() != null) {
                leftName = EMFComparePrettyPrinter.formatName((ENamedElement)left);
            } else {
                level = 0;
                currentMatch = match;
                while (currentMatch instanceof Match && currentMatch.getLeft() == null) {
                    currentMatch = currentMatch.eContainer();
                }
                while (currentMatch instanceof Match && currentMatch.getLeft() != null) {
                    ++level;
                    currentMatch = currentMatch.eContainer();
                }
                leftName = EMFComparePrettyPrinter.getEmptyLine(level);
            }
            if (right != null && ((ENamedElement)right).getName() != null) {
                rightName = EMFComparePrettyPrinter.formatName((ENamedElement)right);
            } else {
                level = 0;
                currentMatch = match;
                while (currentMatch instanceof Match && currentMatch.getRight() == null) {
                    currentMatch = currentMatch.eContainer();
                }
                while (currentMatch instanceof Match && currentMatch.getRight() != null) {
                    ++level;
                    currentMatch = currentMatch.eContainer();
                }
                rightName = EMFComparePrettyPrinter.getEmptyLine(level);
            }
            if (origin != null && ((ENamedElement)origin).getName() != null) {
                originName = EMFComparePrettyPrinter.formatName((ENamedElement)origin);
            } else {
                level = 0;
                currentMatch = match;
                while (currentMatch instanceof Match && currentMatch.getOrigin() == null) {
                    currentMatch = currentMatch.eContainer();
                }
                while (currentMatch instanceof Match && currentMatch.getOrigin() != null) {
                    ++level;
                    currentMatch = currentMatch.eContainer();
                }
                originName = EMFComparePrettyPrinter.getEmptyLine(level);
            }
            stream.println(String.valueOf('|') + leftName + '|' + rightName + '|' + originName + '|');
        }
        for (Match submatch : match.getSubmatches()) {
            EMFComparePrettyPrinter.printMatch(submatch, stream);
        }
    }

    private static String formatHeader(String header) {
        int padding = (40 - header.length()) / 2;
        char[] charsBefore = new char[padding];
        int i = 0;
        while (i < charsBefore.length) {
            charsBefore[i] = 32;
            ++i;
        }
        if ((header.length() & 1) == 1) {
            ++padding;
        }
        char[] charsAfter = new char[padding];
        int i2 = 0;
        while (i2 < charsAfter.length) {
            charsAfter[i2] = 32;
            ++i2;
        }
        return String.valueOf(String.valueOf(charsBefore)) + header + String.valueOf(charsAfter);
    }

    private static String formatName(ENamedElement element) {
        String name = element.getName();
        int level = 0;
        ENamedElement current = element;
        while (current.eContainer() != null) {
            ++level;
            current = current.eContainer();
        }
        char[] charsBefore = new char[1 + level * 2];
        charsBefore[0] = 32;
        if (level > 0) {
            int i = 1;
            while (i < charsBefore.length - 2) {
                charsBefore[i] = 124;
                charsBefore[i + 1] = 32;
                i += 2;
            }
            charsBefore[charsBefore.length - 2] = 124;
            charsBefore[charsBefore.length - 1] = 45;
        }
        int missingChars = 40 - name.length() - charsBefore.length;
        char[] spacesAfter = new char[Math.max(0, missingChars)];
        Arrays.fill(spacesAfter, ' ');
        return String.valueOf(String.valueOf(charsBefore)) + name + String.valueOf(spacesAfter);
    }

    private static String getEmptyLine(int level) {
        char[] charsBefore = new char[1 + level * 2];
        charsBefore[0] = 32;
        int i = 1;
        while (i < charsBefore.length) {
            charsBefore[i] = 124;
            charsBefore[i + 1] = 32;
            i += 2;
        }
        int missingChars = 40 - charsBefore.length;
        char[] spacesAfter = new char[Math.max(0, missingChars)];
        Arrays.fill(spacesAfter, ' ');
        return String.valueOf(String.valueOf(charsBefore)) + String.valueOf(spacesAfter);
    }

    private static boolean isNullOrNamedElement(Object object) {
        return object == null || object instanceof ENamedElement;
    }
}

