/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;
import org.eclipse.emf.compare.rcp.internal.extension.impl.ItemUtil;
import org.eclipse.emf.compare.rcp.internal.tracer.TracingConstant;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.osgi.service.prefs.Preferences;

public class DifferenceGroupManager {
    private static final Predicate<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> TWO_WAY_FILTER = new Predicate<IItemDescriptor<IDifferenceGroupProvider.Descriptor>>(){

        public boolean apply(IItemDescriptor<IDifferenceGroupProvider.Descriptor> descriptor) {
            if (descriptor == null) {
                return false;
            }
            IDifferenceGroupProvider.ComparisonType type = ((IDifferenceGroupProvider.Descriptor)descriptor.getItem()).getType();
            return type == IDifferenceGroupProvider.ComparisonType.BOTH || type == IDifferenceGroupProvider.ComparisonType.TWO_WAY;
        }
    };
    private static final Predicate<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> THREE_WAY_FILTER = new Predicate<IItemDescriptor<IDifferenceGroupProvider.Descriptor>>(){

        public boolean apply(IItemDescriptor<IDifferenceGroupProvider.Descriptor> descriptor) {
            if (descriptor == null) {
                return false;
            }
            IDifferenceGroupProvider.ComparisonType type = ((IDifferenceGroupProvider.Descriptor)descriptor.getItem()).getType();
            return type == IDifferenceGroupProvider.ComparisonType.BOTH || type == IDifferenceGroupProvider.ComparisonType.THREE_WAY;
        }
    };
    private static final String TWO_WAY_GROUP_RANKING = "org.eclipse.emf.compare.rcp.ui.groups.2way.ranking";
    private static final String THREE_WAY_GROUP_RANKING = "org.eclipse.emf.compare.rcp.ui.groups.3way.ranking";
    private final Preferences preferences;
    private final IItemRegistry<IDifferenceGroupProvider.Descriptor> registry;

    public DifferenceGroupManager(Preferences preferences, IItemRegistry<IDifferenceGroupProvider.Descriptor> registry) {
        this.preferences = preferences;
        this.registry = registry;
    }

    private List<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> getCurrent(String preferenceKey, List<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> defaultOrder) {
        return this.getOrderedItems(defaultOrder, this.registry, preferenceKey);
    }

    public List<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> getCurrentGroupRanking(boolean isThreeWay) {
        return this.getCurrent(this.getGroupPreferenceKey(isThreeWay), this.getDefaultRankingConfiguration(isThreeWay));
    }

    public List<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> getDefaultRankingConfiguration(boolean isThreeWay) {
        Iterable groups = isThreeWay ? Iterables.filter((Iterable)this.registry.getItemDescriptors(), THREE_WAY_FILTER) : Iterables.filter((Iterable)this.registry.getItemDescriptors(), TWO_WAY_FILTER);
        ArrayList result = Lists.newArrayList((Iterable)groups);
        Collections.sort(result);
        return result;
    }

    private String getGroupPreferenceKey(boolean isThreeWay) {
        if (isThreeWay) {
            return THREE_WAY_GROUP_RANKING;
        }
        return TWO_WAY_GROUP_RANKING;
    }

    private <T> List<IItemDescriptor<T>> getOrderedItems(List<IItemDescriptor<T>> orderedDefaultDescriptor, IItemRegistry<T> descriptorRegistry, String orderedItemPreferenceKey) {
        List<IItemDescriptor<T>> itemsDescriptor = ItemUtil.getItemsDescriptor(descriptorRegistry, (String)orderedItemPreferenceKey, (Preferences)this.preferences);
        if (itemsDescriptor == null) {
            itemsDescriptor = orderedDefaultDescriptor;
        } else {
            LinkedHashSet descriptorFromPrefSet = Sets.newLinkedHashSet(itemsDescriptor);
            LinkedHashSet defaultDescriptorSet = Sets.newLinkedHashSet(orderedDefaultDescriptor);
            Sets.SetView descriptorToRemove = Sets.difference((Set)descriptorFromPrefSet, (Set)defaultDescriptorSet);
            Iterables.removeAll(itemsDescriptor, (Collection)descriptorToRemove);
            Sets.SetView descriptorToAdd = Sets.difference((Set)defaultDescriptorSet, (Set)descriptorFromPrefSet);
            Iterables.addAll(itemsDescriptor, (Iterable)descriptorToAdd);
        }
        return itemsDescriptor;
    }

    public void setCurrentGroupRanking(List<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> descriptors, boolean isThreeWay) {
        this.storeInPreferences(this.getGroupPreferenceKey(isThreeWay), descriptors, this.getDefaultRankingConfiguration(isThreeWay));
        if (TracingConstant.CONFIGURATION_TRACING_ACTIVATED) {
            StringBuilder builder = new StringBuilder();
            builder.append("Preference ").append(this.getGroupPreferenceKey(isThreeWay)).append(":\n");
            String preferenceValue = this.preferences.get(this.getGroupPreferenceKey(isThreeWay), "");
            String[] groups = preferenceValue.split(";");
            int rank = 0;
            while (rank < groups.length) {
                builder.append(rank).append(". ").append(groups[rank]).append("\n");
                ++rank;
            }
            builder.append("\n\n");
            EMFCompareRCPUIPlugin.getDefault().log(1, builder.toString());
        }
    }

    private void storeInPreferences(String preferenceKey, List<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> currentValue, List<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> defaultConf) {
        if (currentValue != null && !currentValue.equals(defaultConf)) {
            Iterable currentIDs = Iterables.transform(currentValue, (Function)new Function<IItemDescriptor<IDifferenceGroupProvider.Descriptor>, String>(){

                public String apply(IItemDescriptor<IDifferenceGroupProvider.Descriptor> arg0) {
                    return arg0.getID();
                }
            });
            String preferenceValue = Joiner.on((String)";").join(currentIDs);
            this.preferences.put(preferenceKey, preferenceValue);
        } else {
            this.preferences.remove(preferenceKey);
        }
    }
}

