/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.util.CompareSwitch;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatchUtil {
    private MatchUtil() {
    }

    public static EObject getOriginObject(Comparison comparison, EObject object) {
        EObject result = null;
        Match match = comparison.getMatch(object);
        if (match != null) {
            result = comparison.isThreeWay() ? match.getOrigin() : (object == match.getLeft() ? match.getRight() : match.getLeft());
        }
        return result;
    }

    public static boolean matchingIndices(Match match, EStructuralFeature feature, Object value1, Object value2) {
        int rightIndex;
        int leftIndex;
        boolean matching = false;
        matching = feature.isMany() ? (leftIndex = MatchUtil.computeIndex(match, feature, value1, DifferenceSource.LEFT)) == (rightIndex = MatchUtil.computeIndex(match, feature, value2, DifferenceSource.RIGHT)) : true;
        return matching;
    }

    public static int computeIndex(Match match, EStructuralFeature feature, Object value, DifferenceSource side) {
        Comparison comparison = match.getComparison();
        int result = -1;
        List sideValues = (List)ReferenceUtil.safeEGet(MatchUtil.getMatchedObject(match, side), feature);
        int i = 0;
        while (i < sideValues.size()) {
            Object sideObject = sideValues.get(i);
            if (comparison.getEqualityHelper().matchingValues(sideObject, value)) break;
            if (!(MatchUtil.hasDiff(match, feature, sideObject) && match.getOrigin() != null || MatchUtil.hasDeleteDiff(match, feature, sideObject))) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public static boolean hasDeleteDiff(Match match, EStructuralFeature feature, Object value) {
        Match valueMatch;
        Comparison comparison = match.getComparison();
        Object expectedValue = value instanceof EObject && comparison.isThreeWay() ? ((valueMatch = comparison.getMatch((EObject)value)) != null ? valueMatch.getOrigin() : value) : value;
        return Iterables.any(match.getDifferences(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.onFeature(feature.getName()), EMFComparePredicates.valueIs(expectedValue), EMFComparePredicates.ofKind(DifferenceKind.DELETE)}));
    }

    public static boolean hasDiff(Match match, EStructuralFeature feature, Object value) {
        return Iterables.any(match.getDifferences(), (Predicate)Predicates.and(EMFComparePredicates.onFeature(feature.getName()), EMFComparePredicates.valueIs(value)));
    }

    public static EObject getOriginValue(Comparison comparison, ReferenceChange difference) {
        Object originValue;
        EObject originContainer;
        EReference reference = difference.getReference();
        if (!reference.isContainment() && !reference.isMany() && difference.getKind().equals((Object)DifferenceKind.CHANGE) && (originContainer = MatchUtil.getOriginContainer(comparison, difference)) != null && (originValue = ReferenceUtil.safeEGet(originContainer, (EStructuralFeature)reference)) instanceof EObject) {
            return (EObject)originValue;
        }
        return null;
    }

    public static EObject getOriginContainer(Comparison comparison, Diff difference) {
        EObject diffContainer = comparison.isThreeWay() ? difference.getMatch().getOrigin() : (MatchUtil.getContainer(comparison, difference) == difference.getMatch().getLeft() ? difference.getMatch().getRight() : difference.getMatch().getLeft());
        return diffContainer;
    }

    public static EObject getContainer(Comparison comparison, Diff difference) {
        EObject result = null;
        Match match = difference.getMatch();
        DifferenceSource source = difference.getSource();
        DifferenceKind kind = difference.getKind();
        switch (kind) {
            case DELETE: {
                if (comparison.isThreeWay()) {
                    result = match.getOrigin();
                    break;
                }
                result = match.getRight();
                break;
            }
            case ADD: 
            case MOVE: {
                if (source == DifferenceSource.LEFT) {
                    result = match.getLeft();
                    break;
                }
                result = match.getRight();
                break;
            }
            case CHANGE: {
                Object value = MatchUtil.getValue(difference);
                EStructuralFeature feature = MatchUtil.getStructuralFeature(difference);
                if (value == null || feature == null) {
                    throw new IllegalArgumentException();
                }
                if (source == DifferenceSource.LEFT) {
                    if (MatchUtil.featureContains(match.getLeft(), feature, value)) {
                        result = match.getLeft();
                        break;
                    }
                    if (comparison.isThreeWay()) {
                        result = match.getOrigin();
                        break;
                    }
                    result = match.getRight();
                    break;
                }
                result = MatchUtil.featureContains(match.getRight(), feature, value) ? match.getRight() : (comparison.isThreeWay() ? match.getOrigin() : match.getLeft());
            }
        }
        return result;
    }

    public static boolean featureContains(EObject eObject, EStructuralFeature feature, Object value) {
        boolean contains = false;
        URI valueURI = null;
        for (Object element : ReferenceUtil.getAsList(eObject, feature)) {
            if (element == value) {
                contains = true;
                break;
            }
            if (element != null && element.equals(value)) {
                contains = true;
                break;
            }
            if (!(element instanceof EObject) || !((EObject)element).eIsProxy()) continue;
            if (valueURI == null && value instanceof EObject) {
                valueURI = EcoreUtil.getURI((EObject)((EObject)value));
            }
            if (!EcoreUtil.getURI((EObject)((EObject)element)).equals(valueURI)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static Object getValue(Diff input) {
        CompareSwitch<Object> customSwitch = new CompareSwitch<Object>(){

            @Override
            public Object caseAttributeChange(AttributeChange object) {
                return object.getValue();
            }

            @Override
            public Object caseReferenceChange(ReferenceChange object) {
                return object.getValue();
            }
        };
        return customSwitch.doSwitch(input);
    }

    public static EStructuralFeature getStructuralFeature(Diff input) {
        CompareSwitch<EStructuralFeature> customSwitch = new CompareSwitch<EStructuralFeature>(){

            @Override
            public EStructuralFeature caseAttributeChange(AttributeChange object) {
                return object.getAttribute();
            }

            @Override
            public EStructuralFeature caseReferenceChange(ReferenceChange object) {
                return object.getReference();
            }
        };
        return (EStructuralFeature)customSwitch.doSwitch(input);
    }

    public static EObject getMatchedObject(Match m, DifferenceSource side) {
        if (side == null) {
            return m.getOrigin();
        }
        switch (side) {
            case LEFT: {
                return m.getLeft();
            }
            case RIGHT: {
                return m.getRight();
            }
        }
        throw new IllegalArgumentException("Value " + (Object)((Object)side) + " is not a valid DifferenceSource.");
    }

    public static Iterable<Diff> findAddOrDeleteContainmentDiffs(Match match) {
        EObject container = match.eContainer();
        if (container instanceof Match) {
            return Iterables.filter(((Match)container).getDifferences(), (Predicate)Predicates.and(EMFComparePredicates.CONTAINMENT_REFERENCE_CHANGE, EMFComparePredicates.ofKind(DifferenceKind.ADD, DifferenceKind.DELETE)));
        }
        return null;
    }
}

