/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.utils;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.compare.ide.EMFCompareIDEPlugin;
import org.eclipse.emf.compare.ide.internal.utils.URIStorage;
import org.eclipse.emf.compare.ide.utils.IStoragePathProvider;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceUtil {
    private static final String[] MODEL_CONTENT_TYPES = new String[]{"org.eclipse.emf.compare.content.type", "org.eclipse.emf.ecore", "org.eclipse.emf.ecore.xmi"};
    private static final Function<IStorage, URI> AS_URI = new Function<IStorage, URI>(){

        public URI apply(IStorage input) {
            if (input != null) {
                return ResourceUtil.createURIFor(input);
            }
            return null;
        }
    };

    private ResourceUtil() {
    }

    public static Function<IStorage, URI> asURI() {
        return AS_URI;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Resource loadResource(IStorage storage, ResourceSet resourceSet, Map<?, ?> options) {
        URI uri = ResourceUtil.createURIFor(storage);
        InputStream stream = null;
        Resource resource = null;
        try {
            resource = resourceSet.createResource(uri);
            stream = storage.getContents();
            resource.load(stream, options);
        }
        catch (IOException iOException) {
            if (stream == null) return resource;
            try {
                stream.close();
                return resource;
            }
            catch (IOException iOException2) {}
            return resource;
        }
        catch (CoreException coreException) {
            if (stream == null) return resource;
            try {
                stream.close();
                return resource;
            }
            catch (IOException iOException) {}
            return resource;
        }
        catch (WrappedException wrappedException) {
            if (stream == null) return resource;
            {
                catch (Throwable throwable) {
                    if (stream == null) throw throwable;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                stream.close();
                return resource;
            }
            catch (IOException iOException) {}
            return resource;
        }
        if (stream == null) return resource;
        try {
            stream.close();
            return resource;
        }
        catch (IOException iOException) {}
        return resource;
    }

    /*
     * Loose catch block
     */
    public static boolean binaryIdentical(IStorage left, IStorage right) {
        block9: {
            boolean bl;
            BufferedInputStream leftStream = null;
            BufferedInputStream rightStream = null;
            try {
                int readLeft;
                byte[] buffer = new byte[8192];
                leftStream = new BufferedInputStream(left.getContents(), 8192);
                rightStream = new BufferedInputStream(right.getContents(), 8192);
                boolean identical = true;
                do {
                    if ((readLeft = leftStream.read(buffer, 0, buffer.length)) == -1) {
                        identical = rightStream.read() == -1;
                        break;
                    }
                    if (ResourceUtil.verifyNextBytes(rightStream, buffer, 0, readLeft)) continue;
                    identical = false;
                    break;
                } while (readLeft > 0);
                bl = identical;
                Closeables.closeQuietly((Closeable)leftStream);
            }
            catch (CoreException e) {
                ResourceUtil.logError((Exception)((Object)e));
                break block9;
            }
            catch (IOException e2) {
                ResourceUtil.logError(e2);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Closeables.closeQuietly(leftStream);
                Closeables.closeQuietly(rightStream);
            }
            Closeables.closeQuietly((Closeable)rightStream);
            return bl;
        }
        return false;
    }

    /*
     * Loose catch block
     */
    public static boolean binaryIdentical(IStorage left, IStorage right, IStorage origin) {
        block9: {
            boolean bl;
            BufferedInputStream leftStream = null;
            BufferedInputStream rightStream = null;
            BufferedInputStream originStream = null;
            try {
                int readLeft;
                byte[] buffer = new byte[8192];
                leftStream = new BufferedInputStream(left.getContents(), 8192);
                rightStream = new BufferedInputStream(right.getContents(), 8192);
                originStream = new BufferedInputStream(origin.getContents(), 8192);
                boolean identical = true;
                do {
                    if ((readLeft = leftStream.read(buffer, 0, buffer.length)) == -1) {
                        identical = rightStream.read() == -1 && originStream.read() == -1;
                        break;
                    }
                    if (ResourceUtil.verifyNextBytes(rightStream, buffer, 0, readLeft) && ResourceUtil.verifyNextBytes(originStream, buffer, 0, readLeft)) continue;
                    identical = false;
                    break;
                } while (readLeft > 0);
                bl = identical;
                Closeables.closeQuietly((Closeable)leftStream);
            }
            catch (CoreException e) {
                ResourceUtil.logError((Exception)((Object)e));
                break block9;
            }
            catch (IOException e2) {
                ResourceUtil.logError(e2);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Closeables.closeQuietly(leftStream);
                Closeables.closeQuietly(rightStream);
                Closeables.closeQuietly(originStream);
            }
            Closeables.closeQuietly((Closeable)rightStream);
            Closeables.closeQuietly((Closeable)originStream);
            return bl;
        }
        return false;
    }

    private static boolean verifyNextBytes(InputStream stream, byte[] bytes, int offset, int length) throws IOException {
        int done = 0;
        byte[] buffer = new byte[offset + length];
        while (done < length) {
            int read = stream.read(buffer, offset + done, length - done);
            if (read == -1 || !ResourceUtil.equalArrays(offset + done, read, bytes, buffer)) {
                return false;
            }
            done += read;
        }
        return true;
    }

    public static URI createURIFor(IFile file) {
        return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
    }

    public static URI createURIFor(IStorage storage) {
        URI shortcut = null;
        if (storage instanceof IFile) {
            shortcut = ResourceUtil.createURIFor((IFile)storage);
        } else if (storage instanceof URIStorage) {
            shortcut = ((URIStorage)storage).getURI();
        }
        if (shortcut != null) {
            return shortcut;
        }
        String path = ResourceUtil.getFixedPath(storage).toString();
        URI uri = path.startsWith("platform:/plugin/") ? URI.createURI((String)path) : (path.startsWith("file:/") ? URI.createURI((String)path) : (ResourceUtil.hasStoragePathProvider(storage) ? URI.createPlatformResourceURI((String)path, (boolean)true) : URI.createURI((String)path, (boolean)true)));
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path iPath = new Path(path);
        if (root != null && iPath.segmentCount() >= 2 && root.getFile((IPath)iPath).exists()) {
            uri = URI.createPlatformResourceURI((String)path, (boolean)true);
        }
        return uri;
    }

    public static IResource getResourceFromURI(URI uri) {
        IFile targetFile;
        if (uri.isPlatform()) {
            Path platformString = new Path(uri.trimFragment().toPlatformString(true));
            targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)platformString);
        } else {
            targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.trimFragment().toString()));
        }
        return targetFile;
    }

    public static IPath getFixedPath(IStorage storage) {
        Object adapter = Platform.getAdapterManager().loadAdapter((Object)storage, IStoragePathProvider.class.getName());
        if (adapter instanceof IStoragePathProvider) {
            return ((IStoragePathProvider)adapter).computeFixedPath(storage);
        }
        return storage.getFullPath();
    }

    private static boolean hasStoragePathProvider(IStorage storage) {
        Object adapter = Platform.getAdapterManager().loadAdapter((Object)storage, IStoragePathProvider.class.getName());
        boolean hasProvider = adapter instanceof IStoragePathProvider;
        return hasProvider;
    }

    public static void saveAllResources(ResourceSet resourceSet, Map<?, ?> options) {
        EList resources = resourceSet.getResources();
        for (Resource resource : resources) {
            ResourceUtil.saveResource(resource, options);
        }
    }

    public static void saveResource(Resource resource, Map<?, ?> options) {
        if (ResourceUtil.supportsOutput(resource)) {
            try {
                resource.save(options);
            }
            catch (IOException e) {
                ResourceUtil.logError(e);
            }
        }
    }

    public static boolean hasContentType(String contentTypeId, List<IContentType> contentTypes) {
        IContentTypeManager ctManager = Platform.getContentTypeManager();
        IContentType expected = ctManager.getContentType(contentTypeId);
        if (expected == null) {
            return false;
        }
        boolean hasContentType = false;
        int i = 0;
        while (i < contentTypes.size() && !hasContentType) {
            if (contentTypes.get(i).isKindOf(expected)) {
                hasContentType = true;
            }
            ++i;
        }
        return hasContentType;
    }

    public static boolean hasModelType(IFile file) {
        boolean isModel = false;
        IContentTypeManager ctManager = Platform.getContentTypeManager();
        ArrayList fileNameTypes = Lists.newArrayList((Object[])ctManager.findContentTypesFor(file.getName()));
        int i = 0;
        while (i < MODEL_CONTENT_TYPES.length && !isModel) {
            isModel = ResourceUtil.hasContentType(MODEL_CONTENT_TYPES[i], fileNameTypes);
            ++i;
        }
        if (isModel) {
            return true;
        }
        ArrayList contentTypes = Lists.newArrayList((Object[])ResourceUtil.getContentTypes(file));
        contentTypes.removeAll(fileNameTypes);
        int i2 = 0;
        while (i2 < MODEL_CONTENT_TYPES.length && !isModel) {
            isModel = ResourceUtil.hasContentType(MODEL_CONTENT_TYPES[i2], contentTypes);
            ++i2;
        }
        return isModel;
    }

    public static IContentType[] getContentTypes(IFile file) {
        IContentTypeManager ctManager = Platform.getContentTypeManager();
        InputStream resourceContent = null;
        IContentType[] contentTypes = new IContentType[]{};
        try {
            try {
                resourceContent = file.getContents();
                contentTypes = ctManager.findContentTypesFor(resourceContent, file.getName());
            }
            catch (CoreException coreException) {
                ctManager.findContentTypesFor(file.getName());
                Closeables.closeQuietly((Closeable)resourceContent);
            }
            catch (IOException iOException) {
                ctManager.findContentTypesFor(file.getName());
                Closeables.closeQuietly((Closeable)resourceContent);
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)resourceContent);
        }
        return contentTypes;
    }

    private static boolean supportsOutput(Resource resource) {
        URI uri = resource.getURI();
        return uri.isPlatformResource() || uri.isRelative() || uri.isFile();
    }

    private static boolean equalArrays(int offset, int length, byte[] array1, byte[] array2) {
        boolean result = true;
        if (array1 == array2) {
            result = true;
        } else if (array1 == null || array2 == null) {
            result = false;
        } else {
            int i = offset;
            while (result && i < offset + length) {
                result = array1[i] == array2[i];
                ++i;
            }
        }
        return result;
    }

    private static void logError(Exception e) {
        Status status = new Status(4, "org.eclipse.emf.compare.ide", e.getMessage(), (Throwable)e);
        EMFCompareIDEPlugin.getDefault().getLog().log((IStatus)status);
    }
}

