/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.configuration.ui.match;

import com.google.common.base.Throwables;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.emf.compare.rcp.internal.match.DefaultRCPMatchEngineFactory;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ui.AbstractConfigurationUI;
import org.eclipse.emf.compare.utils.UseIdentifiers;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.prefs.Preferences;

public class DefaultMatchEngineConfiguratorUI
extends AbstractConfigurationUI {
    private static final int COMPOSITE_VERTICAL_SPACING = 10;
    private static final int COMPOSITE_MARGIN = 5;
    private Button whenAvailableButton;
    private Button neverButton;
    private Button onlyButton;
    private DataHolder dataHolder;

    public DefaultMatchEngineConfiguratorUI(Composite parent, int style, Preferences pref) {
        super(parent, style, pref);
    }

    public void createContent() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 10;
        this.setLayout((Layout)gridLayout);
        Label text = new Label((Composite)this, 64);
        text.setText(EMFCompareRCPUIMessages.getString("DefaultMatchEngineConfiguratorUI.useIdentifier.label"));
        text.setLayoutData((Object)new GridData(1, 128, true, false));
        this.whenAvailableButton = new Button((Composite)this, 80);
        this.whenAvailableButton.setLayoutData((Object)new GridData(1, 128, true, false));
        this.whenAvailableButton.setText(EMFCompareRCPUIMessages.getString("DefaultMatchEngineConfiguratorUI.whenAvailable.label"));
        this.onlyButton = new Button((Composite)this, 80);
        this.onlyButton.setLayoutData((Object)new GridData(1, 128, true, false));
        this.onlyButton.setText(EMFCompareRCPUIMessages.getString("DefaultMatchEngineConfiguratorUI.only.label"));
        this.neverButton = new Button((Composite)this, 80);
        this.neverButton.setLayoutData((Object)new GridData(1, 128, true, false));
        this.neverButton.setText(EMFCompareRCPUIMessages.getString("DefaultMatchEngineConfiguratorUI.never.label"));
        UseIdentifiers defaultValue = DefaultRCPMatchEngineFactory.getUseIdentifierValue((Preferences)this.getPreference());
        this.dataHolder = new DataHolder(defaultValue);
        this.bindData();
    }

    private void bindData() {
        DataBindingContext ctx = new DataBindingContext();
        ISWTObservableValue whenAvailableBtnSelection = SWTObservables.observeSelection((Control)this.whenAvailableButton);
        ISWTObservableValue onlyButtonSelection = SWTObservables.observeSelection((Control)this.onlyButton);
        ISWTObservableValue neverButtonSelection = SWTObservables.observeSelection((Control)this.neverButton);
        SelectObservableValue featureRepoPolicyObservable = new SelectObservableValue(DataHolder.class);
        featureRepoPolicyObservable.addOption((Object)UseIdentifiers.WHEN_AVAILABLE, (IObservableValue)whenAvailableBtnSelection);
        featureRepoPolicyObservable.addOption((Object)UseIdentifiers.ONLY, (IObservableValue)onlyButtonSelection);
        featureRepoPolicyObservable.addOption((Object)UseIdentifiers.NEVER, (IObservableValue)neverButtonSelection);
        ctx.bindValue((IObservableValue)featureRepoPolicyObservable, PojoObservables.observeValue((Object)this.dataHolder, (String)"value"));
    }

    public void storeConfiguration() {
        UseIdentifiers value = this.dataHolder.getValue();
        if (value != DefaultRCPMatchEngineFactory.DEFAULT_USE_IDENTIFIER_ATRIBUTE) {
            this.getPreference().put("UseIdentifier", value.toString());
        } else {
            this.getPreference().remove("UseIdentifier");
        }
    }

    public void resetDefault() {
        if (this.whenAvailableButton != null && !this.whenAvailableButton.isDisposed()) {
            this.whenAvailableButton.setSelection(DefaultRCPMatchEngineFactory.DEFAULT_USE_IDENTIFIER_ATRIBUTE == UseIdentifiers.WHEN_AVAILABLE);
        }
        if (this.onlyButton != null && !this.onlyButton.isDisposed()) {
            this.onlyButton.setSelection(DefaultRCPMatchEngineFactory.DEFAULT_USE_IDENTIFIER_ATRIBUTE == UseIdentifiers.ONLY);
        }
        if (this.neverButton != null && !this.neverButton.isDisposed()) {
            this.neverButton.setSelection(DefaultRCPMatchEngineFactory.DEFAULT_USE_IDENTIFIER_ATRIBUTE == UseIdentifiers.NEVER);
        }
        this.dataHolder.setValue(DefaultRCPMatchEngineFactory.DEFAULT_USE_IDENTIFIER_ATRIBUTE);
        try {
            this.getPreference().remove("UseIdentifier");
        }
        catch (IllegalStateException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private static final class DataHolder {
        private UseIdentifiers value;

        public DataHolder(UseIdentifiers value) {
            this.value = value;
        }

        public UseIdentifiers getValue() {
            return this.value;
        }

        public void setValue(UseIdentifiers value) {
            this.value = value;
        }
    }
}

