/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFaceUtil {
    public static boolean isFiltered(StructuredViewer viewer, Object object, Object parent) {
        ViewerFilter[] viewerFilterArray = viewer.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (!filter.select((Viewer)viewer, parent, object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Set<?> visibleElements(TreeViewer treeViewer, Predicate<? super Object> predicate) {
        HashSet acc = Sets.newHashSet();
        JFaceUtil.appendNonFilteredChildren(treeViewer, treeViewer.getTree().getItems(), null, predicate, acc);
        return acc;
    }

    private static void appendNonFilteredChildren(TreeViewer treeViewer, TreeItem[] elements, Object parent, Predicate<? super Object> predicate, Set<Object> acc) {
        TreeItem[] treeItemArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem element = treeItemArray[n2];
            if (!JFaceUtil.isFiltered((StructuredViewer)treeViewer, element.getData(), parent) && predicate.apply(element.getData())) {
                acc.add(element.getData());
            }
            TreeItem[] children = element.getItems();
            JFaceUtil.appendNonFilteredChildren(treeViewer, children, element, predicate, acc);
            ++n2;
        }
    }
}

