/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceLocationChange;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EMFComparePredicates {
    public static final Predicate<? super Diff> WITHOUT_CONFLICT = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return input != null && input.getConflict() == null;
        }
    };
    public static final Predicate<? super Diff> CONTAINMENT_REFERENCE_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return input instanceof ReferenceChange && ((ReferenceChange)input).getReference().isContainment();
        }
    };
    public static final Predicate<? super EObject> IS_EGENERIC_TYPE_WITHOUT_PARAMETERS = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            EGenericType eGenericTypeContainer;
            boolean isEGenericWithoutParams = input instanceof EGenericType && ((EGenericType)input).getETypeArguments().isEmpty() ? (input.eContainer() instanceof EGenericType ? !(eGenericTypeContainer = (EGenericType)input.eContainer()).getETypeArguments().contains((Object)input) && !input.equals(eGenericTypeContainer.getELowerBound()) && !input.equals(eGenericTypeContainer.getEUpperBound()) : true) : false;
            return isEGenericWithoutParams;
        }
    };

    private EMFComparePredicates() {
    }

    public static Predicate<? super Diff> changedReference(String qualifiedName, String referenceName, String fromQualifiedName, String toQualifiedName) {
        ReferenceValuesMatch valuesMatch = new ReferenceValuesMatch(referenceName, fromQualifiedName, toQualifiedName);
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind(DifferenceKind.CHANGE), EMFComparePredicates.onEObject(qualifiedName), valuesMatch});
    }

    public static Predicate<? super Diff> addedToAttribute(String qualifiedName, String attributeName, Object addedValue) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind(DifferenceKind.ADD), EMFComparePredicates.onEObject(qualifiedName), EMFComparePredicates.attributeValueMatch(attributeName, addedValue, true)});
    }

    public static Predicate<? super Diff> addedToReference(String qualifiedName, String referenceName, String addedQualifiedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind(DifferenceKind.ADD), EMFComparePredicates.onEObject(qualifiedName), EMFComparePredicates.referenceValueMatch(referenceName, addedQualifiedName, true)});
    }

    public static Predicate<? super Diff> addedToReference(String qualifiedName, String referenceName, String addedQualifiedName, EStructuralFeature featureDelegateForAddedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind(DifferenceKind.ADD), EMFComparePredicates.onEObject(qualifiedName), EMFComparePredicates.referenceValueMatch(referenceName, addedQualifiedName, true, featureDelegateForAddedName)});
    }

    public static Predicate<? super Diff> movedInAttribute(String qualifiedName, String attributeName, Object removedValue) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind(DifferenceKind.MOVE), EMFComparePredicates.onEObject(qualifiedName), EMFComparePredicates.attributeValueMatch(attributeName, removedValue, true)});
    }

    public static Predicate<? super Diff> movedInReference(String qualifiedName, String referenceName, String removedQualifiedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind(DifferenceKind.MOVE), EMFComparePredicates.onEObject(qualifiedName), EMFComparePredicates.referenceValueMatch(referenceName, removedQualifiedName, true)});
    }

    public static Predicate<Diff> isDiffOnEOppositeOf(final ReferenceChange diff) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                return input instanceof ReferenceChange && diff.getReference().getEOpposite() == ((ReferenceChange)input).getReference();
            }
        };
    }

    public static Predicate<Diff> isEquivalentTo(final Diff diff) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                return input.getEquivalence() != null && input.getEquivalence().getDifferences().contains((Object)diff);
            }
        };
    }

    public static Predicate<Diff> hasSameReferenceAs(final ReferenceChange diff) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                return input instanceof ReferenceChange && diff.getReference() == ((ReferenceChange)input).getReference();
            }
        };
    }

    public static Predicate<? super Diff> removedFromAttribute(String qualifiedName, String attributeName, Object removedValue) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind(DifferenceKind.DELETE), EMFComparePredicates.onEObject(qualifiedName), EMFComparePredicates.attributeValueMatch(attributeName, removedValue, true)});
    }

    public static Predicate<? super Diff> removedFromReference(String qualifiedName, String referenceName, String removedQualifiedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind(DifferenceKind.DELETE), EMFComparePredicates.onEObject(qualifiedName), EMFComparePredicates.referenceValueMatch(referenceName, removedQualifiedName, true)});
    }

    public static Predicate<? super Diff> removedFromReference(String qualifiedName, String referenceName, String removedQualifiedName, EStructuralFeature featureDelegateForRemovedName) {
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind(DifferenceKind.DELETE), EMFComparePredicates.onEObject(qualifiedName), EMFComparePredicates.referenceValueMatch(referenceName, removedQualifiedName, true, featureDelegateForRemovedName)});
    }

    public static Predicate<? super Diff> changedAttribute(String qualifiedName, String attributeName, Object fromValue, Object toValue) {
        AttributeValuesMatch valuesMatch = new AttributeValuesMatch(attributeName, fromValue, toValue);
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind(DifferenceKind.CHANGE), EMFComparePredicates.onEObject(qualifiedName), valuesMatch});
    }

    public static Predicate<? super Diff> added(String qualifiedName) {
        int parentEndIndex = qualifiedName.lastIndexOf(46);
        if (parentEndIndex >= 0) {
            String ancestors = qualifiedName.substring(0, parentEndIndex);
            String objectName = qualifiedName.substring(parentEndIndex + 1);
            return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind(DifferenceKind.ADD), EMFComparePredicates.onEObject(ancestors), EMFComparePredicates.valueNameMatches(objectName)});
        }
        return Predicates.and(EMFComparePredicates.valueNameMatches(qualifiedName), EMFComparePredicates.ofKind(DifferenceKind.ADD));
    }

    public static Predicate<? super Diff> moved(String qualifiedName, String referenceName) {
        int parentEndIndex = qualifiedName.lastIndexOf(46);
        if (parentEndIndex >= 0) {
            String ancestors = qualifiedName.substring(0, parentEndIndex);
            String objectName = qualifiedName.substring(parentEndIndex + 1);
            return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind(DifferenceKind.MOVE), EMFComparePredicates.onEObject(ancestors), EMFComparePredicates.onFeature(referenceName), EMFComparePredicates.valueNameMatches(objectName)});
        }
        return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind(DifferenceKind.MOVE), EMFComparePredicates.valueNameMatches(qualifiedName), EMFComparePredicates.onFeature(referenceName)});
    }

    public static Predicate<? super Diff> removed(String qualifiedName) {
        int parentEndIndex = qualifiedName.lastIndexOf(46);
        if (parentEndIndex >= 0) {
            String ancestors = qualifiedName.substring(0, parentEndIndex);
            String objectName = qualifiedName.substring(parentEndIndex + 1);
            return Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.ofKind(DifferenceKind.DELETE), EMFComparePredicates.onEObject(ancestors), EMFComparePredicates.valueNameMatches(objectName)});
        }
        return Predicates.and(EMFComparePredicates.valueNameMatches(qualifiedName), EMFComparePredicates.ofKind(DifferenceKind.DELETE));
    }

    public static Predicate<? super Diff> onFeature(final String featureName) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                EAttribute affectedFeature;
                if (input instanceof AttributeChange) {
                    affectedFeature = ((AttributeChange)input).getAttribute();
                } else if (input instanceof ReferenceChange) {
                    affectedFeature = ((ReferenceChange)input).getReference();
                } else if (input instanceof FeatureMapChange) {
                    affectedFeature = ((FeatureMapChange)input).getAttribute();
                } else {
                    return false;
                }
                return featureName.equals(affectedFeature.getName());
            }
        };
    }

    public static Predicate<? super Diff> fromSide(final DifferenceSource source) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                return input != null && input.getSource() == source;
            }
        };
    }

    public static Predicate<? super Diff> onEObject(final EObject eObject) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                if (input == null) {
                    return false;
                }
                Match match = input.getMatch();
                return match.getLeft() == eObject || match.getRight() == eObject || match.getOrigin() == eObject;
            }
        };
    }

    public static Predicate<? super Diff> onEObject(final String qualifiedName) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                if (input == null || input instanceof ResourceLocationChange) {
                    return false;
                }
                Match match = input.getMatch();
                return EMFComparePredicates.match(match.getLeft(), qualifiedName, null) || EMFComparePredicates.match(match.getRight(), qualifiedName, null) || EMFComparePredicates.match(match.getOrigin(), qualifiedName, null);
            }
        };
    }

    public static Predicate<? super Diff> onEObject(final String qualifiedName, final EStructuralFeature featureDelegate) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                if (input == null) {
                    return false;
                }
                Match match = input.getMatch();
                return EMFComparePredicates.match(match.getLeft(), qualifiedName, featureDelegate) || EMFComparePredicates.match(match.getRight(), qualifiedName, featureDelegate) || EMFComparePredicates.match(match.getOrigin(), qualifiedName, featureDelegate);
            }
        };
    }

    public static Predicate<? super Diff> ofKind(final DifferenceKind kind) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                return input != null && input.getKind() == kind;
            }
        };
    }

    public static Predicate<? super Diff> valueIs(final Object expectedValue) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                Object value;
                if (input instanceof ReferenceChange) {
                    value = ((ReferenceChange)input).getValue();
                } else if (input instanceof AttributeChange) {
                    value = ((AttributeChange)input).getValue();
                } else if (input instanceof FeatureMapChange) {
                    value = ((FeatureMapChange)input).getValue();
                } else {
                    return false;
                }
                return value == expectedValue || value != null && value.equals(expectedValue);
            }
        };
    }

    public static Predicate<? super Diff> attributeValueMatch(final String attributeName, final Object expectedValue, final boolean multiValued) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                if (input instanceof AttributeChange && ((AttributeChange)input).getAttribute().getName().equals(attributeName) && ((AttributeChange)input).getAttribute().isMany() == multiValued) {
                    Object value = ((AttributeChange)input).getValue();
                    return input.getMatch().getComparison().getEqualityHelper().matchingAttributeValues(value, expectedValue);
                }
                return false;
            }
        };
    }

    public static Predicate<? super Diff> referenceValueMatch(final String referenceName, final String qualifiedName, final boolean multiValued) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                if (input instanceof ReferenceChange && ((ReferenceChange)input).getReference().getName().equals(referenceName) && ((ReferenceChange)input).getReference().isMany() == multiValued) {
                    EObject value = ((ReferenceChange)input).getValue();
                    return qualifiedName != null && EMFComparePredicates.match(value, qualifiedName, null);
                }
                return false;
            }
        };
    }

    public static Predicate<? super Diff> referenceValueMatch(final String referenceName, final String qualifiedName, final boolean multiValued, final EStructuralFeature featureDelegate) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                if (input instanceof ReferenceChange && ((ReferenceChange)input).getReference().getName().equals(referenceName) && ((ReferenceChange)input).getReference().isMany() == multiValued) {
                    EObject value = ((ReferenceChange)input).getValue();
                    return qualifiedName != null && EMFComparePredicates.match(value, qualifiedName, featureDelegate);
                }
                return false;
            }
        };
    }

    public static Predicate<? super Diff> valueNameMatches(final String expectedName) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                if (!(input instanceof ReferenceChange)) {
                    return false;
                }
                EObject value = ((ReferenceChange)input).getValue();
                return EMFComparePredicates.internalMatch(value, expectedName, null);
            }
        };
    }

    public static Predicate<? super Diff> valueNameMatches(final String expectedName, final EStructuralFeature featureDelegate) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                if (!(input instanceof ReferenceChange)) {
                    return false;
                }
                EObject value = ((ReferenceChange)input).getValue();
                return EMFComparePredicates.internalMatch(value, expectedName, featureDelegate);
            }
        };
    }

    public static Predicate<? super Diff> hasConflict(final ConflictKind ... kinds) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                return input != null && input.getConflict() != null && Arrays.asList(kinds).contains((Object)input.getConflict().getKind());
            }
        };
    }

    public static Predicate<? super Diff> hasState(final DifferenceState ... states) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                return input != null && Arrays.asList(states).contains((Object)input.getState());
            }
        };
    }

    @Deprecated
    public static Predicate<? super Diff> containmentReferenceChange() {
        return CONTAINMENT_REFERENCE_CHANGE;
    }

    private static boolean match(EObject eObject, String qualifiedName, EStructuralFeature featureDelegate) {
        boolean matches;
        if (eObject == null || qualifiedName == null || qualifiedName.length() == 0) {
            return false;
        }
        String[] names = qualifiedName.split("\\.");
        int current = names.length - 1;
        if (matches = EMFComparePredicates.internalMatch(eObject, names[current--], featureDelegate)) {
            EObject container = eObject.eContainer();
            while (matches && container != null && current >= 0) {
                matches = EMFComparePredicates.internalMatch(container, names[current--], featureDelegate);
                container = container.eContainer();
            }
            matches = matches && container == null;
        }
        return matches;
    }

    private static boolean matchAllowingNull(Object eObject, String qualifiedName) {
        if (eObject == null) {
            return qualifiedName == null;
        }
        return qualifiedName != null && eObject instanceof EObject && EMFComparePredicates.match((EObject)eObject, qualifiedName, null);
    }

    private static boolean internalMatch(EObject eObject, String name, EStructuralFeature featureDelegate) {
        EStructuralFeature nameFeature = EMFComparePredicates.getNameFeature(eObject);
        boolean match = false;
        if (nameFeature != null) {
            Object featureValue = eObject.eGet(nameFeature);
            if (featureValue instanceof String) {
                match = featureValue.equals(name);
            }
        } else if (featureDelegate != null && !featureDelegate.isMany()) {
            Object featureValue = eObject.eGet(featureDelegate, false);
            if (featureValue instanceof String) {
                match = featureValue.equals(name);
            } else if (featureValue instanceof EObject) {
                match = EMFComparePredicates.internalMatch((EObject)featureValue, name, null);
            }
        }
        return match;
    }

    private static EStructuralFeature getNameFeature(EObject eObject) {
        if (eObject instanceof ENamedElement) {
            return EcorePackage.eINSTANCE.getENamedElement_Name();
        }
        EStructuralFeature nameFeature = null;
        Iterator features = eObject.eClass().getEAllStructuralFeatures().iterator();
        while (nameFeature == null && features.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)features.next();
            if (!"name".equals(feature.getName())) continue;
            nameFeature = feature;
        }
        return nameFeature;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AttributeValuesMatch
    implements Predicate<Diff> {
        private final String attributeName;
        private final Object fromValue;
        private final Object toValue;

        public AttributeValuesMatch(String attributeName, Object fromValue, Object toValue) {
            this.attributeName = attributeName;
            this.fromValue = fromValue;
            this.toValue = toValue;
        }

        private static boolean equalAttributeValues(Object attributeValue, Object expectedValue) {
            boolean equal;
            boolean bl = equal = expectedValue == attributeValue || expectedValue != null && expectedValue.equals(attributeValue);
            if (!equal) {
                equal = "".equals(attributeValue) && expectedValue == null || "".equals(expectedValue) && attributeValue == null;
            }
            return equal;
        }

        public boolean apply(Diff input) {
            if (input instanceof AttributeChange && ((AttributeChange)input).getAttribute().getName().equals(this.attributeName) && !((AttributeChange)input).getAttribute().isMany()) {
                EAttribute attribute = ((AttributeChange)input).getAttribute();
                Match match = input.getMatch();
                Object leftValue = match.getLeft() != null ? match.getLeft().eGet((EStructuralFeature)attribute) : attribute.getDefaultValue();
                Object rightValue = match.getRight() != null ? match.getRight().eGet((EStructuralFeature)attribute) : attribute.getDefaultValue();
                Object originValue = match.getOrigin() != null ? match.getOrigin().eGet((EStructuralFeature)attribute) : attribute.getDefaultValue();
                Object actualFrom = this.fromValue == null ? attribute.getDefaultValue() : this.fromValue;
                Object actualTo = this.toValue == null ? attribute.getDefaultValue() : this.toValue;
                boolean applies = false;
                if (AttributeValuesMatch.equalAttributeValues(actualFrom, originValue)) {
                    applies = AttributeValuesMatch.equalAttributeValues(actualTo, leftValue) || AttributeValuesMatch.equalAttributeValues(actualTo, rightValue);
                } else if (AttributeValuesMatch.equalAttributeValues(actualFrom, rightValue)) {
                    applies = AttributeValuesMatch.equalAttributeValues(actualTo, leftValue);
                }
                return applies;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReferenceValuesMatch
    implements Predicate<Diff> {
        private final String referenceName;
        private final String fromQualifiedName;
        private final String toQualifiedName;

        public ReferenceValuesMatch(String referenceName, String fromQualifiedName, String toQualifiedName) {
            this.referenceName = referenceName;
            this.fromQualifiedName = fromQualifiedName;
            this.toQualifiedName = toQualifiedName;
        }

        public boolean apply(Diff input) {
            if (input instanceof ReferenceChange && ((ReferenceChange)input).getReference().getName().equals(this.referenceName) && !((ReferenceChange)input).getReference().isMany()) {
                EReference reference = ((ReferenceChange)input).getReference();
                Match match = input.getMatch();
                Object leftValue = match.getLeft() != null ? match.getLeft().eGet((EStructuralFeature)reference) : null;
                Object rightValue = match.getRight() != null ? match.getRight().eGet((EStructuralFeature)reference) : null;
                Object originValue = match.getOrigin() != null ? match.getOrigin().eGet((EStructuralFeature)reference) : null;
                boolean applies = false;
                if (EMFComparePredicates.matchAllowingNull(originValue, this.fromQualifiedName)) {
                    applies = EMFComparePredicates.matchAllowingNull(leftValue, this.toQualifiedName) || EMFComparePredicates.matchAllowingNull(rightValue, this.toQualifiedName);
                } else if (EMFComparePredicates.matchAllowingNull(rightValue, this.fromQualifiedName)) {
                    applies = EMFComparePredicates.matchAllowingNull(leftValue, this.toQualifiedName);
                }
                return applies;
            }
            return false;
        }
    }
}

