/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.utils;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.compare.provider.utils.IStyledString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComposedStyledString
implements IStyledString.IComposedStyledString {
    private final List<IStyledString> content = Lists.newArrayList();

    public ComposedStyledString() {
    }

    public ComposedStyledString(String text) {
        this(text, IStyledString.Style.NO_STYLE);
    }

    public ComposedStyledString(String text, IStyledString.Style style) {
        this();
        this.append(text, style);
    }

    @Override
    public String getString() {
        StringBuilder sb = new StringBuilder();
        for (IStyledString styledString : this) {
            sb.append(styledString.getString());
        }
        return sb.toString();
    }

    @Override
    public IStyledString.IComposedStyledString append(String str) {
        this.content.add(new StyledString(str, IStyledString.Style.NO_STYLE));
        return this;
    }

    @Override
    public IStyledString.IComposedStyledString append(String str, IStyledString.Style style) {
        this.content.add(new StyledString(str, style));
        return this;
    }

    @Override
    public IStyledString.IComposedStyledString append(IStyledString.IComposedStyledString composedStyledString) {
        for (IStyledString styledString : composedStyledString) {
            this.content.add(styledString);
        }
        return this;
    }

    @Override
    public Iterator<IStyledString> iterator() {
        return this.content.iterator();
    }

    private static final class StyledString
    implements IStyledString {
        private final String str;
        private final IStyledString.Style style;

        StyledString(String str, IStyledString.Style style) {
            this.str = str;
            this.style = style;
        }

        public String getString() {
            return this.str;
        }

        public IStyledString.Style getStyle() {
            return this.style;
        }
    }
}

