/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.internal.factories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.diagram.internal.CompareDiagramConfiguration;
import org.eclipse.emf.compare.diagram.internal.factories.AbstractDiagramChangeFactory;
import org.eclipse.emf.compare.diagram.internal.factories.extensions.CoordinatesChangeFactory;
import org.eclipse.emf.compare.diagram.internal.factories.extensions.DiagramChangeFactory;
import org.eclipse.emf.compare.diagram.internal.factories.extensions.EdgeChangeFactory;
import org.eclipse.emf.compare.diagram.internal.factories.extensions.HideFactory;
import org.eclipse.emf.compare.diagram.internal.factories.extensions.NodeChangeFactory;
import org.eclipse.emf.compare.diagram.internal.factories.extensions.ShowFactory;
import org.eclipse.emf.compare.internal.postprocessor.factories.IChangeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiagramExtensionFactoryRegistry {
    private DiagramExtensionFactoryRegistry() {
    }

    public static Map<Class<? extends Diff>, IChangeFactory> createExtensionFactories(CompareDiagramConfiguration configuration) {
        HashMap<Class, IChangeFactory> dataset = new HashMap<Class, IChangeFactory>();
        ArrayList<AbstractDiagramChangeFactory> factories = new ArrayList<AbstractDiagramChangeFactory>();
        factories.add(new HideFactory());
        factories.add(new ShowFactory());
        factories.add(new NodeChangeFactory());
        factories.add(new CoordinatesChangeFactory(configuration));
        factories.add(new EdgeChangeFactory());
        factories.add(new DiagramChangeFactory());
        for (IChangeFactory iChangeFactory : factories) {
            dataset.put(iChangeFactory.getExtensionKind(), iChangeFactory);
        }
        return Collections.unmodifiableMap(dataset);
    }
}

