/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.internal.policy;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.policy.ILoadOnDemandPolicy;

public class LoadOnDemandPolicyRegistryListener
extends AbstractRegistryEventListener {
    static final String TAG_POLICY = "policy";
    static final String ATT_CLASS = "class";
    private final ILoadOnDemandPolicy.Registry registry;

    public LoadOnDemandPolicyRegistryListener(ILoadOnDemandPolicy.Registry registry, String pluginID, String extensionPointID, ILog log) {
        super(pluginID, extensionPointID, log);
        this.registry = registry;
    }

    protected boolean validateExtensionElement(IConfigurationElement element) {
        if (TAG_POLICY.equals(element.getName())) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                return true;
            }
        }
        return false;
    }

    protected boolean addedValid(IConfigurationElement element) {
        try {
            ILoadOnDemandPolicy policy = (ILoadOnDemandPolicy)element.createExecutableExtension(ATT_CLASS);
            ILoadOnDemandPolicy previous = this.registry.addPolicy(policy);
            if (previous != null) {
                this.log(2, element, "The factory '" + policy.getClass().getName() + "' is registered twice.");
            }
        }
        catch (CoreException e) {
            this.log(4, element, e.getMessage());
            return false;
        }
        return true;
    }

    protected boolean removedValid(IConfigurationElement element) {
        this.registry.removePolicy(element.getAttribute(ATT_CLASS));
        return true;
    }
}

