/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.factory.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.factory.IAccessorFactory;

public class AccessorFactoryExtensionRegistryListener
extends AbstractRegistryEventListener {
    static final String TAG_FACTORY = "factory";
    static final String ATT_CLASS = "class";
    static final String ATT_RANKING = "ranking";
    private final IAccessorFactory.Registry registry;

    public AccessorFactoryExtensionRegistryListener(String pluginID, String extensionPointID, ILog log, IAccessorFactory.Registry registry) {
        super(pluginID, extensionPointID, log);
        this.registry = registry;
    }

    protected boolean validateExtensionElement(IConfigurationElement element) {
        boolean valid;
        if (element.getName().equals(TAG_FACTORY)) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
                valid = false;
            } else if (element.getAttribute(ATT_RANKING) == null) {
                String rankingStr = element.getAttribute(ATT_RANKING);
                try {
                    Integer.parseInt(rankingStr);
                }
                catch (NumberFormatException numberFormatException) {
                    this.log(4, element, "Attribute 'ranking' is malformed, should be an integer.");
                }
                this.logMissingAttribute(element, ATT_RANKING);
                valid = false;
            } else {
                valid = true;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    protected boolean addedValid(IConfigurationElement element) {
        try {
            IAccessorFactory factory = (IAccessorFactory)element.createExecutableExtension(ATT_CLASS);
            factory.setRanking(Integer.parseInt(element.getAttribute(ATT_RANKING)));
            IAccessorFactory previous = this.registry.add(factory);
            if (previous != null) {
                this.log(2, element, "The accessor factory '" + factory.getClass().getName() + "' is registered twice.");
            }
        }
        catch (CoreException e) {
            this.log(element, e);
        }
        return true;
    }

    protected boolean removedValid(IConfigurationElement element) {
        this.registry.remove(element.getAttribute(ATT_CLASS));
        return true;
    }
}

