/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.internal.merge;

import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.merge.AbstractMerger;

public class CompareDiagramMerger
extends AbstractMerger {
    public boolean isMergerFor(Diff target) {
        return target instanceof DiagramDiff;
    }

    public void copyLeftToRight(Diff target, Monitor monitor) {
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        DiagramDiff diff = (DiagramDiff)target;
        this.setEquivalentDiffAsMerged(diff);
        diff.setState(DifferenceState.MERGED);
        if (diff.getSource() == DifferenceSource.LEFT) {
            this.mergeRequires(diff, false, monitor);
        } else {
            this.mergeRequiredBy(diff, false, monitor);
        }
        for (Diff refining : diff.getRefinedBy()) {
            this.mergeDiff(refining, false, monitor);
        }
    }

    public void copyRightToLeft(Diff target, Monitor monitor) {
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        DiagramDiff diff = (DiagramDiff)target;
        this.setEquivalentDiffAsMerged(diff);
        diff.setState(DifferenceState.MERGED);
        if (diff.getSource() == DifferenceSource.LEFT) {
            this.mergeRequiredBy(diff, true, monitor);
        } else {
            this.mergeRequires(diff, true, monitor);
        }
        for (Diff refining : diff.getRefinedBy()) {
            this.mergeDiff(refining, true, monitor);
        }
    }

    private void setEquivalentDiffAsMerged(DiagramDiff diff) {
        if (diff.getEquivalence() != null) {
            for (Diff equivalent : diff.getEquivalence().getDifferences()) {
                equivalent.setState(DifferenceState.MERGED);
            }
        }
    }
}

