/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.compare.match.DefaultComparisonFactory;
import org.eclipse.emf.compare.match.IComparisonFactory;
import org.eclipse.emf.compare.match.IEqualityHelperFactory;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.ReflectiveWeightProvider;
import org.eclipse.emf.compare.match.eobject.URIDistance;
import org.eclipse.emf.compare.match.eobject.WeightProvider;
import org.eclipse.emf.compare.utils.DiffUtil;
import org.eclipse.emf.compare.utils.EqualityHelper;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;

public class EditionDistance
implements ProximityEObjectMatcher.DistanceFunction {
    private static final double MAX_DIST_RATIO = 0.75;
    private int referenceChangeCoef = 3;
    private int attributeChangeCoef = 10;
    private int locationChangeCoef = 4;
    private int orderChangeCoef = 2;
    private URIDistance uriDistance = new URIDistance();
    private EqualityHelper helper;
    private WeightProvider weights = new ReflectiveWeightProvider();

    public EditionDistance() {
        this.helper = new EqualityHelper(){

            protected boolean matchingURIs(EObject object1, EObject object2) {
                return EditionDistance.this.uriDistance.proximity(object1, object2) == 0;
            }
        };
    }

    public int distance(EObject a, EObject b) {
        int maxDist = Math.max(this.getMaxDistance(a), this.getMaxDistance(b));
        int measuredDist = new CountingDiffEngine(maxDist).measureDifferences(a, b);
        if (measuredDist >= maxDist) {
            return Integer.MAX_VALUE;
        }
        return measuredDist;
    }

    public boolean areIdentic(EObject a, EObject b) {
        return new CountingDiffEngine(0).measureDifferences(a, b) == 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getMaxDistance(EObject eObj) {
        Predicate<EStructuralFeature> featureFilter = new Predicate<EStructuralFeature>(){

            public boolean apply(EStructuralFeature feat) {
                return EditionDistance.this.weights.getWeight(feat) != 0;
            }
        };
        int max = 0;
        for (EReference feat : Iterables.filter((Iterable)eObj.eClass().getEAllReferences(), (Predicate)featureFilter)) {
            if (!eObj.eIsSet((EStructuralFeature)feat)) continue;
            max += this.weights.getWeight((EStructuralFeature)feat) * this.referenceChangeCoef;
        }
        for (EReference feat : Iterables.filter((Iterable)eObj.eClass().getEAllAttributes(), (Predicate)featureFilter)) {
            if (!eObj.eIsSet((EStructuralFeature)feat)) continue;
            max += this.weights.getWeight((EStructuralFeature)feat) * this.attributeChangeCoef;
        }
        return Double.valueOf((double)(max += this.locationChangeCoef * 5) * 0.75).intValue();
    }

    public static class Builder {
        private EditionDistance toBeBuilt = new EditionDistance();

        protected Builder() {
        }

        public Builder uri(int weight) {
            this.toBeBuilt.locationChangeCoef = weight;
            return this;
        }

        public Builder order(int weight) {
            this.toBeBuilt.orderChangeCoef = weight;
            return this;
        }

        public Builder attribute(int weight) {
            this.toBeBuilt.attributeChangeCoef = weight;
            return this;
        }

        public Builder reference(int weight) {
            this.toBeBuilt.referenceChangeCoef = weight;
            return this;
        }

        public Builder weightProvider(WeightProvider provider) {
            this.toBeBuilt.weights = provider;
            return this;
        }

        public EditionDistance build() {
            return this.toBeBuilt;
        }
    }

    class CountingDiffEngine
    extends DefaultDiffEngine {
        private int maxDistance;
        private final IComparisonFactory fakeComparisonFactory;

        public CountingDiffEngine(int maxDistance) {
            super(new CountingDiffProcessor());
            this.maxDistance = maxDistance;
            IEqualityHelperFactory fakeEqualityHelperFactory = new IEqualityHelperFactory(){

                public IEqualityHelper createEqualityHelper() {
                    return EditionDistance.this.helper;
                }
            };
            this.fakeComparisonFactory = new DefaultComparisonFactory(fakeEqualityHelperFactory);
        }

        protected void computeDifferences(Match match, EAttribute attribute, boolean checkOrdering) {
            if (this.getCounter().getComputedDistance() <= this.maxDistance) {
                super.computeDifferences(match, attribute, checkOrdering);
            }
        }

        protected void computeDifferences(Match match, EReference reference, boolean checkOrdering) {
            if (this.getCounter().getComputedDistance() <= this.maxDistance) {
                super.computeDifferences(match, reference, checkOrdering);
            }
        }

        public int measureDifferences(EObject a, EObject b) {
            Match fakeMatch = this.createFakeMatch(a, b);
            this.getCounter().reset();
            int changes = 0;
            int dist = EditionDistance.this.uriDistance.proximity(a, b);
            if ((changes += dist * EditionDistance.this.locationChangeCoef) <= this.maxDistance) {
                this.checkForDifferences(fakeMatch, (Monitor)new BasicMonitor());
                changes += this.getCounter().getComputedDistance();
            }
            return changes;
        }

        private Match createFakeMatch(EObject a, EObject b) {
            Comparison fakeComparison = this.fakeComparisonFactory.createComparison();
            Match fakeMatch = CompareFactory.eINSTANCE.createMatch();
            ((InternalEList)fakeComparison.getMatches()).addUnique((Object)fakeMatch);
            fakeMatch.setLeft(a);
            fakeMatch.setRight(b);
            return fakeMatch;
        }

        protected CountingDiffProcessor getCounter() {
            return (CountingDiffProcessor)this.getDiffProcessor();
        }

        protected FeatureFilter createFeatureFilter() {
            return new FeatureFilter(){

                @Override
                public Iterator<EReference> getReferencesToCheck(Match match) {
                    return Iterators.filter(super.getReferencesToCheck(match), (Predicate)new Predicate<EReference>(){

                        public boolean apply(EReference input) {
                            return EditionDistance.this.weights.getWeight((EStructuralFeature)input) != 0;
                        }
                    });
                }

                @Override
                public Iterator<EAttribute> getAttributesToCheck(Match match) {
                    return Iterators.filter(super.getAttributesToCheck(match), (Predicate)new Predicate<EAttribute>(){

                        public boolean apply(EAttribute input) {
                            return EditionDistance.this.weights.getWeight((EStructuralFeature)input) != 0;
                        }
                    });
                }
            };
        }
    }

    class CountingDiffProcessor
    implements IDiffProcessor {
        private Set<EStructuralFeature> alreadyChanged = Sets.newLinkedHashSet();
        private int distance;

        CountingDiffProcessor() {
        }

        public void referenceChange(Match match, EReference reference, EObject value, DifferenceKind kind, DifferenceSource source) {
            if (!this.alreadyChanged.contains(reference)) {
                switch (kind) {
                    case MOVE: {
                        this.distance += EditionDistance.this.weights.getWeight((EStructuralFeature)reference) * EditionDistance.this.orderChangeCoef;
                        break;
                    }
                    case ADD: 
                    case DELETE: 
                    case CHANGE: {
                        this.distance += EditionDistance.this.weights.getWeight((EStructuralFeature)reference) * EditionDistance.this.referenceChangeCoef;
                        break;
                    }
                }
                this.alreadyChanged.add((EStructuralFeature)reference);
            } else {
                ++this.distance;
            }
        }

        public void attributeChange(Match match, EAttribute attribute, Object value, DifferenceKind kind, DifferenceSource source) {
            if (!this.alreadyChanged.contains(attribute)) {
                Object aValue = ReferenceUtil.safeEGet(match.getLeft(), (EStructuralFeature)attribute);
                Object bValue = ReferenceUtil.safeEGet(match.getRight(), (EStructuralFeature)attribute);
                switch (kind) {
                    case MOVE: {
                        this.distance += EditionDistance.this.weights.getWeight((EStructuralFeature)attribute) * EditionDistance.this.orderChangeCoef;
                        break;
                    }
                    case ADD: 
                    case DELETE: 
                    case CHANGE: {
                        if (aValue instanceof String && bValue instanceof String) {
                            this.distance = (int)((double)this.distance + (double)EditionDistance.this.weights.getWeight((EStructuralFeature)attribute) * (1.0 - DiffUtil.diceCoefficient((String)aValue, (String)bValue)) * (double)EditionDistance.this.attributeChangeCoef);
                            break;
                        }
                        this.distance += EditionDistance.this.weights.getWeight((EStructuralFeature)attribute) * EditionDistance.this.attributeChangeCoef;
                        break;
                    }
                }
                this.alreadyChanged.add((EStructuralFeature)attribute);
            } else {
                ++this.distance;
            }
        }

        public void resourceAttachmentChange(Match match, String uri, DifferenceKind kind, DifferenceSource source) {
        }

        public int getComputedDistance() {
            return this.distance;
        }

        public void reset() {
            this.alreadyChanged.clear();
        }
    }
}

