/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.emf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IInjector;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.core.emf.EMFModelFactory;
import org.eclipse.m2m.atl.core.emf.EMFReferenceModel;
import org.eclipse.m2m.atl.core.emf.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFInjector
implements IInjector {
    public static final String OPTION_LOAD_ON_DEMAND = "loadOnDemand";

    public void inject(IModel targetModel, String source, Map<String, Object> options) throws ATLCoreException {
        boolean loadOnDemand = true;
        if (options.containsKey(OPTION_LOAD_ON_DEMAND)) {
            loadOnDemand = options.get(OPTION_LOAD_ON_DEMAND).toString().equals("true");
        }
        ResourceSet resourceSet = ((EMFModelFactory)targetModel.getModelFactory()).getResourceSet();
        String path = source.toString();
        if (path != null) {
            try {
                Resource mainResource = null;
                mainResource = path.startsWith("pathmap:") ? resourceSet.getResource(URI.createURI((String)path).trimFragment(), loadOnDemand) : resourceSet.getResource(URI.createURI((String)path), loadOnDemand);
                this.inject(targetModel, mainResource);
            }
            catch (Throwable e) {
                throw new ATLCoreException(Messages.getString("EMFInjector.LOADING_ERROR", source, e.getMessage()), e);
            }
        } else {
            throw new ATLCoreException(Messages.getString("EMFInjector.NO_RESOURCE"));
        }
    }

    public void inject(IModel targetModel, String source) throws ATLCoreException {
        this.inject(targetModel, source, Collections.<String, Object>emptyMap());
    }

    public void inject(IModel targetModel, InputStream source, Map<String, Object> options) throws ATLCoreException {
        Resource mainResource = null;
        ResourceSet resourceSet = ((EMFModelFactory)targetModel.getModelFactory()).getResourceSet();
        mainResource = resourceSet.createResource(URI.createURI((String)"new-model"));
        try {
            mainResource.load(source, options);
        }
        catch (IOException e) {
            throw new ATLCoreException(e.getMessage(), (Throwable)e);
        }
        this.inject(targetModel, mainResource);
    }

    public void inject(IModel targetModel, Resource mainResource) {
        ((EMFModel)targetModel).setResource(mainResource);
        if (targetModel instanceof IReferenceModel) {
            ((EMFReferenceModel)targetModel).register();
        }
    }
}

