/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.ASMOperation;
import org.eclipse.m2m.atl.engine.vm.ASMParameter;
import org.eclipse.m2m.atl.engine.vm.ASMStackFrame;
import org.eclipse.m2m.atl.engine.vm.ASMXMLReader;
import org.eclipse.m2m.atl.engine.vm.Debugger;
import org.eclipse.m2m.atl.engine.vm.NativeStackFrame;
import org.eclipse.m2m.atl.engine.vm.SimpleDebugger;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.adwp.ADWPCommand;
import org.eclipse.m2m.atl.engine.vm.adwp.ADWPDebuggee;
import org.eclipse.m2m.atl.engine.vm.adwp.IntegerValue;
import org.eclipse.m2m.atl.engine.vm.adwp.LocalObjectReference;
import org.eclipse.m2m.atl.engine.vm.adwp.StringValue;
import org.eclipse.m2m.atl.engine.vm.adwp.Value;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModule;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;

public class NetworkDebugger
implements Debugger {
    private Map commands = new HashMap();
    private boolean step;
    private boolean stepOver;
    private boolean finish;
    private boolean finished;
    private int depth;
    private Socket socket;
    private ADWPDebuggee debuggee;
    private List breakpoints = new ArrayList();
    private ASMExecEnv execEnv;
    private NetworkDebugger thisDebugger;

    public NetworkDebugger(final int port, boolean suspend) {
        new Command(10, "get a property from an object"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                List args = cmd.getArgs();
                LocalObjectReference o = (LocalObjectReference)args.get(0);
                String propName = ((StringValue)args.get(1)).getValue();
                Value ret = o.get(propName);
                NetworkDebugger.this.debuggee.sendMessage(101, cmd.getAck(), Arrays.asList(ret));
                return false;
            }
        };
        new Command(11, "set a property to an object"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                List args = cmd.getArgs();
                LocalObjectReference o = (LocalObjectReference)args.get(0);
                String propName = ((StringValue)args.get(1)).getValue();
                Value value = (Value)args.get(2);
                o.set(propName, value);
                return false;
            }
        };
        new Command(12, "call an operation on an object"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                List args = cmd.getArgs();
                LocalObjectReference o = (LocalObjectReference)args.get(0);
                String opName = ((StringValue)args.get(1)).getValue();
                int nbArgs = ((IntegerValue)args.get(2)).getValue();
                ArrayList realArgs = nbArgs == 0 ? new ArrayList() : args.subList(3, args.size());
                Value ret = o.call(opName, realArgs);
                NetworkDebugger.this.debuggee.sendMessage(101, cmd.getAck(), Arrays.asList(ret));
                return false;
            }
        };
        new Command(21, "executes a query in the current context"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                List args = cmd.getArgs();
                String query = ((StringValue)args.get(1)).getValue();
                ASMOclAny asmRet = null;
                try {
                    String pname;
                    ASM asm = new ASMXMLReader().read(new ByteArrayInputStream(query.getBytes()));
                    SimpleDebugger debugger = new SimpleDebugger(false, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), true);
                    ASMOperation op = asm.getOperation("test");
                    ASMModule asmModule = new ASMModule(asm);
                    ArrayList<ASMOclAny> arguments = new ArrayList<ASMOclAny>();
                    arguments.add(0, asmModule);
                    ASMExecEnv env = new ASMExecEnv(asmModule, debugger);
                    Map models = NetworkDebugger.this.execEnv.getModels();
                    for (String mname : models.keySet()) {
                        env.addModel(mname, (ASMModel)models.get(mname));
                    }
                    env.registerOperations(asm);
                    HashMap<String, ASMOclAny> pvalues = new HashMap<String, ASMOclAny>();
                    ASMStackFrame asmFrame = (ASMStackFrame)frame;
                    for (String slot : asmFrame.getLocalVariables().keySet()) {
                        pname = slot.equals("_stack") ? slot : asmFrame.resolveVariableName(Integer.parseInt(slot));
                        pvalues.put(pname, asmFrame.getVariable(slot));
                    }
                    for (ASMParameter p : op.getParameters()) {
                        pname = op.resolveVariableName(Integer.parseInt(p.getName()), 0);
                        ASMOclAny value = (ASMOclAny)pvalues.get(pname);
                        arguments.add(value);
                    }
                    ASMStackFrame qframe = ASMStackFrame.rootFrame(env, op, arguments);
                    asmRet = op.exec(qframe);
                }
                catch (Exception e) {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                }
                Value ret = LocalObjectReference.asm2value(asmRet, NetworkDebugger.this.thisDebugger);
                NetworkDebugger.this.debuggee.sendMessage(101, cmd.getAck(), Arrays.asList(ret));
                return false;
            }
        };
        new Command(0, "resume program execution"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                return true;
            }
        };
        new Command(1, "execute a single instruction; stepping into method calls"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                NetworkDebugger.this.step = true;
                return true;
            }
        };
        new Command(2, "execute a single instruction; stepping over method calls"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                NetworkDebugger.this.stepOver = true;
                NetworkDebugger.this.depth = 0;
                return true;
            }
        };
        new Command(3, "run until after the execution of the current operation"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                NetworkDebugger.this.finish = true;
                NetworkDebugger.this.depth = 0;
                return true;
            }
        };
        new Command(13, "set a breakpoint"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                List args = cmd.getArgs();
                String location = ((StringValue)args.get(0)).getValue();
                NetworkDebugger.this.breakpoints.add(location);
                return false;
            }
        };
        new Command(14, "unset a breakpoint"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                List args = cmd.getArgs();
                String location = ((StringValue)args.get(0)).getValue();
                NetworkDebugger.this.breakpoints.remove(location);
                return false;
            }
        };
        new Command(20, "disassemble current operation"){

            public boolean doIt(ADWPCommand cmd, StackFrame frame) {
                ASMOperation op = (ASMOperation)((StackFrame)((LocalObjectReference)cmd.getArgs().get(0)).getObject()).getOperation();
                List instr = op.getInstructions();
                ArrayList<StringValue> msgArgs = new ArrayList<StringValue>();
                int k = 0;
                Iterator i = instr.iterator();
                while (i.hasNext()) {
                    String inst = i.next().toString();
                    if (inst.startsWith("load ")) {
                        inst = "load " + op.resolveVariableName(Integer.parseInt(inst.substring(5)), k);
                    } else if (inst.startsWith("store ")) {
                        inst = "store " + op.resolveVariableName(Integer.parseInt(inst.substring(6)), k);
                    }
                    msgArgs.add(StringValue.valueOf(inst));
                    ++k;
                }
                NetworkDebugger.this.debuggee.sendMessage(102, cmd.getAck(), msgArgs);
                return false;
            }
        };
        this.thisDebugger = this;
        if (suspend) {
            this.step = true;
        }
        Thread init = new Thread(){

            public void run() {
                try {
                    ServerSocket server = new ServerSocket(port);
                    NetworkDebugger.this.socket = server.accept();
                    server.close();
                    NetworkDebugger.this.debuggee = new ADWPDebuggee(NetworkDebugger.this.socket.getInputStream(), NetworkDebugger.this.socket.getOutputStream());
                }
                catch (IOException ioe) {
                    ATLLogger.log((Level)Level.SEVERE, (String)ioe.getLocalizedMessage(), (Throwable)ioe);
                }
            }
        };
        if (suspend) {
            init.run();
        } else {
            init.start();
        }
    }

    public void enter(StackFrame frame) {
        if (this.stepOver || this.finish) {
            ++this.depth;
        }
    }

    public void leave(StackFrame frame) {
        if (this.depth == 0 && this.finish) {
            this.step = true;
            this.finished = true;
        }
        if ((this.stepOver || this.finish) && this.depth > 0) {
            --this.depth;
        }
    }

    public void step(ASMStackFrame frame) {
        if (this.execEnv == null) {
            this.execEnv = (ASMExecEnv)frame.getExecEnv();
        }
        if (this.stepOver && this.depth == 0) {
            this.stepOver = false;
            this.step = true;
        }
        if (this.step) {
            if (this.finished) {
                this.dialog(frame, "after finishing");
            } else {
                this.dialog(frame, "for stepping");
            }
        } else {
            int location = frame.getLocation();
            ASMOperation operation = (ASMOperation)frame.getOperation();
            String sourceLocation = operation.resolveLineNumber(location);
            if (this.breakpoints.contains(sourceLocation)) {
                this.dialog(frame, "for breakpoint");
            }
        }
    }

    public void terminated() {
        try {
            this.debuggee.sendMessage(103, 0, Collections.EMPTY_LIST);
            this.socket.close();
        }
        catch (IOException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void dialog(StackFrame stFrame, String msg) {
        while (stFrame instanceof NativeStackFrame) {
            stFrame = stFrame.getParent();
        }
        ASMStackFrame frame = (ASMStackFrame)stFrame;
        int location = frame.getLocation();
        ASMOperation operation = (ASMOperation)frame.getOperation();
        String opName = operation.getName();
        String sourceLocation = operation.resolveLineNumber(location);
        this.debuggee.sendMessage(100, 0, Arrays.asList(StringValue.valueOf(msg), LocalObjectReference.valueOf(frame, this), StringValue.valueOf(opName), IntegerValue.valueOf(location), StringValue.valueOf(sourceLocation)));
        boolean resume = false;
        do {
            ADWPCommand acmd = this.debuggee.readCommand();
            resume = false;
            this.step = false;
            this.stepOver = false;
            this.finish = false;
            this.finished = false;
            Command cmd = (Command)this.commands.get(new Integer(acmd.getCode()));
            if (cmd == null) {
                ATLLogger.warning((String)("unsupported command: " + acmd.getCode()));
                continue;
            }
            resume = cmd.doIt(acmd, frame);
        } while (!resume);
    }

    public void error(StackFrame frame, String msg, Exception e) {
        ATLLogger.severe((String)"********************************* ERROR *********************************");
        ATLLogger.log((Level)Level.SEVERE, (String)"", (Throwable)new Exception());
        this.dialog(frame, "ERROR: " + msg);
        if (msg != null) {
            ATLLogger.severe((String)("Message: " + msg));
        }
        if (e != null) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        frame.getExecEnv().printStackTrace();
        ATLLogger.severe((String)"*************************************************************************");
    }

    public ASMExecEnv getExecEnv() {
        return this.execEnv;
    }

    private abstract class Command {
        private String description;

        public Command(int cmd, String description) {
            this.description = description;
            NetworkDebugger.this.commands.put(new Integer(cmd), this);
        }

        public abstract boolean doIt(ADWPCommand var1, StackFrame var2);

        public String getDescription() {
            return this.description;
        }
    }
}

