/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.service.core.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.service.core.exception.ServiceException;
import org.eclipse.m2m.atl.service.core.nestedElements.Model;
import org.eclipse.m2m.atl.service.core.nestedElements.Transformation;

public abstract class TransformationConfiguration {
    private String configurationName;
    protected String pluginId;
    protected Map models;
    private List fileExtensions = new ArrayList();

    public TransformationConfiguration(String configurationName, String pluginId) {
        this.configurationName = configurationName;
        this.pluginId = pluginId;
        this.models = new HashMap();
    }

    public abstract void execute(String var1, String var2) throws ServiceException;

    public void addFileExtension(String fileExtension) {
        this.fileExtensions.add(fileExtension);
    }

    public List getFileExtensions() {
        return this.fileExtensions;
    }

    public boolean isMatchingExtension(String extension) {
        Iterator it = this.fileExtensions.iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).equals(extension)) continue;
            return true;
        }
        return false;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public Map getModelsForTransformation(Transformation t) {
        HashMap<String, ASMModel> ret = new HashMap<String, ASMModel>();
        for (String modelNameInTransformationHeader : t.getInModels().keySet()) {
            ret.put(modelNameInTransformationHeader, ((Model)this.models.get(t.getInModels().get(modelNameInTransformationHeader))).getAsmModel());
        }
        for (String modelNameInConfiguration : t.getOutModels().keySet()) {
            ret.put(modelNameInConfiguration, ((Model)this.models.get(t.getOutModels().get(modelNameInConfiguration))).getAsmModel());
        }
        return ret;
    }
}

