/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.QuietRuntimeException;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DropWhileStageVerification
extends AbstractStageVerification {
    DropWhileStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void dropWhileStageShouldSupportDroppingElements() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3, 4, 0}).dropWhile(i -> i < 3).toList().run(this.getEngine()))), Arrays.asList(3, 4, 0));
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void dropWhileStageShouldHandleErrors() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.infiniteStream().onTerminate(() -> cancelled.complete(null)).dropWhile(i -> {
            throw new QuietRuntimeException("failed");
        }).toList().run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void dropWhileStageShouldPropagateUpstreamErrorsWhileDropping() {
        this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).dropWhile(i -> i < 3).toList().run(this.getEngine()));
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void dropWhileStageShouldPropagateUpstreamErrorsAfterFinishedDropping() {
        this.await(this.infiniteStream().peek(i -> {
            if (i == 4) {
                throw new QuietRuntimeException("failed");
            }
        }).dropWhile(i -> i < 3).toList().run(this.getEngine()));
    }

    @Test
    public void dropWhileStageShouldNotRunPredicateOnceItsFinishedDropping() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3, 4}).dropWhile(i -> {
            if (i < 3) {
                return true;
            }
            if (i == 4) {
                throw new RuntimeException("4 was passed");
            }
            return false;
        }).toList().run(this.getEngine()))), Arrays.asList(3, 4));
    }

    @Test
    public void dropWhileStageShouldAllowCompletionWhileDropping() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 1, 1, 1}).dropWhile(i -> i < 3).toList().run(this.getEngine()))), Collections.emptyList());
    }

    @Test
    public void dropWhileStageShouldPropagateCancel() {
        CompletableFuture cancelled = new CompletableFuture();
        this.await(this.infiniteStream().onTerminate(() -> cancelled.complete(null)).dropWhile(i -> i < 3).cancel().run(this.getEngine()));
        this.await(cancelled);
    }

    @Test
    public void dropWhileStageBuilderShouldBeReusable() {
        ProcessorBuilder dropWhile = this.rs.builder().dropWhile(i -> i < 3);
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3, 4}).via(dropWhile).toList().run(this.getEngine()))), Arrays.asList(3, 4));
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{0, 1, 6, 7}).via(dropWhile).toList().run(this.getEngine()))), Arrays.asList(6, 7));
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Collections.singletonList(new ProcessorVerification());
    }

    class ProcessorVerification
    extends AbstractStageVerification.StageProcessorVerification<Integer> {
        ProcessorVerification() {
        }

        public Processor<Integer, Integer> createIdentityProcessor(int bufferSize) {
            return DropWhileStageVerification.this.rs.builder().dropWhile(i -> false).buildRs(DropWhileStageVerification.this.getEngine());
        }

        @Override
        public Publisher<Integer> createFailedPublisher() {
            return DropWhileStageVerification.this.rs.failed((Throwable)new RuntimeException("failed")).dropWhile(i -> false).buildRs(DropWhileStageVerification.this.getEngine());
        }

        public Integer createElement(int element) {
            return element;
        }
    }
}

