/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreamsFactory;
import org.eclipse.microprofile.reactive.streams.operators.spi.Graph;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;
import org.eclipse.microprofile.reactive.streams.operators.tck.api.AbstractReactiveStreamsApiVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.api.Mocks;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReactiveStreamsVerification
extends AbstractReactiveStreamsApiVerification {
    public ReactiveStreamsVerification(ReactiveStreamsFactory rs) {
        super(rs);
    }

    @Test
    public void fromPublisher() {
        Graph graph = this.graphFor(this.rs.fromPublisher(Mocks.PUBLISHER));
        Assert.assertSame((Object)this.getStage(Stage.PublisherStage.class, graph).getRsPublisher(), (Object)Mocks.PUBLISHER);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void fromPublisherNull() {
        this.rs.fromPublisher(null);
    }

    @Test
    public void ofSingle() {
        Graph graph = this.graphFor(this.rs.of((Object)"foo"));
        Assert.assertEquals((Iterable)this.getStage(Stage.Of.class, graph).getElements(), Collections.singletonList("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void ofSingleNull() {
        this.rs.of(null);
    }

    @Test
    public void ofVarArgs() {
        Graph graph = this.graphFor(this.rs.of((Object[])new String[]{"a", "b", "c"}));
        Assert.assertEquals((Iterable)this.getStage(Stage.Of.class, graph).getElements(), Arrays.asList("a", "b", "c"));
    }

    @Test
    public void empty() {
        Graph graph = this.graphFor(this.rs.empty());
        this.assertEmptyStage((Stage)this.getStage(Stage.Of.class, graph));
    }

    @Test
    public void ofNullableNull() {
        Graph graph = this.graphFor(this.rs.ofNullable(null));
        this.assertEmptyStage((Stage)this.getStage(Stage.Of.class, graph));
    }

    @Test
    public void ofNullableNonNull() {
        Graph graph = this.graphFor(this.rs.ofNullable((Object)"foo"));
        Assert.assertEquals((Iterable)this.getStage(Stage.Of.class, graph).getElements(), Collections.singletonList("foo"));
    }

    @Test
    public void fromIterable() {
        Graph graph = this.graphFor(this.rs.fromIterable(Arrays.asList("a", "b", "c")));
        Assert.assertEquals((Iterable)this.getStage(Stage.Of.class, graph).getElements(), Arrays.asList("a", "b", "c"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void fromIterableNull() {
        this.rs.fromIterable(null);
    }

    @Test
    public void failed() {
        Graph graph = this.graphFor(this.rs.failed((Throwable)new Exception("failed")));
        Assert.assertEquals((String)this.getStage(Stage.Failed.class, graph).getError().getMessage(), (String)"failed");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void failedNull() {
        this.rs.failed(null);
    }

    @Test
    public void builder() {
        Graph graph = this.graphFor(this.rs.builder());
        Assert.assertEquals((Collection)graph.getStages(), Collections.emptyList(), (String)"Identity builder should have an empty list of stages");
    }

    @Test
    public void fromProcessor() {
        Graph graph = this.graphFor(this.rs.fromProcessor(Mocks.PROCESSOR));
        Assert.assertSame((Object)this.getStage(Stage.ProcessorStage.class, graph).getRsProcessor(), (Object)Mocks.PROCESSOR);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void fromProcessorNull() {
        this.rs.fromProcessor(null);
    }

    @Test
    public void fromSubscriber() {
        Graph graph = this.graphFor(this.rs.fromSubscriber(Mocks.SUBSCRIBER));
        Assert.assertSame((Object)this.getStage(Stage.SubscriberStage.class, graph).getRsSubscriber(), (Object)Mocks.SUBSCRIBER);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void fromSubscriberNull() {
        this.rs.fromSubscriber(null);
    }

    @Test
    public void iterate() {
        Graph graph = this.graphFor(this.rs.iterate((Object)1, i -> i + 1));
        Iterator iter = this.getStage(Stage.Of.class, graph).getElements().iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals(iter.next(), (Object)1);
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals(iter.next(), (Object)2);
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals(iter.next(), (Object)3);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void iterateNullOperator() {
        this.rs.iterate((Object)1, null);
    }

    @Test
    public void generate() {
        Graph graph = this.graphFor(this.rs.generate(() -> 1));
        Iterator iter = this.getStage(Stage.Of.class, graph).getElements().iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals(iter.next(), (Object)1);
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals(iter.next(), (Object)1);
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals(iter.next(), (Object)1);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void generateNullSupplier() {
        this.rs.generate(null);
    }

    @Test
    public void concat() {
        Graph graph = this.graphFor(this.rs.concat(this.rs.empty(), this.rs.of((Object)1)));
        Stage.Concat concat = this.getStage(Stage.Concat.class, graph);
        this.assertEmptyStage((Stage)this.getStage(Stage.Of.class, concat.getFirst()));
        Assert.assertEquals((Iterable)this.getStage(Stage.Of.class, concat.getSecond()).getElements(), Collections.singletonList(1));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void concatFirstNull() {
        this.rs.concat(null, this.rs.empty());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void concatSecondNull() {
        this.rs.concat(this.rs.empty(), null);
    }

    @Test
    public void fromCompletionStage() {
        CompletableFuture<Integer> future = CompletableFuture.completedFuture(1);
        Graph graph = this.graphFor(this.rs.fromCompletionStage(future));
        Stage.FromCompletionStage fromCompletionStage = this.getStage(Stage.FromCompletionStage.class, graph);
        Assert.assertSame((Object)fromCompletionStage.getCompletionStage(), future);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void fromCompletionStageNull() {
        this.rs.fromCompletionStage(null);
    }

    @Test
    public void fromCompletionStageNullable() {
        CompletableFuture<Integer> future = CompletableFuture.completedFuture(1);
        Graph graph = this.graphFor(this.rs.fromCompletionStageNullable(future));
        Stage.FromCompletionStageNullable fromCompletionStage = this.getStage(Stage.FromCompletionStageNullable.class, graph);
        Assert.assertSame((Object)fromCompletionStage.getCompletionStage(), future);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void fromCompletionStageNullableNull() {
        this.rs.fromCompletionStageNullable(null);
    }

    @Test
    public void coupled() {
        Graph graph = this.graphFor(this.rs.coupled(this.rs.builder().cancel(), this.rs.empty()));
        Stage.Coupled coupled = this.getStage(Stage.Coupled.class, graph);
        this.getStage(Stage.Cancel.class, coupled.getSubscriber());
        this.assertEmptyStage((Stage)this.getStage(Stage.Of.class, coupled.getPublisher()));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void coupledSubscriberNull() {
        this.rs.coupled(null, this.rs.empty());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void coupledPubisherNull() {
        this.rs.coupled(this.rs.builder().cancel(), null);
    }

    @Test
    public void coupledRs() {
        Graph graph = this.graphFor(this.rs.coupled(Mocks.SUBSCRIBER, Mocks.PUBLISHER));
        Stage.Coupled coupled = this.getStage(Stage.Coupled.class, graph);
        Assert.assertSame((Object)this.getStage(Stage.SubscriberStage.class, coupled.getSubscriber()).getRsSubscriber(), (Object)Mocks.SUBSCRIBER);
        Assert.assertSame((Object)this.getStage(Stage.PublisherStage.class, coupled.getPublisher()).getRsPublisher(), (Object)Mocks.PUBLISHER);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void coupledRsSubscriberNull() {
        this.rs.coupled(null, Mocks.PUBLISHER);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void coupledRsPubisherNull() {
        this.rs.coupled(Mocks.SUBSCRIBER, null);
    }

    private <S extends Stage> S getStage(Class<S> clazz, Graph graph) {
        Assert.assertEquals((int)graph.getStages().size(), (int)1, (String)"Graph does not have a single stage");
        Stage s = (Stage)graph.getStages().iterator().next();
        Assert.assertTrue((boolean)clazz.isInstance(s), (String)("Stage " + s + " is not a " + clazz));
        return (S)((Stage)clazz.cast(s));
    }
}

