/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.api;

import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.eclipse.microprofile.reactive.streams.operators.spi.Graph;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;
import org.eclipse.microprofile.reactive.streams.operators.spi.ToGraphable;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class Mocks {
    static final Graph EMPTY_PUBLISHER_GRAPH = new GraphImpl(Collections.singleton(Collections::emptyList));
    static final Graph SUBSCRIBER_GRAPH = new GraphImpl(Arrays.asList(new Stage.Distinct(){}, new Stage.Cancel(){}));
    static final Graph PROCESSOR_GRAPH = new GraphImpl(Arrays.asList(new Stage.Distinct(){}, () -> 5L));
    static final Subscriber SUBSCRIBER = new Subscriber(){

        public void onSubscribe(Subscription s) {
        }

        public void onNext(Object o) {
        }

        public void onError(Throwable t) {
        }

        public void onComplete() {
        }
    };
    static final Publisher PUBLISHER = s -> {};
    static final Processor PROCESSOR = new Processor(){

        public void subscribe(Subscriber s) {
        }

        public void onSubscribe(Subscription s) {
        }

        public void onNext(Object o) {
        }

        public void onError(Throwable t) {
        }

        public void onComplete() {
        }
    };
    static final Subscription SUBSCRIPTION = new Subscription(){

        public void request(long n) {
        }

        public void cancel() {
        }
    };
    static final PublisherBuilder EMPTY_PUBLISHER_BUILDER = (PublisherBuilder)Proxy.newProxyInstance(Mocks.class.getClassLoader(), new Class[]{PublisherBuilder.class, ToGraphable.class}, (obj, method, args) -> {
        if (method.getName().equals("toGraph")) {
            return EMPTY_PUBLISHER_GRAPH;
        }
        return null;
    });
    static final ProcessorBuilder PROCESSOR_BUILDER = (ProcessorBuilder)Proxy.newProxyInstance(Mocks.class.getClassLoader(), new Class[]{ProcessorBuilder.class, ToGraphable.class}, (obj, method, args) -> {
        if (method.getName().equals("toGraph")) {
            return PROCESSOR_GRAPH;
        }
        return null;
    });
    static final SubscriberBuilder SUBSCRIBER_BUILDER = (SubscriberBuilder)Proxy.newProxyInstance(Mocks.class.getClassLoader(), new Class[]{SubscriberBuilder.class, ToGraphable.class}, (obj, method, args) -> {
        if (method.getName().equals("toGraph")) {
            return SUBSCRIBER_GRAPH;
        }
        return null;
    });

    private Mocks() {
    }

    private static final class GraphImpl
    implements Graph {
        private final Collection<Stage> stages;

        private GraphImpl(Collection<Stage> stages) {
            this.stages = stages;
        }

        public Collection<Stage> getStages() {
            return this.stages;
        }
    }
}

