/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.config;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.microprofile.jwt.tck.config.PEMApplication;
import org.eclipse.microprofile.jwt.tck.config.PublicKeyEndpoint;
import org.eclipse.microprofile.jwt.tck.config.SimpleTokenUtils;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.Test;

public class PublicKeyAsPEMLocationURLTest
extends Arquillian {
    @ArquillianResource
    private URL baseURL;

    @Deployment
    public static WebArchive createLocationURLDeployment() throws IOException {
        URL publicKey = PublicKeyAsPEMLocationURLTest.class.getResource("/publicKey4k.pem");
        Properties configProps = new Properties();
        String jwksBaseURL = System.getProperty("mp.jwt.tck.jwks.baseURL", "http://localhost:8080/");
        System.out.printf("baseURL=%s\n", jwksBaseURL);
        URL pemURL = new URL(new URL(jwksBaseURL), "pem/endp/publicKey4k");
        System.out.printf("pemURL=%s\n", pemURL);
        configProps.setProperty("mp.jwt.verify.publickey.location", pemURL.toExternalForm());
        configProps.setProperty("mp.jwt.verify.issuer", "https://server.example.com");
        StringWriter configSW = new StringWriter();
        configProps.store(configSW, "PublicKeyAsPEMLocationURLTest microprofile-config.properties");
        StringAsset configAsset = new StringAsset(configSW.toString());
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"PublicKeyAsPEMLocationURLTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_1.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey4k.pem")).addAsResource(publicKey, "/publicKey.pem")).addClass(PublicKeyEndpoint.class)).addClass(PEMApplication.class)).addClass(SimpleTokenUtils.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource((Asset)configAsset, "microprofile-config.properties");
        System.out.printf("WebArchive: %s\n", webArchive.toString(true));
        return webArchive;
    }

    @RunAsClient
    @Test(groups={"config"}, description="Validate the http://localhost:8080/pem/endp/publicKey4k PEM endpoint")
    public void validateLocationUrlContents() throws Exception {
        URL locationURL = new URL(this.baseURL, "pem/endp/publicKey4k");
        Reporter.log((String)"Begin validateLocationUrlContents");
        StringWriter content = new StringWriter();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(locationURL.openStream()));){
            String line = reader.readLine();
            while (line != null) {
                content.write(line);
                content.write(10);
                line = reader.readLine();
            }
        }
        Reporter.log((String)("Received: " + content));
        String expected = TokenUtils.readResource((String)"/publicKey4k.pem");
        Assert.assertEquals((String)content.toString(), (String)expected);
    }

    @RunAsClient
    @Test(groups={"config"}, dependsOnMethods={"validateLocationUrlContents"}, description="Validate specifying the mp.jwt.verify.publickey.location as remote URL to a PEM key")
    public void testKeyAsLocationUrl() throws Exception {
        Reporter.log((String)"testKeyAsLocationUrl, expect HTTP_OK");
        RSAPrivateKey privateKey = TokenUtils.readPrivateKey((String)"/privateKey4k.pem");
        String kid = "/privateKey4k.pem";
        HashMap timeClaims = new HashMap();
        String token = TokenUtils.generateTokenString((PrivateKey)privateKey, (String)kid, (String)"/Token1.json", null, timeClaims);
        String uri = this.baseURL.toExternalForm() + "pem/endp/verifyKeyLocationAsPEMUrl";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }
}

