/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.mft.ecoretools.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.ui.IContextUiStartup;
import org.eclipse.mylyn.internal.mft.ecoretools.ui.EcoreDiagramUiBridge;
import org.eclipse.mylyn.internal.mft.ecoretools.ui.EcoreToolsNavigatorUiBridge;
import org.eclipse.mylyn.mft.emf.core.EmfStructureBridge;
import org.eclipse.mylyn.mft.emf.ui.DiagramUiBridge;
import org.eclipse.mylyn.mft.emf.ui.DiagramUiEditingMonitor;
import org.eclipse.mylyn.monitor.ui.AbstractUserInteractionMonitor;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EcoreUiBridgePlugin
extends AbstractUIPlugin {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.modeling.ecoretools";
    private static EcoreUiBridgePlugin INSTANCE;
    private DiagramUiEditingMonitor diagramMonitor;
    private AbstractUserInteractionMonitor navigatorMonitor;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
    }

    private void lazyStart() {
        AbstractContextStructureBridge structureBridge = ContextCore.getStructureBridge((String)"ecore");
        if (structureBridge instanceof EmfStructureBridge) {
            EmfStructureBridge bridge = (EmfStructureBridge)structureBridge;
            this.diagramMonitor = new DiagramUiEditingMonitor((AbstractContextStructureBridge)bridge, (DiagramUiBridge)EcoreDiagramUiBridge.getInstance());
            MonitorUi.getSelectionMonitors().add(this.diagramMonitor);
            this.navigatorMonitor = new DiagramUiEditingMonitor((AbstractContextStructureBridge)bridge, (DiagramUiBridge)EcoreToolsNavigatorUiBridge.getInstance());
            MonitorUi.getSelectionMonitors().add(this.navigatorMonitor);
        } else {
            StatusHandler.log((IStatus)new Status(2, ID_PLUGIN, "Couldn't load EMFStructure Bridge for ecore"));
        }
    }

    private void lazyStop() {
        if (this.diagramMonitor != null) {
            MonitorUi.getSelectionMonitors().remove(this.diagramMonitor);
            MonitorUi.getSelectionMonitors().remove(this.navigatorMonitor);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.lazyStop();
        super.stop(context);
        INSTANCE = null;
    }

    public static EcoreUiBridgePlugin getDefault() {
        return INSTANCE;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID_PLUGIN, (String)path);
    }

    public static class EcoreDiagramBridgeStartup
    implements IContextUiStartup {
        public void lazyStartup() {
            EcoreUiBridgePlugin.getDefault().lazyStart();
        }
    }
}

