/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.common.internal.util.JarUtilities;
import org.eclipse.jst.jsf.designtime.internal.resources.IJSFResource;
import org.eclipse.jst.jsf.designtime.internal.resources.IJSFResourceContainer;
import org.eclipse.jst.jsf.designtime.internal.resources.IJSFResourceFragment;
import org.eclipse.jst.jsf.designtime.internal.resources.IJarBasedJSFResource;
import org.eclipse.jst.jsf.designtime.internal.resources.IWorkspaceJSFResourceFragment;
import org.eclipse.jst.jsf.designtime.internal.resources.WorkspaceJSFResourceContainer;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.AbstractFaceletTaglibLocator;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.FaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IFaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.Listener;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglibFactory;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglibTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFResourceBasedTagRecord
extends FaceletTagRecord {
    private final List<FaceletTaglibTag> _tags;
    private final String _uri;
    private static final long serialVersionUID = 5944923828112777373L;

    public JSFResourceBasedTagRecord(String uri, List<FaceletTaglibTag> tags, IFaceletTagRecord.TagRecordDescriptor descriptor) {
        super(descriptor);
        this._uri = uri;
        this._tags = tags;
    }

    @Override
    public int getNumTags() {
        return this._tags.size();
    }

    @Override
    public String getURI() {
        return this._uri;
    }

    @Override
    public FaceletTaglibTag getTag(String name) {
        for (FaceletTaglibTag tag : this._tags) {
            if (!tag.getTagName().equals(name)) continue;
            return tag;
        }
        return null;
    }

    @Override
    public Collection<? extends FaceletTaglibTag> getTags() {
        return Collections.unmodifiableCollection(this._tags);
    }

    JSFResourceBasedTagRecord mergeTags(List<FaceletTaglibTag> withThese) {
        ArrayList<FaceletTaglibTag> tags = new ArrayList<FaceletTaglibTag>(this._tags);
        for (FaceletTaglibTag mergeTag : withThese) {
            FaceletTaglibTag tag = this.getTag(mergeTag.getTagName());
            if (tag != null) {
                tags.remove(tag);
            }
            tags.add(mergeTag);
        }
        return new JSFResourceBasedTagRecord(this._uri, tags, this.getDescriptor());
    }

    JSFResourceBasedTagRecord removeTags(List<FaceletTaglibTag> removeThese) {
        ArrayList<FaceletTaglibTag> tags = new ArrayList<FaceletTaglibTag>(this._tags);
        for (FaceletTaglibTag mergeTag : removeThese) {
            FaceletTaglibTag tag = this.getTag(mergeTag.getTagName());
            if (tag == null) continue;
            tags.remove(tag);
        }
        return new JSFResourceBasedTagRecord(this._uri, tags, this.getDescriptor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private static final LibEntry WHOLE_LIBRARY = new LibEntry(null);
        private static final JSFResourceBasedTagRecord WHOLE_LIB_RECORD = new JSFResourceBasedTagRecord(null, Collections.EMPTY_LIST, null);
        private final Map<String, LibEntry> _tags = new HashMap<String, LibEntry>();
        private static final String FACELET_FILE_CONTENT_TYPE = "org.eclipse.wst.html.core.htmlsource";
        private static final String[] COMPOSITE_LIB_NS_PREFIXES = new String[]{"http://java.sun.com/jsf/composite/", "http://xmlns.jcp.org/jsf/composite/"};

        public void addTag(IJSFResource jsfResource, Listener.TaglibChangedEvent.CHANGE_TYPE changeType) {
            String libraryName = jsfResource.getId().getLibraryName();
            if (libraryName == null) {
                return;
            }
            String[] stringArray = COMPOSITE_LIB_NS_PREFIXES;
            int n = COMPOSITE_LIB_NS_PREFIXES.length;
            int n2 = 0;
            while (n2 < n) {
                String nsPrefix = stringArray[n2];
                String uri = String.format("%s%s", nsPrefix, libraryName);
                LibEntry tags = this._tags.get(uri);
                if (tags == null) {
                    tags = new LibEntry(this.createDescriptor((IJSFResourceFragment)jsfResource));
                    this._tags.put(uri, tags);
                }
                String resourceName = jsfResource.getId().getResourceName();
                IPath resourceNamePath = new Path(resourceName).removeFileExtension();
                FaceletTaglibTag tag = FaceletTaglibFactory.eINSTANCE.createFaceletTaglibTag();
                tag.setTagName(resourceNamePath.toString());
                switch (changeType) {
                    case ADDED: 
                    case CHANGED: {
                        if (!jsfResource.isContentType(FACELET_FILE_CONTENT_TYPE) || !jsfResource.isAccessible()) break;
                        tags.addTag(tag);
                        break;
                    }
                    case REMOVED: {
                        tags.addTag(tag);
                    }
                }
                ++n2;
            }
        }

        public void addLibrary(IJSFResourceContainer jsfResource, Listener.TaglibChangedEvent.CHANGE_TYPE changeType) {
            String libraryName = jsfResource.getId().getLibraryName();
            if (libraryName == null || libraryName.trim().length() == 0) {
                return;
            }
            String[] stringArray = COMPOSITE_LIB_NS_PREFIXES;
            int n = COMPOSITE_LIB_NS_PREFIXES.length;
            int n2 = 0;
            while (n2 < n) {
                String nsPrefix = stringArray[n2];
                String uri = String.format("%s%s", nsPrefix, libraryName);
                if (changeType == Listener.TaglibChangedEvent.CHANGE_TYPE.REMOVED) {
                    this._tags.put(uri, WHOLE_LIBRARY);
                } else {
                    LibEntry tags = this._tags.get(uri);
                    if (tags == null) {
                        tags = new LibEntry(this.createDescriptor((IJSFResourceFragment)jsfResource));
                        this._tags.put(uri, tags);
                    }
                }
                ++n2;
            }
        }

        public Map<String, JSFResourceBasedTagRecord> build() {
            HashMap<String, JSFResourceBasedTagRecord> records = new HashMap<String, JSFResourceBasedTagRecord>();
            for (Map.Entry<String, LibEntry> entry : this._tags.entrySet()) {
                if (entry.getValue() == WHOLE_LIBRARY) {
                    records.put(entry.getKey(), WHOLE_LIB_RECORD);
                    continue;
                }
                String uri = entry.getKey();
                ArrayList<FaceletTaglibTag> tags = new ArrayList<FaceletTaglibTag>(entry.getValue().getTags());
                IFaceletTagRecord.TagRecordDescriptor descriptor = entry.getValue().getDescriptor();
                JSFResourceBasedTagRecord newRecord = new JSFResourceBasedTagRecord(uri, tags, descriptor);
                records.put(entry.getKey(), newRecord);
            }
            return records;
        }

        public List<Listener.TaglibChangedEvent> createMerge(AbstractFaceletTaglibLocator locator, Map<String, JSFResourceBasedTagRecord> records) {
            Map<String, JSFResourceBasedTagRecord> newRecords = this.build();
            ArrayList<Listener.TaglibChangedEvent> mergeEvents = new ArrayList<Listener.TaglibChangedEvent>();
            for (Map.Entry<String, JSFResourceBasedTagRecord> entry : newRecords.entrySet()) {
                Listener.TaglibChangedEvent event = null;
                if (!records.containsKey(entry.getKey())) {
                    event = new Listener.TaglibChangedEvent(locator, null, entry.getValue(), Listener.TaglibChangedEvent.CHANGE_TYPE.ADDED);
                } else {
                    JSFResourceBasedTagRecord oldRecord = records.get(entry.getKey());
                    JSFResourceBasedTagRecord newRecord = oldRecord.mergeTags(entry.getValue()._tags);
                    event = new Listener.TaglibChangedEvent(locator, oldRecord, newRecord, Listener.TaglibChangedEvent.CHANGE_TYPE.CHANGED);
                }
                mergeEvents.add(event);
            }
            return mergeEvents;
        }

        public List<Listener.TaglibChangedEvent> createRemove(AbstractFaceletTaglibLocator locator, Map<String, JSFResourceBasedTagRecord> records) {
            Map<String, JSFResourceBasedTagRecord> newRecords = this.build();
            ArrayList<Listener.TaglibChangedEvent> mergeEvents = new ArrayList<Listener.TaglibChangedEvent>();
            for (Map.Entry<String, JSFResourceBasedTagRecord> entry : newRecords.entrySet()) {
                Listener.TaglibChangedEvent event = null;
                JSFResourceBasedTagRecord oldRecord = records.get(entry.getKey());
                if (oldRecord != null) {
                    JSFResourceBasedTagRecord record = entry.getValue();
                    if (record == WHOLE_LIB_RECORD) {
                        event = new Listener.TaglibChangedEvent(locator, oldRecord, null, Listener.TaglibChangedEvent.CHANGE_TYPE.REMOVED);
                    } else {
                        JSFResourceBasedTagRecord newRecord = oldRecord.removeTags(entry.getValue()._tags);
                        event = new Listener.TaglibChangedEvent(locator, oldRecord, newRecord, Listener.TaglibChangedEvent.CHANGE_TYPE.CHANGED);
                    }
                }
                if (event == null) continue;
                mergeEvents.add(event);
            }
            return mergeEvents;
        }

        public Map<String, JSFResourceBasedTagRecord> merge(List<Listener.TaglibChangedEvent> events, Map<String, JSFResourceBasedTagRecord> withThese) {
            HashMap<String, JSFResourceBasedTagRecord> newMap = new HashMap<String, JSFResourceBasedTagRecord>(withThese);
            for (Listener.TaglibChangedEvent event : events) {
                switch (event.getChangeType()) {
                    case ADDED: 
                    case CHANGED: {
                        IFaceletTagRecord newRecord = event.getNewValue();
                        if (!(newRecord instanceof JSFResourceBasedTagRecord)) break;
                        newMap.put(newRecord.getURI(), (JSFResourceBasedTagRecord)newRecord);
                        break;
                    }
                    case REMOVED: {
                        IFaceletTagRecord oldRecord = event.getOldValue();
                        if (oldRecord == null) break;
                        newMap.remove(oldRecord.getURI());
                    }
                }
            }
            return newMap;
        }

        private IFaceletTagRecord.TagRecordDescriptor createDescriptor(IJSFResourceFragment resource) {
            URL jarURL;
            File file;
            if (resource instanceof IWorkspaceJSFResourceFragment) {
                if (resource instanceof WorkspaceJSFResourceContainer) {
                    IContainer res = ((WorkspaceJSFResourceContainer)resource).getResource();
                    return new IFaceletTagRecord.WorkspaceTagRecordDescriptor((IFolder)res);
                }
                IResource res = ((IWorkspaceJSFResourceFragment)resource).getResource();
                return new IFaceletTagRecord.WorkspaceTagRecordDescriptor((IFile)res);
            }
            if (resource instanceof IJarBasedJSFResource && (file = JarUtilities.INSTANCE.getFile(jarURL = ((IJarBasedJSFResource)resource).getJarURL())) != null) {
                String absolutePath = file.getAbsolutePath();
                String jarEntryName = ((IJarBasedJSFResource)resource).getJarEntryName();
                return new IFaceletTagRecord.JarTagRecordDescriptor((IPath)new Path(absolutePath), jarEntryName);
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class LibEntry {
            private final IFaceletTagRecord.TagRecordDescriptor _descriptor;
            private final List<FaceletTaglibTag> _tags;

            public LibEntry(IFaceletTagRecord.TagRecordDescriptor descriptor) {
                this._descriptor = descriptor;
                this._tags = new ArrayList<FaceletTaglibTag>();
            }

            public IFaceletTagRecord.TagRecordDescriptor getDescriptor() {
                return this._descriptor;
            }

            public void addTag(FaceletTaglibTag tag) {
                this._tags.add(tag);
            }

            public List<FaceletTaglibTag> getTags() {
                return Collections.unmodifiableList(this._tags);
            }
        }
    }
}

