/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.dispatching.teditor.validation;

import activity.Activity;
import activity.ActivityPackage;
import activity.Claim;
import activity.Event;
import activity.JitBounds;
import activity.LocationPrerequisite;
import activity.Move;
import activity.TimeBounds;
import activity.util.ActivityParametersUtil;
import activity.util.EventSequenceValidator;
import com.google.common.collect.Iterables;
import common.CommonPackage;
import common.HasName;
import common.Import;
import common.Parameter;
import common.ParameterReference;
import common.TypeDefinition;
import dispatching.ActivityDispatching;
import dispatching.Attribute;
import dispatching.Constraint;
import dispatching.Dispatch;
import dispatching.DispatchGroup;
import dispatching.DispatchingPackage;
import dispatching.impl.AttributesMapEntryImpl;
import dispatching.util.DispatchingUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import machine.ActionType;
import machine.IResource;
import machine.Peripheral;
import machine.Resource;
import machine.SymbolicPosition;
import machine.util.ResourcePeripheralKey;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.lsat.common.graph.directed.editable.EdgQueries;
import org.eclipse.lsat.common.queries.QueryableIterable;
import org.eclipse.lsat.common.xtend.Queries;
import org.eclipse.lsat.dispatching.teditor.validation.AbstractDispatchingValidator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class DispatchingValidator
extends AbstractDispatchingValidator {
    public static final String GREATER_OFFSET = "greaterOffset";
    public static final String INVALID_IMPORT = "invalidImport";
    public static final String REMOVE_ITEM = "removeItem";
    public static final String SELECT_ITEM_FOR_RESOURCE = "selectItemForResource";
    public static final String REPLACE_ITEM_FOR_RESOURCE = "replaceItemForResource";
    public static final String CONVERT_YIELD = "convertYield";
    public static final String CONSTRAINT_DISPATCH_NAME = "constraintDispatchName";
    public static final String CONSTRAINT_LIMITS = "constraintLimits";

    @Check
    public void checkObsoleteThroughput(ActivityDispatching ad) {
        boolean _eIsSet = ad.eIsSet((EStructuralFeature)DispatchingPackage.Literals.ACTIVITY_DISPATCHING__NUMBER_OF_ITERATIONS);
        if (_eIsSet) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Througput is obsolete. Specify yield below in activities");
            this.warning(_builder.toString(), (EObject)ad, (EStructuralFeature)DispatchingPackage.Literals.ACTIVITY_DISPATCHING__NUMBER_OF_ITERATIONS, CONVERT_YIELD, new String[0]);
        }
        int i = 0;
        while (i < ad.getResourceIterations().size()) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Througput is obsolete. Specify yield below in activities");
            this.warning(_builder_1.toString(), (EObject)ad, (EStructuralFeature)DispatchingPackage.Literals.ACTIVITY_DISPATCHING__RESOURCE_ITERATIONS, i, CONVERT_YIELD, new String[0]);
            ++i;
        }
    }

    @Check
    public void checkDuplicateDispatchGroup(ActivityDispatching ad) {
        Functions.Function1 _function = it -> it.eIsSet((EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__NAME);
        Functions.Function1 _function_1 = it -> it.getName();
        Functions.Function1 _function_2 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<DispatchGroup> _function_3 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Duplicate dispatch group name  '");
            String _name = it.getName();
            _builder.append(_name);
            _builder.append("' Rename one");
            this.error(_builder.toString(), (EObject)ad, (EStructuralFeature)DispatchingPackage.Literals.ACTIVITY_DISPATCHING__DISPATCH_GROUPS, ad.getDispatchGroups().indexOf(it));
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)IterableExtensions.filter((Iterable)ad.getDispatchGroups(), (Functions.Function1)_function), (Functions.Function1)_function_1).values(), (Functions.Function1)_function_2)).forEach(_function_3);
    }

    @Check
    public void checkImportIsValid(Import imp) {
        try {
            boolean isUnderstood;
            boolean isImportUriValid = EcoreUtil2.isValidUri((EObject)imp, (URI)URI.createURI((String)imp.getImportURI()));
            if (!isImportUriValid) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("The import ");
                String _importURI = imp.getImportURI();
                _builder.append(_importURI);
                _builder.append(" cannot be resolved. Make sure that the name is spelled correctly.");
                this.error(_builder.toString(), (EObject)imp, (EStructuralFeature)CommonPackage.Literals.IMPORT__IMPORT_URI, INVALID_IMPORT, new String[0]);
            }
            if (!(isUnderstood = imp.getImportURI().matches(".*\\.(activity)"))) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Importing ");
                String _importURI_1 = imp.getImportURI();
                _builder_1.append(_importURI_1);
                _builder_1.append(" is not allowed. Only 'activity' files are allowed");
                this.error(_builder_1.toString(), (EObject)imp, (EStructuralFeature)CommonPackage.Literals.IMPORT__IMPORT_URI, INVALID_IMPORT, new String[0]);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("The import ");
                String _importURI_2 = imp.getImportURI();
                _builder_2.append(_importURI_2);
                _builder_2.append(" is not a valid URI.");
                this.error(_builder_2.toString(), (EObject)imp, (EStructuralFeature)CommonPackage.Literals.IMPORT__IMPORT_URI, INVALID_IMPORT, new String[0]);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    @Check
    public void checkOffsetShouldBeGreaterThanPrevious(ActivityDispatching activityDispatching) {
        EList dispatchGroups = activityDispatching.getDispatchGroups();
        int i = 1;
        while (i < dispatchGroups.size()) {
            BigDecimal _offset_1;
            boolean _lessThan;
            BigDecimal _offset = ((DispatchGroup)dispatchGroups.get(i)).getOffset();
            boolean bl = _lessThan = _offset.compareTo(_offset_1 = ((DispatchGroup)dispatchGroups.get(i - 1)).getOffset()) < 0;
            if (_lessThan) {
                this.error("Offset should be greater then previously defined offset", (EObject)dispatchGroups.get(i), (EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__OFFSET, GREATER_OFFSET, new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void validateAttributesDuplicate(Dispatch dis) {
        Functions.Function1 _function = it -> ((Attribute)it.getKey()).getName();
        Functions.Function1 _function_1 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<Map.Entry> _function_2 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Duplicate item specified for Attribute '");
            String _name = ((Attribute)it.getKey()).getName();
            _builder.append(_name);
            _builder.append("' Remove one");
            this.error(_builder.toString(), (EObject)dis, (EStructuralFeature)DispatchingPackage.Literals.HAS_USER_ATTRIBUTES__USER_ATTRIBUTES, dis.getUserAttributes().indexOf(it), REMOVE_ITEM, new String[0]);
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)dis.getUserAttributes(), (Functions.Function1)_function).values(), (Functions.Function1)_function_1)).forEach(_function_2);
    }

    @Check
    public void validateAttributeValue(AttributesMapEntryImpl entry) {
        boolean _not;
        boolean _tripleEquals;
        String _value = entry.getValue();
        boolean bl = _tripleEquals = _value == null;
        if (_tripleEquals) {
            return;
        }
        String illegalChars = entry.getValue().replaceAll("[\\w\\.\\-\\s]", "");
        boolean _isEmpty = illegalChars.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            Dispatch parent = (Dispatch)EcoreUtil2.getContainerOfType((EObject)entry, Dispatch.class);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Attribute value may not contain  '");
            _builder.append(illegalChars);
            _builder.append("'. only 'a-zA-Z0-9-_.<space><tab>' are allowed ");
            this.error(_builder.toString(), (EObject)parent, (EStructuralFeature)DispatchingPackage.Literals.HAS_USER_ATTRIBUTES__USER_ATTRIBUTES, parent.getUserAttributes().indexOf((Object)entry), REMOVE_ITEM, new String[0]);
        }
    }

    @Check
    public void validatePosition(ActivityDispatching activityDispatching) {
        boolean hasParameters;
        LinkedHashMap positionState = CollectionLiterals.newLinkedHashMap();
        Functions.Function1 _function = it -> it.getDispatches();
        Functions.Function1 _function_1 = it -> {
            boolean _isEmpty = it.getParameters().isEmpty();
            return !_isEmpty;
        };
        Dispatch _findFirst = (Dispatch)IterableExtensions.findFirst((Iterable)IterableExtensions.flatMap((Iterable)activityDispatching.getDispatchGroups(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        boolean bl = hasParameters = _findFirst != null;
        if (hasParameters) {
            return;
        }
        Consumer<DispatchGroup> _function_2 = dispatchGroup -> {
            Procedures.Procedure2 _function_3 = (disp, index) -> {
                Activity activity = disp.getActivity();
                LinkedHashMap<ResourcePeripheralKey, SymbolicPosition> locationPrerequisites = this.indexPrerequisites((Dispatch)disp, (int)index);
                Set<Map.Entry<ResourcePeripheralKey, SymbolicPosition>> _entrySet = locationPrerequisites.entrySet();
                for (Map.Entry<ResourcePeripheralKey, SymbolicPosition> prerequisite : _entrySet) {
                    SymbolicPosition _value;
                    PositionInfo _positionInfo;
                    ResourcePeripheralKey _key = prerequisite.getKey();
                    PositionInfo positionInfo = positionState.put(_key, _positionInfo = new PositionInfo(_value = prerequisite.getValue(), activity));
                    if (positionInfo == null || positionInfo.position.equals(prerequisite.getValue())) continue;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Activity ");
                    String _name = activity.getName();
                    _builder.append(_name);
                    _builder.append(" requires peripheral ");
                    String _fqn = prerequisite.getKey().fqn();
                    _builder.append(_fqn);
                    _builder.append(" at position ");
                    String _name_1 = prerequisite.getValue().getName();
                    _builder.append(_name_1);
                    _builder.append(", but activity ");
                    String _name_2 = positionInfo.activity.getName();
                    _builder.append(_name_2);
                    _builder.append(" leaves it at position ");
                    String _name_3 = positionInfo.position.getName();
                    _builder.append(_name_3);
                    this.warning(_builder.toString(), (EObject)disp, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH__ACTIVITY);
                }
                EList topologicalOrder = EdgQueries.topologicalOrdering((Iterable)activity.getNodes());
                if (topologicalOrder == null) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Location prerequisites cannot be validated for the next activity as activity ");
                    String _name = activity.getName();
                    _builder.append(_name);
                    _builder.append(" contains a cycle");
                    this.error(_builder.toString(), (EObject)disp, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH__ACTIVITY);
                    positionState.clear();
                } else {
                    Functions.Function1 _function_4 = it -> it.isPositionMove();
                    Iterable _filter = IterableExtensions.filter((Iterable)QueryableIterable.from((Iterable)topologicalOrder).objectsOfKind(Move.class), (Functions.Function1)_function_4);
                    for (Move move : _filter) {
                        IResource _actualResource = DispatchingValidator.getActualResource(disp, move.getResource());
                        Peripheral _peripheral = move.getPeripheral();
                        ResourcePeripheralKey _resourcePeripheralKey = new ResourcePeripheralKey(_actualResource, _peripheral);
                        SymbolicPosition _targetPosition = move.getTargetPosition();
                        PositionInfo _positionInfo = new PositionInfo(_targetPosition, activity);
                        positionState.put(_resourcePeripheralKey, _positionInfo);
                    }
                }
            };
            IterableExtensions.forEach((Iterable)dispatchGroup.getDispatches(), (Procedures.Procedure2)_function_3);
        };
        activityDispatching.getDispatchGroups().forEach(_function_2);
    }

    @Check
    public void checkUnfolded(final ActivityDispatching activityDispatching) {
        final List<Dispatch> unfoldedDispatches = DispatchingValidator.unfoldedDispatches(activityDispatching);
        EventSequenceValidator.ErrorRaiser errorRaiser = new EventSequenceValidator.ErrorRaiser(){

            public void raise(int listIndex, String msg) {
                if (listIndex < 0) {
                    DispatchingValidator.this.error(msg, (EObject)activityDispatching, (EStructuralFeature)DispatchingPackage.Literals.ACTIVITY_DISPATCHING__DISPATCH_GROUPS);
                } else {
                    Dispatch d = (Dispatch)unfoldedDispatches.get(listIndex);
                    EObject _eContainer = d.eContainer();
                    DispatchGroup dg = (DispatchGroup)_eContainer;
                    DispatchingValidator.this.error(msg, (EObject)dg, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__DISPATCHES, dg.getDispatches().indexOf((Object)d));
                }
            }
        };
        Functions.Function1 _function = it -> it.getActivity();
        EventSequenceValidator.validate((List)IterableExtensions.toList((Iterable)ListExtensions.map(unfoldedDispatches, (Functions.Function1)_function)), (EventSequenceValidator.ErrorRaiser)errorRaiser);
        Functions.Function1 _function_1 = d -> {
            Functions.Function1 _function_2 = c -> Pair.of((Object)c, (Object)d);
            return IterableExtensions.map((Iterable)Iterables.filter((Iterable)d.getActivity().getNodes(), Claim.class), (Functions.Function1)_function_2);
        };
        Iterable claimsWithDispatches = IterableExtensions.flatMap(unfoldedDispatches, (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> ((Claim)it.getKey()).getResource();
        Functions.Function1 _function_3 = claims -> {
            Functions.Function2 _function_4 = (p1, p2) -> {
                boolean _isPassive_1;
                boolean _isPassive = ((Claim)p1.getKey()).isPassive();
                return _isPassive == (_isPassive_1 = ((Claim)p2.getKey()).isPassive());
            };
            Functions.Function1 _function_5 = it -> ((Claim)((Pair)IterableExtensions.head((Iterable)it)).getKey()).isPassive();
            Iterable passiveClaimsGroups = IterableExtensions.filter((Iterable)Queries.segment((Iterable)claims, (Functions.Function2)_function_4), (Functions.Function1)_function_5);
            Functions.Function1 _function_6 = passiveClaims -> {
                Functions.Function1 _function_7 = it -> ((Dispatch)it.getValue()).getActivity();
                Functions.Function1 _function_8 = it -> {
                    int _size = it.size();
                    return _size > 1;
                };
                Iterable duplicatePassiveClaims = Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)passiveClaims, (Functions.Function1)_function_7).values(), (Functions.Function1)_function_8));
                Functions.Function1 _function_9 = it -> (Dispatch)it.getValue();
                return IterableExtensions.map((Iterable)duplicatePassiveClaims, (Functions.Function1)_function_9);
            };
            return IterableExtensions.flatMap((Iterable)passiveClaimsGroups, (Functions.Function1)_function_6);
        };
        Iterable duplicatePassiveClaimDispatches = IterableExtensions.flatMap(IterableExtensions.groupBy((Iterable)claimsWithDispatches, (Functions.Function1)_function_2).values(), (Functions.Function1)_function_3);
        Consumer<Dispatch> _function_4 = dispatch -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Activity ");
            String _name = dispatch.getActivity().getName();
            _builder.append(_name);
            _builder.append(" cannot be repeated within a passive claim sequence.");
            this.error(_builder.toString(), (EObject)dispatch, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH__ACTIVITY);
        };
        Queries.unique((Iterable)duplicatePassiveClaimDispatches).forEach(_function_4);
    }

    private static List<Dispatch> unfoldedDispatches(ActivityDispatching activityDispatching) {
        ArrayList unfoldedDispatches = CollectionLiterals.newArrayList();
        Consumer<DispatchGroup> _function = dg -> {
            int _numberRepeats = DispatchingUtil.getNumberRepeats((DispatchGroup)dg);
            IntegerRange _upTo = new IntegerRange(1, _numberRepeats);
            for (Integer i : _upTo) {
                unfoldedDispatches.addAll(dg.getDispatches());
            }
        };
        activityDispatching.getDispatchGroups().forEach(_function);
        return unfoldedDispatches;
    }

    @Check
    public void validateRepeatAndOffset(DispatchGroup group) {
        if (BigDecimal.ZERO.compareTo(group.getOffset()) != 0 && DispatchingUtil.getNumberRepeats((DispatchGroup)group) > 1) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("offset must be ommited or zero when repeats are specified");
            String msg = _builder.toString();
            this.error(msg, (EObject)group, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__OFFSET);
            this.error(msg, (EObject)group, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__REPEATS, 0);
        }
    }

    @Check
    public void validateDispatchNameDuplicate(DispatchGroup group) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return _name != null;
        };
        Functions.Function1 _function_1 = it -> it.getName();
        Functions.Function1 _function_2 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<Dispatch> _function_3 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Duplicate name specified for Dispatch '");
            String _name = it.getName();
            _builder.append(_name);
            _builder.append("' Remove one");
            this.error(_builder.toString(), (EObject)it, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH__NAME, group.getUserAttributes().indexOf(it), REMOVE_ITEM, new String[0]);
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)IterableExtensions.filter((Iterable)group.getDispatches(), (Functions.Function1)_function), (Functions.Function1)_function_1).values(), (Functions.Function1)_function_2)).forEach(_function_3);
    }

    @Check
    public void validatePhase(AttributesMapEntryImpl entry) {
        boolean _equalsIgnoreCase_1;
        boolean _not;
        boolean _equalsIgnoreCase;
        DispatchGroup dispatchGroup = (DispatchGroup)EcoreUtil2.getContainerOfType((EObject)entry, DispatchGroup.class);
        if (dispatchGroup == null) {
            return;
        }
        boolean _and = false;
        Attribute _key = entry.getKey();
        String _name = null;
        if (_key != null) {
            _name = _key.getName();
        }
        if (_and = !(_equalsIgnoreCase = "phase".equalsIgnoreCase(_name)) ? false : (_not = !(_equalsIgnoreCase_1 = dispatchGroup.getName().equalsIgnoreCase(entry.getValue())))) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("phase is a reserved attribute and may not be used");
            String msg = _builder.toString();
            this.error(msg, (EObject)entry, (EStructuralFeature)DispatchingPackage.Literals.ATTRIBUTES_MAP_ENTRY__KEY);
        }
    }

    @Check
    public void validateIteratorName(AttributesMapEntryImpl entry) {
        int _numberRepeats;
        boolean _greaterThan;
        boolean _equalsIgnoreCase;
        DispatchGroup dispatchGroup = (DispatchGroup)EcoreUtil2.getContainerOfType((EObject)entry, DispatchGroup.class);
        if (dispatchGroup == null) {
            return;
        }
        boolean _and = false;
        String _iteratorName = dispatchGroup.getIteratorName();
        Attribute _key = entry.getKey();
        String _name = null;
        if (_key != null) {
            _name = _key.getName();
        }
        if (_and = !(_equalsIgnoreCase = _iteratorName.equalsIgnoreCase(_name)) ? false : (_greaterThan = (_numberRepeats = DispatchingUtil.getNumberRepeats((DispatchGroup)dispatchGroup)) > 1)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("attribute key may not be equal to activites iterator name. Change key or iterator name ");
            String msg = _builder.toString();
            this.error(msg, (EObject)entry, (EStructuralFeature)DispatchingPackage.Literals.ATTRIBUTES_MAP_ENTRY__KEY);
            boolean _eIsSet = dispatchGroup.eIsSet((EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__ITERATOR_NAME);
            if (_eIsSet) {
                this.error(msg, (EObject)dispatchGroup, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__ITERATOR_NAME);
            }
        }
    }

    @Check
    public void checkDispatchGroupNameUniqueInConstraint(Constraint constraint) {
        ActivityDispatching activityDispatching = null;
        EObject _eContainer = constraint.eContainer();
        if (_eContainer instanceof DispatchGroup) {
            EObject _eContainer_1 = constraint.eContainer();
            DispatchGroup dispatchGroup = (DispatchGroup)_eContainer_1;
            EObject _eContainer_2 = dispatchGroup.eContainer();
            activityDispatching = (ActivityDispatching)_eContainer_2;
        } else {
            EObject _eContainer_3 = constraint.eContainer();
            if (_eContainer_3 instanceof ActivityDispatching) {
                EObject _eContainer_4 = constraint.eContainer();
                activityDispatching = (ActivityDispatching)_eContainer_4;
            }
        }
        EObject _eContainer_5 = constraint.getSourceDispatch().eContainer();
        DispatchGroup sourceDispatchGroup = (DispatchGroup)_eContainer_5;
        EObject _eContainer_6 = constraint.getTargetDispatch().eContainer();
        DispatchGroup targetDispatchGroup = (DispatchGroup)_eContainer_6;
        String sourceDispatchGroupName = sourceDispatchGroup.getName();
        String targetDispatchGroupName = targetDispatchGroup.getName();
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equals(sourceDispatchGroupName, _name);
        };
        Functions.Function1 _function_1 = it -> it.getName();
        Functions.Function1 _function_2 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<DispatchGroup> _function_3 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Dispatch group name '");
            String _name = it.getName();
            _builder.append(_name);
            _builder.append("' must be unique for use in constraints.");
            this.error(_builder.toString(), (EObject)constraint, (EStructuralFeature)DispatchingPackage.Literals.CONSTRAINT__SOURCE_DISPATCH, CONSTRAINT_DISPATCH_NAME, new String[0]);
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)IterableExtensions.filter((Iterable)activityDispatching.getDispatchGroups(), (Functions.Function1)_function), (Functions.Function1)_function_1).values(), (Functions.Function1)_function_2)).forEach(_function_3);
        Functions.Function1 _function_4 = it -> {
            String _name = it.getName();
            return Objects.equals(targetDispatchGroupName, _name);
        };
        Functions.Function1 _function_5 = it -> it.getName();
        Functions.Function1 _function_6 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<DispatchGroup> _function_7 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Dispatch group name '");
            String _name = it.getName();
            _builder.append(_name);
            _builder.append("' must be unique for use in constraints.");
            this.error(_builder.toString(), (EObject)constraint, (EStructuralFeature)DispatchingPackage.Literals.CONSTRAINT__TARGET_DISPATCH, CONSTRAINT_DISPATCH_NAME, new String[0]);
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)IterableExtensions.filter((Iterable)activityDispatching.getDispatchGroups(), (Functions.Function1)_function_4), (Functions.Function1)_function_5).values(), (Functions.Function1)_function_6)).forEach(_function_7);
    }

    @Check
    public void checkConstraintBounds(Constraint constraint) {
        JitBounds _bounds = constraint.getBounds();
        if (_bounds instanceof TimeBounds) {
            BigDecimal _upper;
            boolean _greaterThan;
            JitBounds _bounds_1 = constraint.getBounds();
            TimeBounds timeBounds = (TimeBounds)_bounds_1;
            BigDecimal _lower = timeBounds.getLower();
            boolean bl = _greaterThan = _lower.compareTo(_upper = timeBounds.getUpper()) > 0;
            if (_greaterThan) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Time constraint between ");
                String _name = constraint.getSourceDispatch().getName();
                _builder.append(_name);
                _builder.append(".");
                String _name_1 = constraint.getSourceAction().getName();
                _builder.append(_name_1);
                _builder.append(" ");
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("and ");
                String _name_2 = constraint.getTargetDispatch().getName();
                _builder_1.append(_name_2);
                _builder_1.append(".");
                String _name_3 = constraint.getTargetAction().getName();
                _builder_1.append(_name_3);
                _builder_1.append(" ");
                String _plus = _builder.toString() + String.valueOf(_builder_1);
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("must have a lower bound less than or equal to the upper bound");
                String _plus_1 = _plus + String.valueOf(_builder_2);
                this.error(_plus_1, (EObject)constraint, (EStructuralFeature)ActivityPackage.Literals.TIME_BOUNDS__LOWER, CONSTRAINT_LIMITS, new String[0]);
            }
        }
    }

    @Check
    public void checkParameters(Dispatch dis) {
        int _size_3;
        int _size_2;
        boolean _lessThan_1;
        int _size_1;
        boolean _lessThan;
        EList parameters = dis.getParameters();
        List declarations = ActivityParametersUtil.getDeclarations((Activity)dis.getActivity());
        int _size = parameters.size();
        boolean bl = _lessThan = _size < (_size_1 = declarations.size());
        if (_lessThan) {
            TypeDefinition dec = (TypeDefinition)declarations.get(parameters.size());
            EClass declType = ActivityParametersUtil.getExpectedType((EObject)dec, null);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No item specified for '");
            String _name = dec.getName();
            _builder.append(_name);
            _builder.append(":");
            String _name_1 = declType.getName();
            _builder.append(_name_1);
            _builder.append("' Press <ctrl> spacebar");
            this.error(_builder.toString(), (EObject)dis, (EStructuralFeature)CommonPackage.Literals.HAS_PARAMETERS__PARAMETERS, parameters.size());
        }
        boolean bl2 = _lessThan_1 = (_size_2 = declarations.size()) < (_size_3 = parameters.size());
        if (_lessThan_1) {
            Parameter par = (Parameter)parameters.get(declarations.size());
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Unnecessary parameter specified. Please remove it");
            this.error(_builder_1.toString(), (EObject)par, (EStructuralFeature)CommonPackage.Literals.PARAMETER__REFERENCES, declarations.size());
        }
        int size = Math.min(parameters.size(), declarations.size());
        int index = 0;
        while (index < size) {
            boolean _isEmpty;
            boolean _not;
            Parameter par_1 = (Parameter)parameters.get(index);
            TypeDefinition dec_1 = par_1.getDeclaration();
            if (dec_1 == null) {
                dec_1 = (TypeDefinition)declarations.get(index);
            }
            boolean bl3 = _not = !(_isEmpty = par_1.getReferences().isEmpty());
            if (_not) {
                HasName actualParType;
                boolean _matchesType;
                boolean _not_1;
                EList _references = par_1.getReferences();
                ParameterReference _last = null;
                if (_references != null) {
                    _last = (ParameterReference)_references.getLast();
                }
                HasName _reference = null;
                if (_last != null) {
                    _reference = _last.getReference();
                }
                boolean bl4 = _not_1 = !(_matchesType = ActivityParametersUtil.matchesType((TypeDefinition)dec_1, (EObject)(actualParType = _reference)));
                if (_not_1) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("Parameter '");
                    String _name_2 = dec_1.getName();
                    _builder_2.append(_name_2);
                    _builder_2.append("' type mismatch, expecting '");
                    String _name_3 = ActivityParametersUtil.getExpectedType((EObject)dec_1, (EObject)actualParType).getName();
                    _builder_2.append(_name_3);
                    _builder_2.append("' but got '");
                    String _name_4 = actualParType.eClass().getName();
                    String _plus = _name_4 + "'";
                    _builder_2.append(_plus);
                    int _size_4 = par_1.getReferences().size();
                    int _minus = _size_4 - 1;
                    this.error(_builder_2.toString(), (EObject)par_1, (EStructuralFeature)CommonPackage.Literals.PARAMETER__REFERENCES, _minus);
                }
            }
            ++index;
        }
        ArrayList actions = CollectionLiterals.newArrayList();
        for (Parameter par_1 : parameters) {
            boolean _not;
            HasName _xifexpression = null;
            boolean _isEmpty = par_1.getReferences().isEmpty();
            if (_isEmpty) {
                _xifexpression = null;
            } else {
                ParameterReference _last = (ParameterReference)par_1.getReferences().getLast();
                HasName _reference = null;
                if (_last != null) {
                    _reference = _last.getReference();
                }
                _xifexpression = _reference;
            }
            HasName actualParType = _xifexpression;
            if (actualParType instanceof ActionType) {
                actions.add(par_1);
            }
            if (!(actualParType instanceof IResource) || actualParType instanceof Event) continue;
            boolean _isEmpty_1 = actions.isEmpty();
            boolean bl5 = _not = !_isEmpty_1;
            if (!_not) continue;
            List<Parameter> _of = List.of(par_1);
            Iterable _plus = Iterables.concat((Iterable)actions, _of);
            for (Parameter p : _plus) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Machine 'Resource' parameters must precede 'Action' parameters");
                this.error(_builder_2.toString(), (EObject)p, (EStructuralFeature)CommonPackage.Literals.PARAMETER__REFERENCES);
            }
        }
    }

    private LinkedHashMap<ResourcePeripheralKey, SymbolicPosition> indexPrerequisites(Dispatch disp, int index) {
        EList prerequisites = disp.getActivity().getPrerequisites();
        LinkedHashMap result = CollectionLiterals.newLinkedHashMap();
        for (LocationPrerequisite prerequisite : prerequisites) {
            Peripheral _peripheral;
            IResource _actualResource = DispatchingValidator.getActualResource(disp, prerequisite.getResource());
            ResourcePeripheralKey key = new ResourcePeripheralKey(_actualResource, _peripheral = prerequisite.getPeripheral());
            boolean _containsKey = result.containsKey(key);
            if (_containsKey) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Only one location prerequisite per peripheral is allowed");
                this.error(_builder.toString(), (EObject)disp, (EStructuralFeature)DispatchingPackage.Literals.DISPATCH__ACTIVITY);
            }
            result.put(key, prerequisite.getPosition());
        }
        return result;
    }

    private static IResource getActualResource(Dispatch dispatch, IResource resource) {
        Functions.Function1 _function = it -> {
            Resource _resource = it.getResource();
            return _resource == resource;
        };
        IResource result = (IResource)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)dispatch.getParameters(), IResource.class), (Functions.Function1)_function);
        IResource _xifexpression = null;
        _xifexpression = result == null ? resource : result;
        return _xifexpression;
    }

    private static final class PositionInfo {
        private final SymbolicPosition position;
        private final Activity activity;

        PositionInfo(SymbolicPosition position, Activity activity) {
            this.position = position;
            this.activity = activity;
        }
    }
}

