/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.meanpayoff.solvers.energy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.math3.fraction.Fraction;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.SingleWeightFunctionInt;
import org.eclipse.lsat.common.ludus.backend.games.algorithms.GraphChecks;
import org.eclipse.lsat.common.ludus.backend.games.energy.solvers.SEPM;
import org.eclipse.lsat.common.ludus.backend.games.energy.solvers.ValueIterationInt;
import org.eclipse.lsat.common.ludus.backend.games.meanpayoff.solvers.energy.MeanPayoffGameEnergy;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.energy.EGIntImplJGraphT;

public class ValueIterationReductionInt {
    private ValueIterationReductionInt() {
    }

    public static <V, E> Map<V, Fraction> solve(MeanPayoffGameEnergy<V, E, Integer> game) {
        HashMap vertexMap = new HashMap();
        Fraction w = new Fraction(((Integer)game.getMaxAbsValue()).intValue());
        Fraction minusW = w.negate();
        if (GraphChecks.checkEachNodeHasSuccessor(game)) {
            ValueIterationReductionInt.findValues(game, minusW, w, vertexMap);
            return vertexMap;
        }
        System.out.println("Input game graph is not valid. Not every vertex has a successor.");
        return null;
    }

    private static <V, E> void findValues(MeanPayoffGameEnergy<V, E, Integer> game, Fraction lowerBound, Fraction upperBound, Map<V, Fraction> valueMap) {
        if (!game.getVertices().isEmpty()) {
            Fraction middle = lowerBound.add(upperBound).multiply(Fraction.ONE_HALF);
            Integer vSize = game.getVertices().size();
            Integer w = (Integer)game.getMaxAbsValue();
            Fraction a1 = ValueIterationReductionInt.findMaxInRange(vSize, w, lowerBound, middle);
            Fraction a2 = ValueIterationReductionInt.findMinInRange(vSize, w, middle, upperBound);
            Integer q1 = a1.getNumerator();
            Integer l1 = a1.getDenominator();
            Integer q2 = a2.getNumerator();
            Integer l2 = a2.getDenominator();
            MeanPayoffGameEnergy<V, E, Integer> gameSwapped = game.getSwappedSubGraph(game.getVertices());
            SingleWeightFunctionInt<E> wf1 = ValueIterationReductionInt.reweight(game, l1, -q1.intValue());
            EGIntImplJGraphT game1 = new EGIntImplJGraphT(game, wf1);
            SEPM f1 = ValueIterationInt.getProgressMeasure(game1);
            SingleWeightFunctionInt<E> wf2 = ValueIterationReductionInt.reweight(game, -l1.intValue(), q1);
            EGIntImplJGraphT game2 = new EGIntImplJGraphT(gameSwapped, wf2);
            SEPM f2 = ValueIterationInt.getProgressMeasure(game2);
            SingleWeightFunctionInt<E> wf3 = ValueIterationReductionInt.reweight(game, l2, -q2.intValue());
            EGIntImplJGraphT game3 = new EGIntImplJGraphT(game, wf3);
            SEPM f3 = ValueIterationInt.getProgressMeasure(game3);
            SingleWeightFunctionInt<E> wf4 = ValueIterationReductionInt.reweight(game, -l2.intValue(), q2);
            EGIntImplJGraphT game4 = new EGIntImplJGraphT(gameSwapped, wf4);
            SEPM f4 = ValueIterationInt.getProgressMeasure(game4);
            game.getVertices().stream().map(v -> {
                if (!((Integer)f1.getValue(v)).equals(ValueIterationInt.TOP) && !((Integer)f2.getValue(v)).equals(ValueIterationInt.TOP)) {
                    valueMap.put(v, a1);
                }
                return v;
            }).filter(v -> !((Integer)f3.getValue(v)).equals(ValueIterationInt.TOP) && !((Integer)f4.getValue(v)).equals(ValueIterationInt.TOP)).forEach(v -> {
                Fraction fraction2 = valueMap.put(v, a2);
            });
            HashSet vSmallera1 = new HashSet();
            game.getVertices().stream().filter(v -> ((Integer)f1.getValue(v)).equals(ValueIterationInt.TOP)).forEach(vSmallera1::add);
            HashSet vLargera2 = new HashSet();
            game.getVertices().stream().filter(v -> ((Integer)f4.getValue(v)).equals(ValueIterationInt.TOP)).forEach(vLargera2::add);
            MeanPayoffGameEnergy<V, E, Integer> subGameSmallerVertices = game.getSubGraph(vSmallera1);
            MeanPayoffGameEnergy<V, E, Integer> subGameLargerVertices = game.getSubGraph(vLargera2);
            ValueIterationReductionInt.findValues(subGameSmallerVertices, lowerBound, a1, valueMap);
            ValueIterationReductionInt.findValues(subGameLargerVertices, a2, upperBound, valueMap);
        }
    }

    private static Fraction findMaxInRange(Integer vertexSize, Integer maxWeight, Fraction lowerBound, Fraction upperBound) {
        Fraction min;
        Fraction max = min = lowerBound;
        int m = 1;
        while (m <= vertexSize) {
            int p = -m * maxWeight;
            while (p <= m * maxWeight) {
                Fraction pm = new Fraction(p, m);
                if (pm.compareTo(lowerBound) != -1 && pm.compareTo(upperBound) != 1 && pm.compareTo(max) > 0) {
                    max = pm;
                }
                ++p;
            }
            ++m;
        }
        return max;
    }

    private static Fraction findMinInRange(Integer vertexSize, Integer maxWeight, Fraction lowerBound, Fraction upperBound) {
        Fraction max;
        Fraction min = max = upperBound;
        int m = 1;
        while (m <= vertexSize) {
            int p = -m * maxWeight;
            while (p <= m * maxWeight) {
                Fraction pm = new Fraction(p, m);
                if (pm.compareTo(lowerBound) != -1 && pm.compareTo(upperBound) != 1 && pm.compareTo(min) < 0) {
                    min = pm;
                }
                ++p;
            }
            ++m;
        }
        return min;
    }

    private static <V, E> SingleWeightFunctionInt<E> reweight(MeanPayoffGameEnergy<V, E, Integer> game, Integer multiplyConstant, Integer addConstant) {
        SingleWeightFunctionInt newFunction = new SingleWeightFunctionInt();
        for (Object edge : game.getEdges()) {
            Integer weight = multiplyConstant * (Integer)game.getWeight(edge) + addConstant;
            newFunction.addWeight(edge, weight);
        }
        return newFunction;
    }
}

