/*
 * Decompiled with CFR 0.152.
 */
package activity.util;

import activity.Action;
import activity.Activity;
import activity.ActivityFactory;
import activity.ActivitySet;
import activity.Claim;
import activity.Release;
import activity.ResourceAction;
import activity.SyncBar;
import activity.impl.ActivityQueries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import machine.IResource;
import machine.ResourceItem;
import machine.ResourceType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsat.common.graph.directed.editable.EdgFactory;
import org.eclipse.lsat.common.graph.directed.editable.Edge;
import org.eclipse.lsat.common.graph.directed.editable.EdgeTarget;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.common.graph.directed.editable.SourceReference;
import org.eclipse.lsat.common.graph.directed.editable.TargetReference;
import org.eclipse.lsat.common.queries.QueryableIterable;

public final class ActivityUtil {
    private static final String ITEM_DELIMITER = "_";
    public static final String EXPAND_DELIMITER = "_";

    private ActivityUtil() {
    }

    public static String expandName(Activity activity, Collection<ResourceItem> resources) {
        String name = activity.getName();
        if (!resources.isEmpty()) {
            return activity.getResourcesNeedingItem().stream().map(r -> resources.stream().filter(i -> i.getResource() == r).map(IResource::getName).findFirst().get()).collect(Collectors.joining("_", String.valueOf(name) + "_", ""));
        }
        return name;
    }

    public static String displayName(Activity activity) {
        if (activity == null) {
            return null;
        }
        if (activity.getOriginalName() == null) {
            return activity.getName();
        }
        return ActivityUtil.getItemNames(activity.getOriginalName(), activity.getName()).stream().collect(Collectors.joining(",", String.valueOf(activity.getOriginalName()) + "[", "]"));
    }

    public static Collection<String> getItemNames(String orgActivityName, String expandedActivityName) {
        if (expandedActivityName.startsWith(String.valueOf(orgActivityName) + "_")) {
            return Arrays.asList(expandedActivityName.substring(orgActivityName.length() + "_".length()).split("_"));
        }
        return Collections.emptyList();
    }

    public static Activity queryCreateExpandedActivity(Activity orgActivity, Collection<ResourceItem> items) {
        EObject eContainer = orgActivity.eContainer();
        if (eContainer == null) {
            throw new RuntimeException("Activity is not part of a container");
        }
        if (!(eContainer instanceof ActivitySet)) {
            throw new RuntimeException("Activity must be part of an ActivitySet");
        }
        ActivitySet set = (ActivitySet)eContainer;
        EList<Activity> activities = set.getActivities();
        String activityName = ActivityUtil.expandName(orgActivity, items);
        Activity result = (Activity)QueryableIterable.from(set.getActivities()).select(a -> a.getName().equals(activityName)).first();
        if (result == null) {
            result = ActivityUtil.expand(orgActivity, items);
            activities.add(activities.indexOf((Object)orgActivity), (Object)result);
        }
        return result;
    }

    private static Activity expand(Activity activity, Collection<ResourceItem> resources) {
        Activity result = (Activity)EcoreUtil.copy((EObject)activity);
        result.setOriginalName(activity.getName());
        result.setName(ActivityUtil.expandName(activity, resources));
        String expansion = result.getName().substring(activity.getName().length());
        QueryableIterable.from(resources).forEach(item -> {
            QueryableIterable.from((Iterable)result.getNodes()).objectsOfKind(ResourceAction.class).select(a -> a.getResource().equals(item.getResource())).forEach(a -> a.setResource((IResource)item));
            QueryableIterable.from(result.getPrerequisites()).select(p -> p.getResource().equals(item.getResource())).forEach(p -> p.setResource((IResource)item));
        });
        return result;
    }

    public static void addEdge(Activity activity, Node source, Node target) {
        if (!ActivityUtil.edgeExists(activity, source, target)) {
            Edge edge = EdgFactory.eINSTANCE.createEdge();
            SourceReference sourceRef = EdgFactory.eINSTANCE.createSourceReference();
            sourceRef.setNode(source);
            edge.setSource(sourceRef);
            TargetReference targetRef = EdgFactory.eINSTANCE.createTargetReference();
            targetRef.setNode(target);
            edge.setTarget((EdgeTarget)targetRef);
            activity.getEdges().add((Object)edge);
        }
    }

    public static <T extends Node> void process(ActivitySet activitySet, Class<T> clazz, Consumer<? super T> predicate) {
        activitySet.getActivities().forEach(a -> ActivityUtil.process(a, clazz, predicate));
    }

    public static <T extends Node> void process(Activity activity, Class<T> clazz, Consumer<? super T> predicate) {
        new ArrayList(activity.getNodes()).stream().filter(clazz::isInstance).map(clazz::cast).distinct().forEach(predicate);
    }

    private static boolean edgeExists(Activity activity, Node source, Node target) {
        return activity.getEdges().stream().anyMatch(e -> e.getSource() == source && e.getTarget() == target);
    }

    public static SyncBar addSyncBar(Activity activity) {
        SyncBar syncBar = ActivityFactory.eINSTANCE.createSyncBar();
        syncBar.setName(ActivityUtil.getFirstFreeName("S", activity));
        activity.getNodes().add((Object)syncBar);
        return syncBar;
    }

    public static Release addRelease(Activity activity, IResource resource) {
        if (ActivityUtil.getReleases(activity, resource).isEmpty()) {
            Release release = ActivityFactory.eINSTANCE.createRelease();
            release.setName(ActivityUtil.getFirstFreeName("R", activity));
            release.setResource(resource);
            activity.getNodes().add((Object)release);
        }
        return ActivityUtil.getReleases(activity, resource).iterator().next();
    }

    public static Claim addClaim(Activity activity, IResource resource) {
        if (ActivityUtil.getClaims(activity, resource).isEmpty()) {
            Claim claim = ActivityFactory.eINSTANCE.createClaim();
            claim.setName(ActivityUtil.getFirstFreeName("C", activity));
            claim.setResource(resource);
            activity.getNodes().add((Object)claim);
        }
        return ActivityUtil.getClaims(activity, resource).iterator().next();
    }

    public static void insertSyncBars(Action action) {
        SyncBar syncBar;
        Activity activity = (Activity)action.getGraph();
        if (action.getIncomingEdges().size() > 1) {
            syncBar = ActivityUtil.addSyncBar(activity);
            action.getIncomingEdges().stream().map(Edge::getSourceNode).forEach(s -> ActivityUtil.addEdge(activity, s, syncBar));
            new ArrayList<Edge>((Collection<Edge>)action.getIncomingEdges()).forEach(ActivityUtil::delete);
            ActivityUtil.addEdge(activity, syncBar, action);
        }
        if (action.getOutgoingEdges().size() > 1) {
            syncBar = ActivityUtil.addSyncBar(activity);
            action.getOutgoingEdges().stream().map(Edge::getTargetNode).forEach(s -> ActivityUtil.addEdge(activity, syncBar, s));
            new ArrayList<Edge>((Collection<Edge>)action.getOutgoingEdges()).forEach(ActivityUtil::delete);
            ActivityUtil.addEdge(activity, action, syncBar);
        }
    }

    public static void delete(Node node) {
        for (Edge edge : node.getIncomingEdges()) {
            ActivityUtil.delete(edge);
        }
        for (Edge edge : node.getOutgoingEdges()) {
            ActivityUtil.delete(edge);
        }
        EcoreUtil.delete((EObject)node);
    }

    public static void delete(Edge edge) {
        if (edge.getTarget() instanceof Edge) {
            edge.getGraph().getEdges().add((Object)((Edge)edge.getTarget()));
        }
        if (edge.getEdge() != null) {
            TargetReference target = EdgFactory.eINSTANCE.createTargetReference();
            target.setNode(edge.getSource().getNode());
            edge.getEdge().setTarget((EdgeTarget)target);
        }
        edge.setTarget(null);
        edge.setSource(null);
        EcoreUtil.delete((EObject)edge);
    }

    public static String getFirstFreeName(String prefix, Activity activity) {
        Collection names = activity.getNodes().stream().map(n -> n.getName()).collect(Collectors.toSet());
        int i = 1;
        while (names.contains(String.valueOf(prefix) + i)) {
            ++i;
        }
        return String.valueOf(prefix) + i;
    }

    public static String getPassiveName(IResource resource) {
        if (resource.getResource().getResourceType() == ResourceType.PASSIVE) {
            return resource.getName();
        }
        return String.valueOf(ResourceType.PASSIVE.getName()) + '_' + resource.fqn().replace('.', '_');
    }

    public static Collection<Claim> getClaims(Activity activity, IResource resource) {
        return ActivityQueries.getActionsFor(resource, Claim.class, (Iterable<Node>)activity.getNodes()).asList();
    }

    public static Collection<Release> getReleases(Activity activity, IResource resource) {
        return ActivityQueries.getActionsFor(resource, Release.class, (Iterable<Node>)activity.getNodes()).asList();
    }
}

