/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.CommentRemover;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class SystemTapRegexGenerator {
    public static List<Map.Entry<String, Integer>> generateFromPrintf(IPath scriptPath, int maxToFind) {
        ArrayList<Map.Entry<String, Integer>> regexs = new ArrayList<Map.Entry<String, Integer>>();
        if (maxToFind == 0) {
            return regexs;
        }
        String contents = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IEditorPart editor = ResourceUtil.findEditor((IWorkbenchPage)workbench.getActiveWorkbenchWindow().getActivePage(), (IFile)root.getFile(scriptPath.makeRelativeTo(root.getLocation())));
        if (editor != null) {
            ITextEditor tEditor = (ITextEditor)editor.getAdapter(ITextEditor.class);
            IDocument document = tEditor.getDocumentProvider().getDocument((Object)tEditor.getEditorInput());
            contents = CommentRemover.exec(document.get());
        } else {
            contents = CommentRemover.execWithFile(scriptPath.toString());
        }
        Pattern pattern = Pattern.compile("(?<=[^\\w])printf\\(\"(.+?)\",.+?\\)");
        Matcher matcher = pattern.matcher(contents);
        while (matcher.find() && (maxToFind < 0 || regexs.size() < maxToFind)) {
            String regex = null;
            Pattern format = Pattern.compile("%([-\\+ \\#0])?(\\d+)?(\\.\\d*)?l?([bcdiopsuxX%])");
            String[] printls = matcher.group(1).split("\\\\n");
            for (int i = 0; i < printls.length; ++i) {
                String printl = printls[i];
                if (printl.endsWith("\\")) {
                    printls[i + 1] = printl.concat("\\n" + printls[i + 1]);
                    continue;
                }
                Matcher fmatch = format.matcher(printl);
                int lastend = 0;
                int numColumns = 0;
                while (fmatch.find()) {
                    char chr;
                    ++numColumns;
                    char c = chr = fmatch.group(4) == null ? (char)'\u0000' : fmatch.group(4).charAt(0);
                    if (chr == '\u0000') {
                        regex = null;
                        break;
                    }
                    char flag = fmatch.group(1) == null ? (char)'\u0000' : fmatch.group(1).charAt(0);
                    int width = fmatch.group(2) == null ? 0 : Integer.parseInt(fmatch.group(2));
                    String precision = fmatch.group(3) == null ? null : fmatch.group(3).substring(1);
                    String pre = SystemTapRegexGenerator.addRegexEscapes(printl.substring(lastend, fmatch.start()));
                    regex = lastend > 0 ? regex.concat(pre) : pre;
                    lastend = fmatch.end();
                    Object target = "(";
                    if (chr == 'u' || flag != '#' && chr == 'o') {
                        target = ((String)target).concat("\\d+");
                    } else if (chr == 'd' || chr == 'i') {
                        if (flag == '+') {
                            target = ((String)target).concat("\\+|");
                        } else if (flag == ' ') {
                            target = ((String)target).concat(" |");
                        }
                        target = ((String)target).concat("-?\\d+");
                    } else if (flag == '#' && chr == 'o') {
                        target = ((String)target).concat("0\\d+");
                    } else if (chr == 'p') {
                        target = ((String)target).concat("0x[a-f0-9]+");
                    } else if (chr == 'x') {
                        if (flag == '#') {
                            target = ((String)target).concat("0x");
                        }
                        target = ((String)target).concat("[a-f0-9]+");
                    } else if (chr == 'X') {
                        if (flag == '#') {
                            target = ((String)target).concat("0X");
                        }
                        target = ((String)target).concat("[A-F0-9]+");
                    } else if (chr == 'b') {
                        target = ((String)target).concat(".");
                    } else if (chr == 'c') {
                        target = flag != '#' ? ((String)target).concat(".") : ((String)target).concat("\\([a-z]|[0-9]{3})|.|\\\\");
                    } else if (chr == 's') {
                        target = precision != null ? ((String)target).concat(".{" + precision + "}") : ((String)target).concat(".+");
                    } else {
                        regex = null;
                        break;
                    }
                    target = ((String)target).concat(")");
                    if (chr != 'b' && --width > 0) {
                        if (flag == '-') {
                            target = ((String)target).concat(" {0," + width + "}");
                        } else if (flag != '0' || chr == 's' || chr == 'c') {
                            target = " {0," + width + "}".concat((String)target);
                        }
                    }
                    regex = regex.concat((String)target);
                }
                if (regex == null) continue;
                regexs.add(new AbstractMap.SimpleEntry<String, Integer>(regex.concat(SystemTapRegexGenerator.addRegexEscapes(printl.substring(lastend))), numColumns));
            }
        }
        return regexs;
    }

    private static String addRegexEscapes(String s) {
        String schars = "[^$.|?*+(){}";
        for (int i = 0; i < schars.length(); ++i) {
            s = s.replaceAll("(\\" + schars.substring(i, i + 1) + ")", "\\\\$1");
        }
        return s;
    }

    public static enum ErrResult {
        IO_EXCEPTION;

    }
}

