/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.apache5.connector;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.glassfish.jersey.client.ClientRequest;

public interface Apache5ConnectionClosingStrategy {
    public void close(ClientRequest var1, HttpUriRequest var2, CloseableHttpResponse var3, InputStream var4) throws IOException;

    public static class Apache5GracefulClosingStrategy
    implements Apache5ConnectionClosingStrategy {
        private static final String UNIX_PROTOCOL = "unix";
        static final Apache5GracefulClosingStrategy INSTANCE = new Apache5GracefulClosingStrategy();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(ClientRequest clientRequest, HttpUriRequest request, CloseableHttpResponse response, InputStream stream) throws IOException {
            boolean isUnixProtocol = false;
            try {
                isUnixProtocol = UNIX_PROTOCOL.equals(request.getUri().getScheme());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (response.getEntity() != null && response.getEntity().isChunked() && !isUnixProtocol) {
                request.abort();
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                response.close();
            }
        }
    }
}

