/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.piecharts;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.ICircularSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ChartType;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.events.CircularMouseDownEvent;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;
import org.eclipse.swtchart.extensions.events.MouseDownEvent;
import org.eclipse.swtchart.extensions.exceptions.SeriesException;
import org.eclipse.swtchart.extensions.menu.toggle.ToggleLabelTooltipsHandler;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesData;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesSettings;

public class PieChart
extends ScrollableChart {
    public PieChart() {
        this.setChartType(ChartType.PIE);
        this.setData("org.eclipse.e4.ui.css.CssClassName", "BarChart");
    }

    public PieChart(Composite parent, int style) {
        super(parent, style);
        this.setChartType(ChartType.PIE);
        this.setData("org.eclipse.e4.ui.css.CssClassName", "BarChart");
    }

    public void addSeriesData(ICircularSeriesData seriesData) {
        if (seriesData != null && seriesData.getRootNode() != null) {
            BaseChart baseChart = this.getBaseChart();
            baseChart.suspendUpdate(true);
            try {
                IChartSettings chartSettings = this.getChartSettings();
                chartSettings.setHorizontalSliderVisible(false);
                chartSettings.setVerticalSliderVisible(false);
                chartSettings.getRangeRestriction().setZeroX(false);
                chartSettings.getRangeRestriction().setZeroY(false);
                chartSettings.setLegendVisible(true);
                chartSettings.setShowLegendMarker(true);
                this.adjustPrimaryAxisX(chartSettings, seriesData);
                this.adjustPrimaryAxisY(chartSettings, seriesData);
                this.adjustEventProcessors(chartSettings);
                this.adjustMenuEntries(chartSettings);
                this.applySettings(chartSettings);
                ICircularSeriesSettings seriesSettings = seriesData.getSettings();
                ICircularSeries<?> circularSeries = this.createCircularSeries(seriesData, seriesSettings);
                baseChart.applySeriesSettings((ISeries<?>)circularSeries, seriesSettings);
            }
            catch (SeriesException seriesException) {
                // empty catch block
            }
            baseChart.suspendUpdate(false);
            this.adjustRange(true);
            baseChart.redraw();
        }
    }

    private void adjustPrimaryAxisX(IChartSettings chartSettings, ICircularSeriesData seriesData) {
        IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
        primaryAxisSettingsX.setTitle(seriesData.getNodeClass());
        primaryAxisSettingsX.setVisible(false);
    }

    private void adjustPrimaryAxisY(IChartSettings chartSettings, ICircularSeriesData seriesData) {
        IPrimaryAxisSettings primaryAxisSettingsY = chartSettings.getPrimaryAxisSettingsY();
        primaryAxisSettingsY.setTitle(seriesData.getValueClass());
        primaryAxisSettingsY.setVisible(false);
    }

    private void adjustEventProcessors(IChartSettings chartSettings) {
        IHandledEventProcessor handledEventProcessor = null;
        for (IHandledEventProcessor processor : chartSettings.getHandledEventProcessors()) {
            if (!(processor instanceof MouseDownEvent)) continue;
            handledEventProcessor = processor;
            break;
        }
        if (handledEventProcessor != null) {
            chartSettings.removeHandledEventProcessor(handledEventProcessor);
        }
        CircularMouseDownEvent circularHandledEventProcessor = new CircularMouseDownEvent(this);
        chartSettings.addHandledEventProcessor(circularHandledEventProcessor);
    }

    private void adjustMenuEntries(IChartSettings chartSettings) {
        chartSettings.setEnableTooltips(false);
        chartSettings.removeMenuEntry(chartSettings.getChartMenuEntryByClass(ToggleLabelTooltipsHandler.class));
    }
}

